<?php
spl_autoload_register(function ($class) {
    $prefixMap = [
        'PhpOffice\\PhpSpreadsheet\\' => __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/',
        'Psr\\SimpleCache\\' => __DIR__ . '/psr/simple-cache/src/',
    ];

    foreach ($prefixMap as $prefix => $base_dir) {
        $len = strlen($prefix);
        if (strncmp($prefix, $class, $len) !== 0) {
            continue;
        }

        $relative_class = substr($class, $len);
        $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

        if (file_exists($file)) {
            require $file;
            return;
        }
    }
});
