<?php
include(__DIR__ . '/../includes/koneksi.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $link = $_POST['link'] ?? null;
    $approval_status_level1 = $_POST['approval_status_level1'] ?? null;
    $date_menunggu_1 = $_POST['date_menunggu_1'] ?? null;
    $final_status = $_POST['final_status'] ?? null;

    // Jika final_status = selesai, isi date_selesai sekarang
    if (strtolower($final_status) === 'selesai') {
        $date_selesai = date('Y-m-d H:i:s');

        $stmt = $conn->prepare("UPDATE todolist 
            SET link = ?, 
                final_status = ?, 
                date_selesai = ?
            WHERE id = ?");
        $stmt->bind_param("sssi", $link, $final_status, $date_selesai, $id);
    } else {
        // Versi bawahan (tetap seperti semula)
        $stmt = $conn->prepare("UPDATE todolist 
            SET link = ?, 
                approval_status_level1 = ?, 
                date_menunggu_1 = ?, 
                final_status = ?
            WHERE id = ?");
        $stmt->bind_param("ssssi", $link, $approval_status_level1, $date_menunggu_1, $final_status, $id);
    }

    if ($stmt->execute()) {
        header("Location: todolist.php?success=1");
    } else {
        header("Location: todolist.php?error=1");
    }
    $stmt->close();
}
