<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$query = "SELECT id, tipe, nama, access_modul FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'user') {
    header('Location: ../login.php');
    exit();
}

$access_modul = json_decode($user['access_modul'], true);
if (empty($access_modul['todolist']) || $access_modul['todolist'] !== 'on') {
    header('Location: ../login.php');
    exit();
}

$user_id = $user['id'];
$name    = $user['nama'];

date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;


function getApproverName($conn, $pic_id, $unit_id, $urutan)
{
    $stmt = $conn->prepare("
        SELECT u.nama 
        FROM approval_chain ac
        JOIN users u ON ac.approver_id = u.id
        WHERE ac.user_id = ? AND ac.unit_id = ? AND ac.urutan = ?
        LIMIT 1
    ");
    $stmt->bind_param("iii", $pic_id, $unit_id, $urutan);
    $stmt->execute();
    $stmt->bind_result($nama);
    $stmt->fetch();
    $stmt->close();
    return $nama ?: '-';
}

/* ======================
   Fungsi helper
   ====================== */
function getSearchData($conn, $table, $fields, $limit, $page, $search, $order = 'id ASC', $whereExtra = '')
{
    $offset = ($page - 1) * $limit;
    $whereClause = '';

    $fieldMap = [
        'uraian_todolist' => 't.uraian_todolist',
        'deadline' => 't.deadline',
        'pic' => 'u.nama',
        'unit_id' => 'un.unit_name',
        'keterangan' => 't.keterangan',
        'link' => 't.link',
        'final_status' => 't.final_status',
        'progres_status' => 't.progres_status',
        'date_selesai' => 't.date_selesai',
        'created_at' => 't.created_at'
    ];

    if (!empty($search)) {
        $likeClauses = [];
        foreach ($fields as $field) {
            $col = isset($fieldMap[$field]) ? $fieldMap[$field] : "t.$field";
            $likeClauses[] = "$col LIKE '%" . $conn->real_escape_string($search) . "%'";
        }
        $whereClause = 'WHERE (' . implode(' OR ', $likeClauses) . ')';
    }

    if ($table === 'todolist') {
        if ($whereClause) {
            $whereClause .= " $whereExtra";
        } else {
            $whereClause = "WHERE 1=1 $whereExtra";
        }

        $sqlBase = "
            FROM todolist t
            LEFT JOIN users u ON t.pic = u.id
            LEFT JOIN unit un ON t.unit_id = un.id
            $whereClause
        ";
        $resTotal = $conn->query("SELECT COUNT(*) $sqlBase");
        $total = $resTotal->fetch_row()[0];

        $sql = "SELECT t.*, u.nama AS pic_nama, un.unit_name $sqlBase ORDER BY $order";
        if ($limit !== PHP_INT_MAX) {
            $sql .= " LIMIT $offset, $limit";
        }
    }

    $data = $conn->query($sql);
    $totalPages = ($limit === PHP_INT_MAX) ? 1 : ceil($total / $limit);
    return ['data' => $data, 'totalPages' => $totalPages, 'totalRows' => $total];
}

/* ======================
   Filter hanya PIC diri sendiri
   ====================== */
/* ======================
   Deteksi status atasan sesuai syarat
   ====================== */
$isBawahan = false;
$isAtasanAkhir = false;
$isAturan3 = false;

// Cek bawahan
$stmt = $conn->prepare("SELECT COUNT(*) FROM approval_chain WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($countBawahan);
$stmt->fetch();
$stmt->close();
$isBawahan = $countBawahan > 0;

// Cek atasan akhir (urutan = 2)
$stmt = $conn->prepare("SELECT COUNT(*) FROM approval_chain WHERE approver_id = ? AND urutan = 2");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($countAkhir);
$stmt->fetch();
$stmt->close();
$isAtasanAkhir = $countAkhir > 0;

// Cek aturan 3 (tidak ada di approval_chain sama sekali)
$stmt = $conn->prepare("SELECT COUNT(*) FROM approval_chain WHERE user_id = ? OR approver_id = ?");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$stmt->bind_result($countApproval);
$stmt->fetch();
$stmt->close();
$isAturan3 = ($countApproval == 0);

/* ======================
   Filter data milik sendiri
   ====================== */
if ($isAturan3 || $isAtasanAkhir) {
    // Atasan (syarat aturan 3 atau atasan akhir) → semua final_status milik sendiri
    $whereExtra = " AND t.pic = " . intval($user_id);
} else {
    // Bawahan → milik sendiri tapi exclude selesai
    $whereExtra = " AND t.pic = " . intval($user_id) . " AND (t.final_status IS NULL OR t.final_status != 'selesai')";
}



function renderPagination($key, $totalPages, $page, $limit, $search)
{
    if ($totalPages <= 1) return;
    echo '<nav aria-label="Page navigation"><ul class="pagination justify-content-center mt-3">';

    echo '<li class="page-item ' . ($page <= 1 ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . max(1, $page - 1) . '">Prev</a></li>';

    for ($i = 1; $i <= $totalPages; $i++) {
        $active = ($page == $i) ? 'active' : '';
        echo '<li class="page-item ' . $active . '"><a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . $i . '">' . $i . '</a></li>';
    }

    echo '<li class="page-item ' . ($page >= $totalPages ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . min($totalPages, $page + 1) . '">Next</a></li>';

    echo '</ul></nav>';
}

$todolist_limit = isset($_GET['limit_todolist']) ? ($_GET['limit_todolist'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_todolist']) : 10;
$todolist_page = isset($_GET['page_todolist']) ? (int)$_GET['page_todolist'] : 1;
$search_todolist = isset($_GET['search_todolist']) ? $_GET['search_todolist'] : '';

$todolist = getSearchData($conn, 'todolist', [
    'uraian_todolist',
    'deadline',
    'pic',
    'unit_id',
    'keterangan',
    'link',
    'final_status',
    'progres_status',
    'date_selesai',
    'created_at'
], $todolist_limit, $todolist_page, $search_todolist, 'id DESC', $whereExtra);





$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN user_id = ? THEN 1 ELSE 0 END) AS is_bawahan,
        SUM(CASE WHEN approver_id = ? THEN 1 ELSE 0 END) AS is_atasan
    FROM approval_chain
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$resApproval = $stmt->get_result()->fetch_assoc();
$stmt->close();

$isBawahan = $resApproval['is_bawahan'] > 0;
$isAtasan  = $resApproval['is_atasan'] > 0;
$isInChain = $isBawahan || $isAtasan;

// ====================
// Hitung jumlah yang perlu di-approve untuk badge
// ====================
$jumlahApproveTodo = 0;
if ($isAtasan) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <title>To Do List Aktif</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <style>
        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 7px 9px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 190px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 7px 13px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .custom-filter {
            border-radius: 15px;
            width: 151px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }

        .btn-view {
            color: white;
            background-color: #001eff;
            border-color: #001eff;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo%20Header%20New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <?php if (!empty($access_modul['gaji']) && $access_modul['gaji'] === 'on'): ?>
                <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji <?php echo htmlspecialchars($name); ?></a>
            <?php endif; ?>

            <?php if (!empty($access_modul['surat']) && $access_modul['surat'] === 'on'): ?>
                <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Anda</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['todolist']) && $access_modul['todolist'] === 'on'): ?>
                <!-- Toggle selalu tampil kalau modul todolist aktif -->
                <a href="#todolistSubmenu" class="submenu-toggle active" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                    <i class="fas fa-tasks"></i> To Do List Pekerjaan
                    <!-- Badge hanya tampil jika dia atasan (boleh approve) dan ada item yg menunggu -->
                    <?php if (!empty($isAtasan) && $isAtasan && !empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                        <span class="badge bg-danger ms-0"><?= intval($jumlahApproveTodo) ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
                </a>

                <div id="todolistSubmenu" class="collapse submenu">
                    <!-- Semua user yang memiliki modul tetap bisa lihat Aktif -->
                    <a href="todolist.php" class="active"><i class="fas fa-play-circle"></i> Aktif</a>

                    <!-- Approve hanya untuk atasan (isAtasan = true) -->
                    <?php if (!empty($isAtasan) && $isAtasan): ?>
                        <a href="approve-todolist.php">
                            <i class="fas fa-check-circle"></i> Approve
                            <?php if (!empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                                <span class="badge bg-danger ms-1"><?= intval($jumlahApproveTodo) ?></span>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>

                    <!-- Semua user yang memiliki modul tetap bisa lihat Record -->
                    <a href="record-todolist.php"><i class="fas fa-history"></i> Record Keseluruhan</a>
                </div>

            <?php endif; ?>

            <?php if (!empty($access_modul['agenda']) && $access_modul['agenda'] === 'on'): ?>
                <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                    <i class="fas fa-calendar-check"></i> Agenda Kerja
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
                </a>

                <div id="agendaSubmenu" class="collapse submenu show">
                    <a href="list-agenda.php">
                        <i class="fas fa-clock"></i> List
                        <?php if ($jumlahAgendaAktif > 0): ?>
                            <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="record-agenda.php">
                        <i class="fas fa-clipboard-list"></i> Record
                    </a>
                </div>
            <?php endif; ?>

            <?php if (!empty($access_modul['berita']) && $access_modul['berita'] === 'on'): ?>
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['gerbang']) && $access_modul['gerbang'] === 'on'): ?>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['sosial']) && $access_modul['sosial'] === 'on'): ?>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab</a>
            <?php endif; ?>

            <!-- <a href="#systemSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php" ><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                

            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php" ><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php" ><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php" ><i class="fas fa-road"></i> Gerbang Tol </a>
            </div> -->
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>To Do List Anda</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <form method="get" class="d-flex align-items-center me-3">
                            <label class="me-1 fw-bold">Show</label>
                            <select name="limit_todolist" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                                <?php foreach ([10, 50, 'All'] as $opt): ?>
                                    <option value="<?= $opt ?>" <?= $todolist_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                                <?php endforeach; ?>
                            </select>
                            <input type="hidden" name="search_todolist" value="<?= htmlspecialchars($search_todolist) ?>">
                            <input type="hidden" name="page_todolist" value="1">
                        </form>


                        <form method="get" class="search-box-new d-flex align-items-center mb-2">
                            <input type="text"
                                id="searchInputNew"
                                name="search_todolist"
                                class="search-input-new form-control form-control-sm me-1"
                                placeholder="Tap untuk mencari..."
                                value="<?= htmlspecialchars($search_todolist) ?>">

                            <input type="hidden" name="limit_todolist" value="<?= ($todolist_limit === PHP_INT_MAX ? 'All' : $todolist_limit) ?>">
                            <input type="hidden" name="page_todolist" value="1">

                            <button type="submit" id="searchButtonNew" class="search-btn-new btn btn-primary btn-sm">
                                <i class="fas fa-search"></i> Cari
                            </button>
                        </form>

                </div>
                <div>
                    <a href="add/user-add_todolist.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah To Do List</a>
                </div>
            </div>

            <table class="table table-bordered table-striped">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Uraian</th>
                        <th>Deadline</th>
                        <th>PIC</th>
                        <th>Keterangan</th>
                        <th>Link</th>

                        <th>Approval L1</th>

                        <th>Approval L2</th>

                        <th>Final Status</th>

                        <th>Dibuat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($todolist['data']->num_rows > 0): ?>
                        <?php while ($row = $todolist['data']->fetch_assoc()): ?>
                            <tr>
                                <td><?= $row['id'] ?></td>
                                <td><?= htmlspecialchars($row['uraian_todolist']) ?></td>
                                <td><?= htmlspecialchars($row['deadline']) ?></td>
                                <td>
                                    <?= htmlspecialchars($row['pic_nama']) ?>
                                    <div class="text-muted small mt-1">
                                        (dari unit:
                                        <?php
                                        // Ambil semua unit untuk PIC ini
                                        $stmtUnit = $conn->prepare("
                            SELECT GROUP_CONCAT(unit_name ORDER BY unit_name SEPARATOR ', ') AS all_units
                            FROM user_unit uu
                            JOIN unit un ON uu.unit_id = un.id
                            WHERE uu.user_id = ?
                        ");
                                        $stmtUnit->bind_param("i", $row['pic']);
                                        $stmtUnit->execute();
                                        $resultUnit = $stmtUnit->get_result()->fetch_assoc();
                                        $stmtUnit->close();

                                        echo htmlspecialchars($resultUnit['all_units'] ?? $row['unit_name']);
                                        ?>
                                        )
                                    </div>
                                </td>

                                <td><?= htmlspecialchars($row['keterangan']) ?></td>
                                <td>
                                    <?php if (!empty($row['link'])): ?>
                                        <a href="<?= htmlspecialchars($row['link']) ?>" class="btn btn-view btn-sm" target="_blank">
                                            <i class="fas fa-eye"></i> Lihat
                                        </a>
                                    <?php endif; ?>
                                </td>


                                <!-- Approval L1 -->
                                <td>
                                    <?php
                                    $status1 = $row['approval_status_level1'];

                                    if (!empty($status1)) {
                                        // Badge status
                                        if ($status1 === 'valid') {
                                            echo '<p class="badge badge-success mb-1">Disetujui<br><span class="text-white">'
                                                . (!empty($row['date_valid_1']) ? $row['date_valid_1'] : '-') .
                                                '</span></p>';
                                        } elseif ($status1 === 'menunggu') {
                                            echo '<p class="badge badge-secondary mb-1">Menunggu<br><span class="text-white">'
                                                . (!empty($row['date_menunggu_1']) ? $row['date_menunggu_1'] : '-') .
                                                '</span></p>';
                                        } elseif ($status1 === 'revisi') {
                                            echo '<p class="badge badge-info mb-1">Revisi<br><span class="text-dark">'
                                                . (!empty($row['date_revisi_1']) ? $row['date_revisi_1'] : '-') .
                                                '</span></p>';
                                            echo '<div><small>Catatan: <strong>' .
                                                (!empty($row['catatan_revisi_1']) ? htmlspecialchars($row['catatan_revisi_1']) : '-') .
                                                '</strong></small></div>';
                                        } elseif ($status1 === 'ditolak') {
                                            echo '<p class="badge badge-danger mb-1">Ditolak<br><span class="text-white">'
                                                . (!empty($row['date_ditolak_1']) ? $row['date_ditolak_1'] : '-') .
                                                '</span></p>';
                                            echo '<div><small>Alasan: <strong>' .
                                                (!empty($row['catatan_ditolak_1']) ? htmlspecialchars($row['catatan_ditolak_1']) : '-') .
                                                '</strong></small></div>';
                                        }

                                        // Hasil perbaikan jika ada date_hasilperbaikan_1
                                        if (!empty($row['date_hasilperbaikan_1']) && $row['date_hasilperbaikan_1'] !== '0000-00-00 00:00:00') {
                                            echo '<div class="mt-1"><small class="text-muted">Diperbaiki pada: ' .
                                                htmlspecialchars($row['date_hasilperbaikan_1']) .
                                                '</small></div>';
                                        }

                                        // Nama approver
                                        $approverName1 = getApproverName($conn, $row['pic'], $row['unit_id'], 1);
                                        echo '<div class="mt-1"><small class="text-primary">Approval: ' . htmlspecialchars($approverName1) . '</small></div>';
                                    }
                                    ?>
                                </td>

                                <!-- Approval L2 -->
                                <td>
                                    <?php
                                    $status2 = $row['approval_status_level2'];

                                    if (!empty($status2)) {
                                        if ($status2 === 'valid') {
                                            echo '<p class="badge badge-success mb-1">Disetujui<br><span class="text-white">'
                                                . (!empty($row['date_valid_2']) ? $row['date_valid_2'] : '-') .
                                                '</span></p>';
                                        } elseif ($status2 === 'menunggu') {
                                            echo '<p class="badge badge-secondary mb-1">Menunggu<br><span class="text-white">'
                                                . (!empty($row['date_menunggu_2']) ? $row['date_menunggu_2'] : '-') .
                                                '</span></p>';
                                        } elseif ($status2 === 'revisi') {
                                            echo '<p class="badge badge-info mb-1">Revisi<br><span class="text-dark">'
                                                . (!empty($row['date_revisi_2']) ? $row['date_revisi_2'] : '-') .
                                                '</span></p>';
                                            echo '<div><small>Catatan: <strong>' .
                                                (!empty($row['catatan_revisi_2']) ? htmlspecialchars($row['catatan_revisi_2']) : '-') .
                                                '</strong></small></div>';
                                        } elseif ($status2 === 'ditolak') {
                                            echo '<p class="badge badge-danger mb-1">Ditolak<br><span class="text-white">'
                                                . (!empty($row['date_ditolak_2']) ? $row['date_ditolak_2'] : '-') .
                                                '</span></p>';
                                            echo '<div><small>Alasan: <strong>' .
                                                (!empty($row['catatan_ditolak_2']) ? htmlspecialchars($row['catatan_ditolak_2']) : '-') .
                                                '</strong></small></div>';
                                        }

                                        if (
                                            !empty($row['date_revisi_2']) && $row['date_revisi_2'] !== '0000-00-00 00:00:00'
                                            && !empty($row['date_hasilperbaikan_2']) && $row['date_hasilperbaikan_2'] !== '0000-00-00 00:00:00'
                                        ) {
                                            echo '<div class="mt-1"><small class="text-muted">Diperbaiki pada: ' .
                                                htmlspecialchars($row['date_hasilperbaikan_2']) .
                                                '</small></div>';
                                        }

                                        $approverName2 = getApproverName($conn, $row['pic'], $row['unit_id'], 2);
                                        echo '<div class="mt-1"><small class="text-primary">Approval: ' . htmlspecialchars($approverName2) . '</small></div>';
                                    }
                                    ?>
                                </td>

                                <!-- Final Status + Date Selesai + Progres Status -->
                                <td class="text-center">
                                    <?php
                                    $finalStatus = strtolower($row['final_status']);
                                    $progresStatus = strtolower($row['progres_status']);

                                    // Final Status Badge + Icon
                                    if ($finalStatus === 'aktif') {
                                        echo '<span class="badge badge-primary"><i class="fas fa-play-circle"></i> Aktif</span>';
                                    } elseif ($finalStatus === 'selesai') {
                                        echo '<span class="badge badge-success"><i class="fas fa-check-circle"></i> Selesai</span>';
                                    } elseif ($finalStatus === 'belum') {
                                        echo '<span class="badge badge-dark">Belum Aktif</span>';

                                        // Tombol Aktifkan (khusus status belum)
                                        echo '<div class="mt-2">
            <button class="btn btn-sm btn-view" data-bs-toggle="modal" data-bs-target="#aktifkanModal' . $row['id'] . '">
                <i class="fas fa-play"></i> Aktifkan
            </button>
        </div>';

                                        // Modal Form Aktifkan
                                        echo '
    <div class="modal fade" id="aktifkanModal' . $row['id'] . '" tabindex="-1" role="dialog" aria-labelledby="aktifkanModalLabel' . $row['id'] . '" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form method="POST" action="update-status.php">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="aktifkanModalLabel' . $row['id'] . '">Aktifkan To Do List</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                    <input type="hidden" name="id" value="' . $row['id'] . '">
                    <div class="form-group">
                        <label for="link">Masukan Hasil Pekerjaan Anda:</label>
                        <input type="text" name="link" id="link" class="form-control" placeholder="Masukkan link">
                    </div>';

                                        // Logika aturan
                                        if ($isAturan3 || $isAtasanAkhir || (!$isBawahan && !$isAtasanAkhir)) {
                                            // Aturan 3 atau bukan bawahan / atasan → langsung selesai
                                            echo '<input type="hidden" name="final_status" value="selesai">';
                                            echo '<input type="hidden" name="date_selesai" value="' . date('Y-m-d H:i:s') . '">';
                                        } else {
                                            // Bawahan → approval level
                                            echo '<input type="hidden" name="approval_status_level1" value="menunggu">';
                                            echo '<input type="hidden" name="date_menunggu_1" value="' . date('Y-m-d H:i:s') . '">';
                                            echo '<input type="hidden" name="final_status" value="aktif">';
                                        }

                                        echo '      </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-check"></i> Simpan</button>
            </div>
            </div>
        </form>
    </div>
    </div>';
                                    } else {
                                        echo '<span class="badge badge-secondary"><i class="fas fa-info-circle"></i> ' . htmlspecialchars($row['final_status']) . '</span>';
                                    }

                                    // Jika final_status selesai, tampilkan tanggal selesai & progres
                                    if ($finalStatus === 'selesai') {
                                        if (!empty($row['date_selesai']) && $row['date_selesai'] !== '0000-00-00 00:00:00') {
                                            echo '<div class="mt-1"><small><i class="far fa-calendar-check"></i> Selesai pada: <strong>' . htmlspecialchars($row['date_selesai']) . '</strong></small></div>';
                                        }

                                        if (!empty($row['progres_status'])) {
                                            echo '<div class="mt-1"><small>Dengan progres akhir ';
                                            if ($progresStatus === 'valid') {
                                                echo '<span class="badge badge-success"><i class="fas fa-check"></i> Valid</span>';
                                            } elseif ($progresStatus === 'ditolak') {
                                                echo '<span class="badge badge-danger"><i class="fas fa-times"></i> Ditolak</span>';
                                            } else {
                                                echo '<span class="badge badge-secondary"><i class="fas fa-info-circle"></i> ' . htmlspecialchars($row['progres_status']) . '</span>';
                                            }
                                            echo '</small></div>';
                                        }
                                    }
                                    ?>
                                </td>



                                <!-- Dibuat -->
                                <td><?= htmlspecialchars($row['created_at']) ?></td>

                                <!-- Tombol Edit/Hapus -->
                                <td class="text-center">
                                    <?php if (strtolower($row['final_status']) !== 'selesai'): ?>
                                        <a href="edit/user-edit_todolist.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="delete/user-delete_todolist.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus data ini?')">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="16" class="text-center">Tidak ada data</td>
                        </tr>
                    <?php endif; ?>
                </tbody>

            </table>

            <?php renderPagination('todolist', $todolist['totalPages'], $todolist_page, $todolist_limit, $search_todolist); ?>


        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
        <script>
            const searchInputNew = document.getElementById('searchInputNew');
            const searchButtonNew = document.getElementById('searchButtonNew');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew.addEventListener('focus', function() {
                searchButtonNew.classList.add('show'); // Tampilkan tombol
                searchInputNew.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew.addEventListener('blur', function() {
                if (!searchInputNew.value.trim()) {
                    searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew1 = document.getElementById('searchInputNew1');
            const searchButtonNew1 = document.getElementById('searchButtonNew1');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew1.addEventListener('focus', function() {
                searchButtonNew1.classList.add('show'); // Tampilkan tombol
                searchInputNew1.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew1.addEventListener('blur', function() {
                if (!searchInputNew1.value.trim()) {
                    searchButtonNew1.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew1.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew2 = document.getElementById('searchInputNew2');
            const searchButtonNew2 = document.getElementById('searchButtonNew2');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew2.addEventListener('focus', function() {
                searchButtonNew2.classList.add('show'); // Tampilkan tombol
                searchInputNew2.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew2.addEventListener('blur', function() {
                if (!searchInputNew2.value.trim()) {
                    searchButtonNew2.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew2.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew3 = document.getElementById('searchInputNew3');
            const searchButtonNew3 = document.getElementById('searchButtonNew3');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew3.addEventListener('focus', function() {
                searchButtonNew3.classList.add('show'); // Tampilkan tombol
                searchInputNew3.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew3.addEventListener('blur', function() {
                if (!searchInputNew3.value.trim()) {
                    searchButtonNew3.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew3.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });
        </script>
</body>

</html>