<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$query = "SELECT id, tipe, nama, access_modul FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || !in_array($user['tipe'], ['user', 'admin', 'editor'])) {
    header('Location: ../login.php');
    exit();
}


$access_modul = json_decode($user['access_modul'], true);

$user_id = $user['id'];
$nama = $user['nama'];

// Izinkan akses jika:
// 1. User adalah tipe "user", ATAU
// 2. User adalah approver/supervisor
if ($user['tipe'] !== 'user' && !$isApprover && !$isSupervisor) {
    header('Location: login.php');
    exit();
}

// Debug helper: if ?debug=1 will print session and user variables (remove in prod)
if (!empty($_GET['debug']) && $_GET['debug'] === '1') {
    echo '<pre>SESSION=';
    print_r($_SESSION);
    echo "\nUSER=" . json_encode($user) . "\n</pre>";
}

// Handle delete letter for supervisors (only their own letters)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_letter'])) {
    $letter_id = (int)$_POST['letter_id'];

    // Check if letter belongs to current user only
    $stmt_check = $conn->prepare("SELECT dibuat_oleh FROM office WHERE id = ?");
    $stmt_check->bind_param('i', $letter_id);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    $letter_row = $result_check->fetch_assoc();
    $stmt_check->close();

    if ($letter_row && $letter_row['dibuat_oleh'] == $user_id) {
        // Delete associated files and approval chain, then delete record
        $stmt_files = $conn->prepare("SELECT file_surat, lampiran_path, signature_path, qr_code FROM office WHERE id = ?");
        $stmt_files->bind_param('i', $letter_id);
        $stmt_files->execute();
        $res_files = $stmt_files->get_result();
        $files = $res_files ? $res_files->fetch_assoc() : null;
        $stmt_files->close();

        if ($files) {
            if (!empty($files['file_surat'])) {
                $filePath = __DIR__ . '/' . ltrim($files['file_surat'], '/');
                if (is_file($filePath)) @unlink($filePath);
            }
            if (!empty($files['signature_path'])) {
                $sigPath = __DIR__ . '/' . ltrim($files['signature_path'], '/');
                if (is_file($sigPath)) @unlink($sigPath);
            }
            if (!empty($files['qr_code'])) {
                $qrPath = __DIR__ . '/' . ltrim($files['qr_code'], '/');
                if (is_file($qrPath)) @unlink($qrPath);
            }
            if (!empty($files['lampiran_path'])) {
                $paths = json_decode($files['lampiran_path'], true);
                if (is_array($paths)) {
                    foreach ($paths as $p) {
                        $abs = __DIR__ . '/' . ltrim($p, '/');
                        if (is_file($abs)) @unlink($abs);
                    }
                }
            }
        }

        $del_chain = $conn->prepare("DELETE FROM urutan_paraf WHERE office_id = ?");
        $del_chain->bind_param('i', $letter_id);
        $del_chain->execute();
        $del_chain->close();

        $stmt_delete = $conn->prepare("DELETE FROM office WHERE id = ?");
        $stmt_delete->bind_param('i', $letter_id);
        if ($stmt_delete->execute()) {
            $_SESSION['success_msg'] = 'Surat berhasil dihapus.';
            error_log(sprintf('LETTER_DELETE: user_id=%d deleted office_id=%d', $user_id, $letter_id));
        } else {
            $_SESSION['error_msg'] = 'Gagal menghapus surat.';
            error_log(sprintf('LETTER_DELETE_FAIL: user_id=%d office_id=%d', $user_id, $letter_id));
        }
        $stmt_delete->close();
    } else {
        $_SESSION['error_msg'] = 'Anda hanya dapat menghapus surat milik Anda sendiri.';
    }

    header('Location: surat.php' . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : ''));
    exit();
}

// Display success/error messages
$success_msg = $_SESSION['success_msg'] ?? '';
$error_msg = $_SESSION['error_msg'] ?? '';
unset($_SESSION['success_msg'], $_SESSION['error_msg']);

$name = $user['nama']; // Ambil nama asli dari database






date_default_timezone_set("Asia/Jakarta"); // Set timezone ke Jakarta
$hour = date("H"); // Mendapatkan jam saat ini (format 24 jam)



$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;


// Filter
$search = $_GET['search'] ?? '';
$filter_tahun = $_GET['filter_tahun'] ?? '';

// Filter data tahun unik dari office
$tahunOptions = $conn->query("SELECT DISTINCT YEAR(tanggal_surat) as tahun FROM office WHERE dibuat_oleh = $user_id ORDER BY tahun DESC");

// Pagination
$limitOptions = [20, 100, 'All'];
$selectedLimit = $_GET['limit'] ?? 20;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;

// Sorting
$sort_by = $_GET['sort_by'] ?? 'created_at';
$sort_order = $_GET['sort_order'] ?? 'DESC';

$allowedSort = [
    'tanggal_surat' => 'tanggal_surat',
    'perihal' => 'perihal',
    'nama' => 'u.nama',
    'created_at' => 'created_at'
];
$sort_column = $allowedSort[$sort_by] ?? 'created_at';

function sortableHeader($label, $key, $currentSortBy, $currentOrder, $get)
{
    $nextOrder = ($currentSortBy === $key && $currentOrder === 'ASC') ? 'DESC' : 'ASC';
    $icon = '<i class="fas fa-sort ms-1"></i>';
    if ($currentSortBy === $key) {
        $icon = $currentOrder === 'ASC'
            ? '<i class="fas fa-arrow-up ms-1"></i>'
            : '<i class="fas fa-arrow-down ms-1"></i>';
    }
    $params = array_merge($get, ['sort_by' => $key, 'sort_order' => $nextOrder]);
    $link = '?' . http_build_query($params);
    return "<a href=\"$link\" class=\"text-warning text-decoration-none\">$label $icon</a>";
}

// Filter SQL
$allIds = [$user_id];
if (!empty($subordinateIds)) $allIds = array_merge($allIds, $subordinateIds);
$allIds = array_map('intval', array_unique($allIds));
$filterSqlParts = ["dibuat_oleh IN (" . implode(',', $allIds) . ")"];
if (!empty($search)) {
    $searchEsc = $conn->real_escape_string($search);
    $filterSqlParts[] = "(YEAR(tanggal_surat) LIKE '%$searchEsc%' OR perihal LIKE '%$searchEsc%' OR created_at LIKE '%$searchEsc%')";
}
if (!empty($filter_tahun)) {
    $filterSqlParts[] = "YEAR(tanggal_surat) = '" . $conn->real_escape_string($filter_tahun) . "'";
}

$searchSql = "WHERE " . implode(' AND ', $filterSqlParts);

// Query data surat from office table with user names
$sql = "SELECT o.*, u.nama FROM office o LEFT JOIN users u ON o.dibuat_oleh = u.id $searchSql ORDER BY $sort_column $sort_order";
$result = $conn->query($sql);
$rows = $result->fetch_all(MYSQLI_ASSOC);

// Paginasi
$totalData = count($rows);
$totalPages = ($selectedLimit === 'All') ? 1 : ceil($totalData / $selectedLimit);
$offset = ($page - 1) * ($selectedLimit === 'All' ? $totalData : $selectedLimit);
$paginatedRows = ($selectedLimit === 'All') ? $rows : array_slice($rows, $offset, $selectedLimit);





$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN user_id = ? THEN 1 ELSE 0 END) AS is_bawahan,
        SUM(CASE WHEN approver_id = ? THEN 1 ELSE 0 END) AS is_atasan
    FROM approval_chain
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$resApproval = $stmt->get_result()->fetch_assoc();
$stmt->close();

$isBawahan = $resApproval['is_bawahan'] > 0;
$isAtasan  = $resApproval['is_atasan'] > 0;
$isInChain = $isBawahan || $isAtasan;

// ====================
// Hitung jumlah yang perlu di-approve untuk badge
// ====================
$jumlahApproveTodo = 0;
if ($isAtasan) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        // Validasi: maksimal level yang valid di todolist schema
        if ($level > 2) {
            error_log("Warning: approval_chain level {$level} melebihi batas maksimum. Menggunakan level 2 sebagai fallback.");
            $level = 2;
        }
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>Surat Anda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
            width: 250px;
            flex-shrink: 0;
            overflow-y: auto;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
            transition: all 0.3s ease;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
            transform: translateX(5px);
        }

        .submenu {
            padding-left: 20px;
        }

        .submenu a {
            font-size: 0.9rem;
            padding: 8px 10px;
        }

        .submenu-toggle:hover {
            background-color: rgba(255, 193, 7, 0.1);
        }

        .arrow-icon {
            margin-left: auto;
        }

        .flex-grow-1 {
            flex: 1;
        }

        .custom-filter {
            border-radius: 15px;
            width: 137px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 8px 12px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 250px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 6px 20px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .btn-success {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        .btn-success:hover {
            background-color: #e0a800;
            border-color: #e0a800;
            color: #0047ab;
        }

        .table thead {
            background-color: #0047ab;
            color: #ffc107;
            text-transform: uppercase;
            font-weight: bold;
        }

        .table thead th {
            background-color: #0c50e1;
            color: #ffc107;
        }

        .card {
            border: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }

        .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .submenu.collapse.show {
            max-height: 300px;
            transition: max-height 0.4s ease-in;
        }

        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        .sidebar a.active {
            background-color: #ffc107;
            color: #fff;
            font-weight: bold;
        }

        .sidebar a.active i {
            color: #fff;
        }
    </style>
</head>

<body>
    <?php if (!empty($success_msg)): ?>
        <script>
            Swal.fire('Sukses', '<?= addslashes($success_msg) ?>', 'success');
        </script>
    <?php endif; ?>
    <?php if (!empty($error_msg)): ?>
        <script>
            Swal.fire('Error', '<?= addslashes($error_msg) ?>', 'error');
        </script>
    <?php endif; ?>
    <div class="d-flex">
        <?php include __DIR__ . '/../includes/sidebar-user.php'; ?>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Surat Masuk Anda - <?= htmlspecialchars($nama) ?></h2>

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ($limitOptions as $option): ?>
                                <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                    <?= $option ?></option>
                            <?php endforeach; ?>
                        </select>
                    </form>
                    <form method="get" class="d-flex align-items-center ms-3">
                        <select name="filter_tahun" class="form-select form-select-sm me-1 custom-filter"
                            onchange="this.form.submit()">
                            <option value="">Semua Tahun</option>
                            <?php while ($row = $tahunOptions->fetch_assoc()): ?>
                                <option value="<?= $row['tahun'] ?>"
                                    <?= $filter_tahun == $row['tahun'] ? 'selected' : '' ?>>
                                    <?= $row['tahun'] ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                        <input type="hidden" name="limit" value="<?= htmlspecialchars($selectedLimit) ?>">
                        <input type="hidden" name="search" value="<?= htmlspecialchars($search) ?>">
                        <input type="hidden" name="sort_by" value="<?= htmlspecialchars($sort_by) ?>">
                        <input type="hidden" name="sort_order" value="<?= htmlspecialchars($sort_order) ?>">
                    </form>
                </div>
                <div>
                    <form method="get" class="search-box-new">
                        <input type="text" id="searchInputNew" name="search" class="search-input-new me-1"
                            placeholder="Tap untuk mencari..." value="<?= htmlspecialchars($search) ?>">
                        <input type="hidden" name="limit" value="<?= htmlspecialchars($selectedLimit) ?>">
                        <button type="submit" id="searchButtonNew" class="search-btn-new"><i class="fas fa-search"></i>
                            Cari</button>
                    </form>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th><?= sortableHeader("Nomor Surat", "nomor_surat", $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader("Perihal", "perihal", $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader("Pembuat", "nama", $sort_by, $sort_order, $_GET) ?></th>
                        <!-- <th><?= sortableHeader("Tanggal", "tanggal_surat", $sort_by, $sort_order, $_GET) ?></th> -->
                        <th><?= sortableHeader("Dibuat", "created_at", $sort_by, $sort_order, $_GET) ?></th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = $offset + 1;
                    foreach ($paginatedRows as $row): ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td class="text-center"><?= htmlspecialchars($row['nomor_surat']) ?></td>
                            <td><?= htmlspecialchars($row['perihal']) ?></td>
                            <td class="text-center"><?= htmlspecialchars($row['nama'] ?? '') ?></td>
                            <!-- <td class="text-center"><?= htmlspecialchars($row['tanggal_surat']) ?></td> -->
                            <td class="text-center">Dibuat Pada : <?= $row['created_at'] ?></td>
                            <td class="text-center">
                                <?php if ($row['dibuat_oleh'] == $user_id): ?>
                                    <button class="btn btn-sm btn-danger btn-delete"
                                        data-id="<?= $row['id'] ?>"
                                        data-nomor="<?= htmlspecialchars($row['nomor_surat']) ?>"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteModal">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (count($paginatedRows) === 0): ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada surat ditemukan</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link"
                                href="?<?= http_build_query(array_merge($_GET, ['page' => max(1, $page - 1)])) ?>">Prev</a>
                        </li>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link"
                                    href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link"
                                href="?<?= http_build_query(array_merge($_GET, ['page' => min($totalPages, $page + 1)])) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>

        </div>

    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const searchInputNew = document.getElementById('searchInputNew');
        const searchButtonNew = document.getElementById('searchButtonNew');

        // Event listener untuk memperlihatkan tombol ketika input diklik
        searchInputNew.addEventListener('focus', function() {
            searchButtonNew.classList.add('show'); // Tampilkan tombol
            searchInputNew.placeholder = ''; // Hilangkan placeholder
        });

        // Event listener untuk menyembunyikan tombol ketika input kosong
        searchInputNew.addEventListener('blur', function() {
            if (!searchInputNew.value.trim()) {
                searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
            }
        });
    </script>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteModalLabel">Konfirmasi Hapus Surat</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus surat dengan nomor <strong id="deleteNomorSurat"></strong>?</p>
                    <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan — ini akan menghapus file yang telah diunggah dan jejak approval terkait, termasuk surat yang telah tervalidasi.</small></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <form method="POST" id="deleteForm" style="display: inline;">
                        <input type="hidden" name="letter_id" id="deleteLetterId">
                        <button type="submit" name="delete_letter" class="btn btn-danger">Hapus</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Delete button event listener
        document.querySelectorAll('.btn-delete').forEach(button => {
            button.addEventListener('click', function() {
                const letterId = this.getAttribute('data-id');
                const nomorSurat = this.getAttribute('data-nomor');
                document.getElementById('deleteLetterId').value = letterId;
                document.getElementById('deleteNomorSurat').textContent = nomorSurat;
            });
        });
    </script>
</body>

</html>