<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$query = "SELECT id, tipe, nama, access_modul FROM users WHERE username = ?";

$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'user') {
    header('Location: ../login.php');
    exit();
}

$access_modul = json_decode($user['access_modul'], true);
if (empty($access_modul['agenda']) || $access_modul['agenda'] !== 'on') {
    header('Location: login.php');
    exit();
}

$name = $user['nama'];

$user_id = $user['id']; // ID user yang sedang login






// Hitung agenda aktif (hari ini dan akan datang)
date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;






// Ambil data agenda beserta nama PIC
date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

$sql = "
    SELECT agenda.*, users.nama 
    FROM agenda 
    LEFT JOIN users ON agenda.pic = users.id 
    WHERE agenda.tanggal > ? 
       OR (agenda.tanggal = ? AND agenda.waktu >= ?)
    ORDER BY agenda.tanggal ASC, agenda.waktu ASC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sss", $today, $today, $nowTime);
$stmt->execute();
$agenda = $stmt->get_result();



// Handle Tambah Agenda
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_agenda'])) {
    $agenda = $_POST['agenda'];
    $tanggal = $_POST['tanggal'];
    $waktu = $_POST['waktu'];
    $tempat = $_POST['tempat'];
    $pic = $_POST['pic'];
    $keterangan = $_POST['keterangan'];

    $stmt = $conn->prepare("INSERT INTO agenda (agenda, tanggal, waktu, tempat, pic, keterangan) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssis", $agenda, $tanggal, $waktu, $tempat, $pic, $keterangan);
    $stmt->execute();

    // Redirect agar tidak re-submit saat refresh
    header("Location: list-agenda.php");
    exit();
}




// Tangani form edit agenda
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_agenda'])) {
    $agenda_id = $_POST['agenda_id'];
    $agenda = $_POST['agenda'];
    $tanggal = $_POST['tanggal'];
    $waktu = $_POST['waktu'];
    $tempat = $_POST['tempat'];
    $pic = $_POST['pic'];
    $keterangan = $_POST['keterangan'];

    $stmt = $conn->prepare("UPDATE agenda SET agenda = ?, tanggal = ?, waktu = ?, tempat = ?, pic = ?, keterangan = ? WHERE id = ?");
    $stmt->bind_param("ssssssi", $agenda, $tanggal, $waktu, $tempat, $pic, $keterangan, $agenda_id);
    $stmt->execute();

    header("Location: list-agenda.php");
    exit();
}


// Tangani hapus agenda
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hapus_agenda'])) {
    $agenda_id = $_POST['agenda_id'];
    $stmt = $conn->prepare("DELETE FROM agenda WHERE id = ?");
    $stmt->bind_param("i", $agenda_id);
    $stmt->execute();

    header("Location: list-agenda.php");
    exit();
}





// Ambil parameter pencarian
$search = $_GET['search'] ?? '';
$searchParams = [];
$types = 'sss';
$params = [$today, $today, $nowTime];

// Siapkan WHERE dasar
$baseWhere = "agenda.tanggal > ? OR (agenda.tanggal = ? AND agenda.waktu >= ?)";

// Jika ada pencarian
if (!empty($search)) {
    $baseWhere = "($baseWhere) AND (agenda.agenda LIKE CONCAT('%', ?, '%') OR agenda.tempat LIKE CONCAT('%', ?, '%') OR agenda.keterangan LIKE CONCAT('%', ?, '%') OR users.nama LIKE CONCAT('%', ?, '%'))";
    $params = array_merge($params, [$search, $search, $search, $search]);
    $types .= 'ssss';
}

// Sorting
$sort_by = $_GET['sort_by'] ?? '';
$sort_order = $_GET['sort_order'] ?? 'ASC';
$allowedSort = [
    'agenda' => 'agenda.agenda',
    'tanggal' => 'agenda.tanggal',
    'waktu' => 'agenda.waktu',
    'tempat' => 'agenda.tempat',
    'pic' => 'users.nama',
    'keterangan' => 'agenda.keterangan',
    'created_at' => 'agenda.created_at'
];
$sort_column = $allowedSort[$sort_by] ?? 'agenda.tanggal, agenda.waktu';
$order_clause = $sort_by ? "$sort_column $sort_order" : "agenda.tanggal ASC, agenda.waktu ASC";

$next_order = ($sort_order === 'ASC') ? 'DESC' : 'ASC';

// Fungsi untuk header sorting
function sortableHeader($label, $key, $currentSortBy, $currentOrder, $get)
{
    $nextOrder = ($currentSortBy === $key && $currentOrder === 'ASC') ? 'DESC' : 'ASC';
    $icon = '<i class="fas fa-sort ms-1"></i>';
    if ($currentSortBy === $key) {
        $icon = $currentOrder === 'ASC'
            ? '<i class="fas fa-arrow-up ms-1"></i>'
            : '<i class="fas fa-arrow-down ms-1"></i>';
    }
    $params = array_merge($get, ['sort_by' => $key, 'sort_order' => $nextOrder]);
    $link = '?' . http_build_query($params);
    return "<a href=\"$link\" class=\"text-warning text-decoration-none\">$label $icon</a>";
}

// Pagination
$limitOptions = [20, 100, 'All'];
$selectedLimit = $_GET['limit'] ?? 20;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;

// Hitung total data
$countSql = "SELECT COUNT(*) as total FROM agenda LEFT JOIN users ON agenda.pic = users.id WHERE $baseWhere";
$countStmt = $conn->prepare($countSql);
$countStmt->bind_param($types, ...$params);
$countStmt->execute();
$totalRows = $countStmt->get_result()->fetch_assoc()['total'] ?? 0;

// Limit dan offset
if ($selectedLimit === 'All') {
    $limit = $totalRows;
    $offset = 0;
} else {
    $limit = (int)$selectedLimit;
    $offset = ($page - 1) * $limit;
}
$totalPages = ($selectedLimit === 'All') ? 1 : ceil($totalRows / $limit);

// Ambil data agenda
$sql = "
    SELECT agenda.*, users.nama 
    FROM agenda 
    LEFT JOIN users ON agenda.pic = users.id 
    WHERE $baseWhere 
    ORDER BY $order_clause 
    LIMIT ? OFFSET ?
";
$params[] = $limit;
$params[] = $offset;
$types .= 'ii';

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$agenda = $stmt->get_result();





$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN user_id = ? THEN 1 ELSE 0 END) AS is_bawahan,
        SUM(CASE WHEN approver_id = ? THEN 1 ELSE 0 END) AS is_atasan
    FROM approval_chain
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$resApproval = $stmt->get_result()->fetch_assoc();
$stmt->close();

$isBawahan = $resApproval['is_bawahan'] > 0;
$isAtasan  = $resApproval['is_atasan'] > 0;
$isInChain = $isBawahan || $isAtasan;

// ====================
// Hitung jumlah yang perlu di-approve untuk badge
// ====================
$jumlahApproveTodo = 0;
if ($isAtasan) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>List Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 7px 9px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 190px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 7px 13px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .custom-filter {
            border-radius: 15px;
            width: 151px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo%20Header%20New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <!-- Sidebar -->
            <?php if (!empty($access_modul['gaji']) && $access_modul['gaji'] === 'on'): ?>
                <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji <?php echo htmlspecialchars($name); ?></a>
            <?php endif; ?>

            <?php if (!empty($access_modul['surat']) && $access_modul['surat'] === 'on'): ?>
                <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Anda</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['todolist']) && $access_modul['todolist'] === 'on'): ?>
                <!-- Toggle selalu tampil kalau modul todolist aktif -->
                <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                    <i class="fas fa-tasks"></i> To Do List Pekerjaan
                    <!-- Badge hanya tampil jika dia atasan (boleh approve) dan ada item yg menunggu -->
                    <?php if (!empty($isAtasan) && $isAtasan && !empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                        <span class="badge bg-danger ms-0"><?= intval($jumlahApproveTodo) ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
                </a>

                <div id="todolistSubmenu" class="collapse submenu">
                    <!-- Semua user yang memiliki modul tetap bisa lihat Aktif -->
                    <a href="todolist.php"><i class="fas fa-play-circle"></i> Aktif</a>

                    <!-- Approve hanya untuk atasan (isAtasan = true) -->
                    <?php if (!empty($isAtasan) && $isAtasan): ?>
                        <a href="approve-todolist.php">
                            <i class="fas fa-check-circle"></i> Approve
                            <?php if (!empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                                <span class="badge bg-danger ms-1"><?= intval($jumlahApproveTodo) ?></span>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>

                    <!-- Semua user yang memiliki modul tetap bisa lihat Record -->
                    <a href="record-todolist.php"><i class="fas fa-history"></i> Record Keseluruhan</a>
                </div>

            <?php endif; ?>

            <?php if (!empty($access_modul['agenda']) && $access_modul['agenda'] === 'on'): ?>
                <a href="#agendaSubmenu" class="submenu-toggle active" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                    <i class="fas fa-calendar-check"></i> Agenda Kerja
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
                </a>

                <div id="agendaSubmenu" class="collapse submenu show">
                    <a href="list-agenda.php" class="active">
                        <i class="fas fa-clock"></i> List
                        <?php if ($jumlahAgendaAktif > 0): ?>
                            <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="record-agenda.php">
                        <i class="fas fa-clipboard-list"></i> Record
                    </a>
                </div>
            <?php endif; ?>

            <?php if (!empty($access_modul['berita']) && $access_modul['berita'] === 'on'): ?>
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['gerbang']) && $access_modul['gerbang'] === 'on'): ?>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['sosial']) && $access_modul['sosial'] === 'on'): ?>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab</a>
            <?php endif; ?>


            <!-- <a href="#systemSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php" ><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                

            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php" ><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php" ><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php" ><i class="fas fa-road"></i> Gerbang Tol </a>
            </div> -->
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>List Agenda Kerja</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <form method="get" class="d-flex align-items-center mb-0">
                    <label class="me-2 fw-bold">Show</label>
                    <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto me-2">
                        <?php foreach ($limitOptions as $option): ?>
                            <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                <?= $option ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>

                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <strong>Keterangan Status Agenda:</strong><br>

                        <span class="me-3 text-warning"><i class="fas fa-clock fa-lg"></i> = Hari ini</span>
                        <span class="text-success"><i class="fas fa-calendar-check fa-lg"></i> = Akan datang</span>
                    </div>
                    <form method="GET" action="" class="search-box-new me-2">
                        <input
                            type="text"
                            id="searchInputNew"
                            name="search"
                            class="search-input-new me-1"
                            placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
                        <button type="submit" id="searchButtonNew" class="search-btn-new">
                            <i class="fas fa-search"></i> Cari
                        </button>
                    </form>

                    <div>
                        <!-- Tombol Tambah Agenda -->
                        <button type="button" class="btn btn-success mb-0" data-bs-toggle="modal" data-bs-target="#modalTambahAgenda">
                            <i class="fas fa-plus-circle"></i> Tambah Agenda
                        </button>
                    </div>
                </div>

            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th><?= sortableHeader('Uraian Agenda', 'agenda', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tanggal', 'tanggal', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Waktu', 'waktu', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tempat', 'tempat', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('PIC', 'pic', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Keterangan', 'keterangan', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Dibuat', 'created_at', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = ($page - 1) * ($selectedLimit === 'All' ? $totalRows : (int)$selectedLimit) + 1;
                    date_default_timezone_set('Asia/Jakarta');
                    $nowDate = date('Y-m-d');
                    $nowTime = date('H:i');

                    while ($row = $agenda->fetch_assoc()):
                        $agendaDate = $row['tanggal'];
                        $agendaTime = $row['waktu'];

                        // Tentukan status agenda
                        if ($agendaDate < $nowDate || ($agendaDate == $nowDate && $agendaTime < $nowTime)) {
                            $statusIcon = '<i class="fas fa-ban fa-lg text-danger" title="Sudah lewat"></i>';
                        } elseif ($agendaDate == $nowDate && $agendaTime >= $nowTime) {
                            $statusIcon = '<i class="fas fa-clock fa-lg text-warning" title="Hari ini"></i>';
                        } else {
                            $statusIcon = '<i class="fas fa-calendar-check fa-lg text-success" title="Akan datang"></i>';
                        }
                    ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?><br><?= $statusIcon ?></td>
                            <td><?= htmlspecialchars($row['agenda']) ?></td>
                            <td class="text-center"><?= htmlspecialchars($row['tanggal']) ?></td>
                            <td class="text-center"><?= htmlspecialchars($row['waktu']) ?></td>
                            <td><?= htmlspecialchars($row['tempat']) ?></td>
                            <td><?= htmlspecialchars($row['nama'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($row['keterangan']) ?></td>
                            <td class="text-center"><?= $row['created_at'] ?></td>
                            <td class="text-center">
                                <?php if ($row['pic'] == $user_id): ?>
                                    <button type="button" class="btn btn-warning btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#modalEditAgenda<?php echo $row['id']; ?>">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#modalDeleteAgenda<?php echo $row['id']; ?>">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                <?php endif; ?>
                            </td>

                        </tr>
                        <!-- Modal Edit Agenda -->
                        <div class="modal fade" id="modalEditAgenda<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="modalEditLabel<?php echo $row['id']; ?>" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <form method="POST" action="">
                                    <input type="hidden" name="edit_agenda" value="1">
                                    <input type="hidden" name="agenda_id" value="<?php echo $row['id']; ?>">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="modalEditLabel<?php echo $row['id']; ?>">Edit Agenda - <?php echo htmlspecialchars($row['agenda']); ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                        </div>
                                        <div class="modal-body">

                                            <div class="mb-3">
                                                <label for="agenda" class="form-label">Agenda</label>
                                                <input type="text" class="form-control" name="agenda" value="<?php echo htmlspecialchars($row['agenda']); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="tanggal" class="form-label">Tanggal</label>
                                                <input type="date" class="form-control" name="tanggal" value="<?php echo $row['tanggal']; ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="waktu" class="form-label">Waktu</label>
                                                <input type="time" class="form-control" name="waktu" value="<?php echo $row['waktu']; ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="tempat" class="form-label">Tempat</label>
                                                <input type="text" class="form-control" name="tempat" value="<?php echo htmlspecialchars($row['tempat']); ?>" required>
                                            </div>

                                            <input type="hidden" name="pic" value="<?= $user_id ?>">


                                            <div class="mb-3">
                                                <label for="keterangan" class="form-label">Keterangan</label>
                                                <textarea class="form-control" name="keterangan" rows="3"><?php echo htmlspecialchars($row['keterangan']); ?></textarea>
                                            </div>

                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan Perubahan</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>



                        <!-- Modal Hapus Agenda -->
                        <div class="modal fade" id="modalDeleteAgenda<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="modalDeleteLabel<?php echo $row['id']; ?>" aria-hidden="true">
                            <div class="modal-dialog">
                                <form method="POST" action="">
                                    <input type="hidden" name="hapus_agenda" value="1">
                                    <input type="hidden" name="agenda_id" value="<?php echo $row['id']; ?>">
                                    <div class="modal-content">
                                        <div class="modal-header bg-danger text-white">
                                            <h5 class="modal-title" id="modalDeleteLabel<?php echo $row['id']; ?>">Hapus Agenda</h5>
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Apakah Anda yakin ingin menghapus agenda <strong><?php echo htmlspecialchars($row['agenda']); ?></strong> pada tanggal <strong><?php
                                                                                                                                                                                $timestamp = strtotime($row['tanggal']);
                                                                                                                                                                                $bulanIndonesia = [
                                                                                                                                                                                    1 => 'Januari',
                                                                                                                                                                                    2 => 'Februari',
                                                                                                                                                                                    3 => 'Maret',
                                                                                                                                                                                    4 => 'April',
                                                                                                                                                                                    5 => 'Mei',
                                                                                                                                                                                    6 => 'Juni',
                                                                                                                                                                                    7 => 'Juli',
                                                                                                                                                                                    8 => 'Agustus',
                                                                                                                                                                                    9 => 'September',
                                                                                                                                                                                    10 => 'Oktober',
                                                                                                                                                                                    11 => 'November',
                                                                                                                                                                                    12 => 'Desember'
                                                                                                                                                                                ];
                                                                                                                                                                                $hari = date('j', $timestamp);
                                                                                                                                                                                $bulan = $bulanIndonesia[date('n', $timestamp)];
                                                                                                                                                                                $tahun = date('Y', $timestamp);
                                                                                                                                                                                echo "$hari $bulan $tahun";
                                                                                                                                                                                ?></strong>?</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-danger"><i class="fas fa-trash-alt"></i> Ya, Hapus</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>



                    <?php endwhile; ?>
                </tbody>
            </table>

            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => max(1, $page - 1)])) ?>">Prev</a>
                        </li>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => min($totalPages, $page + 1)])) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>







            <!-- Modal Tambah Agenda -->
            <div class="modal fade" id="modalTambahAgenda" tabindex="-1" aria-labelledby="modalTambahAgendaLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <form method="POST" action="">
                        <input type="hidden" name="tambah_agenda" value="1">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalTambahAgendaLabel">Tambah Agenda Kerja</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="agenda" class="form-label">Agenda</label>
                                    <input type="text" class="form-control" id="agenda" name="agenda" required>
                                </div>

                                <div class="mb-3">
                                    <label for="tanggal" class="form-label">Tanggal</label>
                                    <input type="date" class="form-control" id="tanggal" name="tanggal" required>
                                </div>

                                <div class="mb-3">
                                    <label for="waktu" class="form-label">Waktu</label>
                                    <input type="time" class="form-control" id="waktu" name="waktu" required>
                                </div>

                                <div class="mb-3">
                                    <label for="tempat" class="form-label">Tempat</label>
                                    <input type="text" class="form-control" id="tempat" name="tempat" required>
                                </div>

                                <input type="hidden" name="pic" value="<?= htmlspecialchars($user_id) ?>">

                                <div class="mb-3">
                                    <label for="keterangan" class="form-label">Keterangan</label>
                                    <textarea class="form-control" name="keterangan" id="keterangan" rows="3" required></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>




        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <script>
        const searchInputNew = document.getElementById('searchInputNew');
        const searchButtonNew = document.getElementById('searchButtonNew');

        // Event listener untuk memperlihatkan tombol ketika input diklik
        searchInputNew.addEventListener('focus', function() {
            searchButtonNew.classList.add('show'); // Tampilkan tombol
            searchInputNew.placeholder = ''; // Hilangkan placeholder
        });

        // Event listener untuk menyembunyikan tombol ketika input kosong
        searchInputNew.addEventListener('blur', function() {
            if (!searchInputNew.value.trim()) {
                searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
            }
        });
    </script>
</body>

</html>