<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

// User check
$username = $_SESSION['username'] ?? null;
if (!$username) {
    header('Location: ../login.php');
    exit();
}
$stmt = $conn->prepare("SELECT id, tipe, nama, access_modul FROM users WHERE username = ? LIMIT 1");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$user = $res ? $res->fetch_assoc() : null;
$stmt->close();
if (!$user) {
    header('Location: ../login.php');
    exit();
}

// compute agenda active badge for sidebar parity
date_default_timezone_set("Asia/Jakarta");
$today = date('Y-m-d');
$nowTime = date('H:i');
$jumlahAgendaAktif = 0;
if ($s = $conn->prepare("SELECT COUNT(*) FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)")) {
    $s->bind_param("sss", $today, $today, $nowTime);
    $s->execute();
    $s->bind_result($jumlah);
    if ($s->fetch()) $jumlahAgendaAktif = (int)$jumlah;
    $s->close();
}

// Build mapping and retrieve only users who have letters
// allow access if modul surat enabled OR if they are supervisor in letter_order or approver in approval_chain
$access_modul = json_decode($user['access_modul'], true);
$subordinateIds = getSubordinatesForUser($conn, $user['id']);
$isSupervisor = !empty($subordinateIds);
$isApprover = isApprover($conn, $user['id']);
if ((empty($access_modul['surat']) || $access_modul['surat'] !== 'on') && !$isSupervisor && !$isApprover) {
    header('Location: login.php');
    exit();
}

// Calculate approve todo count
$jumlahApproveTodo = 0;
if ($isApprover) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user['id']);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        // Validasi: maksimal level yang valid di todolist schema
        if ($level > 2) {
            error_log("Warning: approval_chain level {$level} melebihi batas maksimum. Menggunakan level 2 sebagai fallback.");
            $level = 2;
        }
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}

list($map, $nameMap) = buildSupervisorMap($conn);

$sql = "SELECT u.id as user_id, u.nama as user_name, s.nama as supervisor_name, lo.id as lo_id, lo.supervisor_id, COUNT(o.id) as jumlah_letters
        FROM users u
        LEFT JOIN letter_order lo ON lo.user_id = u.id
        LEFT JOIN users s ON lo.supervisor_id = s.id
        LEFT JOIN office o ON o.dibuat_oleh = u.id
        GROUP BY u.id
        HAVING jumlah_letters > 0
        ORDER BY u.nama";
$rows = [];
if ($r = $conn->query($sql)) {
    $rows = $r->fetch_all(MYSQLI_ASSOC);
    $r->free();
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Urutan Surat - User</title>
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
            width: 250px;
            flex-shrink: 0;
            overflow-y: auto;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
            transition: all 0.3s ease;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
            transform: translateX(5px);
        }

        .btn-success {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        .btn-success:hover {
            background-color: #e0a800;
            border-color: #e0a800;
            color: #0047ab;
        }

        .table thead {
            background-color: #0047ab;
            color: #fff;
            text-transform: uppercase;
            font-weight: bold;
        }

        .table thead th {
            background-color: #0c50e1;
            color: #ffc107;
        }

        .card {
            border: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }

        .submenu {
            padding-left: 20px;
        }

        .submenu a {
            font-size: 0.9rem;
            padding: 8px 10px;
        }

        .submenu-toggle:hover {
            background-color: rgba(255, 193, 7, 0.1);
        }

        .arrow-icon {
            margin-left: auto;
        }

        #mainContent {
            flex: 1;
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <?php include __DIR__ . '/../includes/sidebar-user.php'; ?>
        <div id="mainContent" class="container-fluid py-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h2>Urutan Surat</h2>
                <div>
                    <a href="record-letter.php" class="btn btn-outline-secondary">Kembali</a>
                </div>
            </div>
            <div class="card">
                <div class="card-body p-2">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover table-bordered mb-0">
                            <thead class="table-primary">
                                <tr>
                                    <th style="width:6%">ID</th>
                                    <th>Nama User</th>
                                    <th>Nama Atasan</th>
                                    <th>Jumlah Surat</th>
                                    <th>Urutan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($rows)): ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No entries found</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($rows as $idx => $r): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($r['user_id']) ?></td>
                                            <td><?= htmlspecialchars($r['user_name'] ?? '(unknown)') ?></td>
                                            <td><?= htmlspecialchars($r['supervisor_name'] ?? ($r['lo_id'] && (int)$r['supervisor_id'] === 0 ? 'Jabatan Tertinggi' : 'Pengguna Belum Didaftarkan Urutan Surat')) ?></td>
                                            <td class="text-center"><?= (int)$r['jumlah_letters'] ?></td>
                                            <td><small><?= htmlspecialchars(getApprovalChainFromMaps((int)$r['user_id'], $nameMap, $map) ?: 'Jabatan Tertinggi') ?></small></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>