<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Ambil data pengguna yang sedang login
$username = $_SESSION['username'];
$query = "SELECT tipe, id, nama, access_modul FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
// Ensure we have a valid user array before using values
$user_id = isset($user['id']) ? (int)$user['id'] : null;
$access_modul = isset($user['access_modul']) ? json_decode($user['access_modul'], true) : [];
// support multi-level supervisors and approver checks
if ($user_id !== null) {
    $subordinateIds = getSubordinatesForUser($conn, $user_id);
    $isSupervisor = !empty($subordinateIds);
    $isApprover = isApprover($conn, $user_id);
} else {
    $subordinateIds = [];
    $isSupervisor = false;
    $isApprover = false;
}

// Izinkan hanya jika tipe adalah 'user'
if (!$user || $user['tipe'] !== 'user') {
    header('Location: ../login.php');
    exit();
}

$name = $user['nama'];

// $user_id already assigned above.


date_default_timezone_set("Asia/Jakarta"); // Set timezone ke Jakarta
$hour = date("H"); // Mendapatkan jam saat ini (format 24 jam)



$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;





if ($hour >= 5 && $hour < 12) {
    $greeting = "pagi";
    $icon = "fa-sun"; // Ikon matahari
    $color = "#FFD700"; // Warna kuning
} elseif ($hour >= 12 && $hour < 15) {
    $greeting = "siang";
    $icon = "fa-cloud-sun"; // Ikon matahari berawan
    $color = "#FF8C00"; // Warna oranye
} elseif ($hour >= 15 && $hour < 18) {
    $greeting = "sore";
    $icon = "fa-cloud"; // Ikon awan
    $color = "#1E90FF"; // Warna jingga
} else {
    $greeting = "malam";
    $icon = "fa-moon"; // Ikon bulan
    $color = "#0800A9FF"; // Warna biru malam
}





// Menghitung jumlah dari setiap tabel
$totalVisitCount = 0;
$totalBerita = 0;
$totalGerbang = 0;
$totalSosial = 0;

try {
    // Query untuk tabel counter: Menghitung total visit_count
    $result = $conn->query("SELECT SUM(visit_count) AS total FROM counter");
    $row = $result->fetch_assoc();
    $totalVisitCount = $row['total'] ?? 0;

    // Query untuk tabel berita
    $result = $conn->query("SELECT COUNT(*) AS total FROM berita");
    $row = $result->fetch_assoc();
    $totalBerita = $row['total'] ?? 0;

    // Query untuk tabel gerbang: Menghitung total jumlah entri
    $result = $conn->query("SELECT COUNT(*) AS total FROM gerbang");
    if (!$result) {
        throw new Exception("Query tabel gerbang gagal: " . $conn->error);
    }
    $row = $result->fetch_assoc();
    $totalGerbang = $row['total'] ?? 0;

    // Query untuk tabel sosial
    $result = $conn->query("SELECT COUNT(*) AS total FROM sosial");
    $row = $result->fetch_assoc();
    $totalSosial = $row['total'] ?? 0;
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}



$name = $user['nama']; // Ambil nama asli dari database

// Proses edit user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_user'])) {
    $id = $_POST['id'];
    $username_input = $_POST['username'] ?? null;
    $password_input = $_POST['password'] ?? '';
    $nama_input = $_POST['nama'] ?? null;
    $email_input = $_POST['email'] ?? null;
    $jabatan_input = $_POST['jabatan'] ?? null;
    $gender_input = $_POST['gender'] ?? null;

    // Sub Unit opsional: jika kosong, set NULL
    $sub_unit_id_input = !empty($_POST['sub_unit_id']) ? $_POST['sub_unit_id'] : null;

    // Ambil data lama
    $stmt_old = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt_old->bind_param("i", $id);
    $stmt_old->execute();
    $result_old = $stmt_old->get_result();
    $old = $result_old->fetch_assoc();

    // Jika password diisi baru, hash; kalau kosong, pakai lama
    $password = $password_input !== '' ? password_hash($password_input, PASSWORD_DEFAULT) : $old['password'];

    // Query update
    $sql = "UPDATE users SET username = ?, password = ?, nama = ?, email = ?, jabatan = ?, gender = ?, sub_unit_id = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "ssssssii",
        $username_input,
        $password,
        $nama_input,
        $email_input,
        $jabatan_input,
        $gender_input,
        $sub_unit_id_input,
        $id
    );

    if ($stmt->execute()) {
        // Perbarui session jika yang diubah adalah user yang login dan username-nya berubah
        if ($_SESSION['username'] === $old['username'] && $username_input !== $old['username']) {
            $_SESSION['username'] = $username_input;
        }

        echo "<script>alert('Data berhasil diupdate'); window.location.href='dashboard.php';</script>";
    } else {
        echo "<script>alert('Data gagal diupdate');</script>";
    }
}





// Handle delete user
if (isset($_GET['delete_user'])) {
    $id = $_GET['delete_user'];

    $sql = "DELETE FROM users WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Data berhasil dihapus');</script>";
    } else {
        echo "<script>alert('Data gagal dihapus');</script>";
    }
}




// Hitung jumlah modul yang aktif
$cardModules = [];

if (!empty($access_modul['berita']) && $access_modul['berita'] === 'on') {
    $cardModules[] = 'berita';
}
if (!empty($access_modul['gerbang']) && $access_modul['gerbang'] === 'on') {
    $cardModules[] = 'gerbang';
}
if (!empty($access_modul['sosial']) && $access_modul['sosial'] === 'on') {
    $cardModules[] = 'sosial';
}

$cardCount = count($cardModules);
$colSize = $cardCount > 0 ? intval(12 / $cardCount) : 12;







$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN user_id = ? THEN 1 ELSE 0 END) AS is_bawahan,
        SUM(CASE WHEN approver_id = ? THEN 1 ELSE 0 END) AS is_atasan
    FROM approval_chain
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$resApproval = $stmt->get_result()->fetch_assoc();
$stmt->close();

$isBawahan = $resApproval['is_bawahan'] > 0;
$isAtasan  = $resApproval['is_atasan'] > 0;
$isInChain = $isBawahan || $isAtasan;

// Determine if user has any existing letters (used to decide whether to show 'Surat' link)
$hasLetters = false;
$stmtCheck = $conn->prepare("SELECT COUNT(*) AS c FROM office WHERE dibuat_oleh = ?");
$stmtCheck->bind_param('i', $user_id);
$stmtCheck->execute();
$resCheck = $stmtCheck->get_result()->fetch_assoc();
$hasLetters = (int)($resCheck['c'] ?? 0) > 0;
$stmtCheck->close();

// ====================
// Hitung jumlah yang perlu di-approve untuk badge
// ====================
$jumlahApproveTodo = 0;
if ($isAtasan) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        // Validasi: maksimal level yang valid di todolist schema
        if ($level > 2) {
            error_log("Warning: approval_chain level {$level} melebihi batas maksimum. Menggunakan level 2 sebagai fallback.");
            $level = 2;
        }
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .greeting {
            text-align: center;
            color: <?php echo $color; ?>;
            animation: fadeIn 2s ease-in-out;
        }

        .icon {
            margin-top: 40px;
            font-size: 50px;
            margin-bottom: 0px;
            animation: bounce 1.5s infinite;
        }

        @keyframes bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }



        /* Animasi untuk kartu */
        @keyframes fadeInUp {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }

            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .highlight-card {
            border-radius: 15px;
            /* Membuat sudut melengkung */
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            animation: fadeInUp 0.8s ease-in-out;
        }

        /* Hover efek */
        .highlight-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Gaya untuk teks */
        .highlight-card h3 {
            font-size: 2.5rem;
            font-weight: bold;
            margin: 0;
        }

        .highlight-card p {
            font-size: 1.1rem;
            margin-top: 5px;
            opacity: 0.9;
        }

        /* Footer styling */
        .highlight-card .card-footer {
            background: rgba(0, 0, 0, 0.1);
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .highlight-card .card-footer a {
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s ease;
        }

        .highlight-card .card-footer a:hover {
            color: #ffd700;
            /* Warna emas saat hover */
        }

        /* Animasi untuk ikon */
        .highlight-card i {
            animation: bounce 1.5s infinite;
        }

        /* Bounce animasi untuk ikon */
        @keyframes bounce {

            0%,
            20%,
            50%,
            80%,
            100% {
                transform: translateY(0);
            }

            40% {
                transform: translateY(-10px);
            }

            60% {
                transform: translateY(-5px);
            }
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <?php include __DIR__ . '/../includes/sidebar-user.php'; ?>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <div class="greeting">
                <i class="fas <?php echo $icon; ?> icon" style="color: <?php echo $color; ?>;"></i>
            </div>
            <h1 class="text-center mt-3 mb-2" style="color: blue;">Selamat, Datang <?php echo htmlspecialchars($name); ?>!</h1>
            <div class="greeting">
                <p class="mb-4">Selamat <?php echo ucfirst($greeting); ?></p> <!-- Menggunakan ucfirst untuk kapitalisasi pertama -->
            </div>


            <div id="mainContent" class="content-container">
                <div class="dashboard-content">
                    <div class="row">
                        <!-- Card 1: Total Visit Count -->
                        <!-- <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-warning text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= number_format($totalVisitCount) ?></h3>
                                <p>Total <br>Visitor Counter</p>
                            </div>
                            <i class="fas fa-chart-line fa-3x text-light"></i>
                        </div>
                    
                    </div>
                </div> -->

                        <!-- Card 2: Berita -->
                        <?php if (in_array('berita', $cardModules)): ?>
                            <div class="col-xl-<?= $colSize ?> col-md-6 mb-4">
                                <div class="card highlight-card bg-primary text-white shadow-lg">
                                    <div class="card-body d-flex align-items-center justify-content-between">
                                        <div>
                                            <h3><?= number_format($totalBerita) ?></h3>
                                            <p>Total Berita</p>
                                        </div>
                                        <i class="fas fa-newspaper fa-3x text-light"></i>
                                    </div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="berita.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Card 3: Gerbang -->
                        <?php if (in_array('gerbang', $cardModules)): ?>
                            <div class="col-xl-<?= $colSize ?> col-md-6 mb-4">
                                <div class="card highlight-card bg-primary text-white shadow-lg">
                                    <div class="card-body d-flex align-items-center justify-content-between">
                                        <div>
                                            <h3><?= number_format($totalGerbang) ?></h3>
                                            <p>Total Gerbang</p>
                                        </div>
                                        <i class="fas fa-door-open fa-3x text-light"></i>
                                    </div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="gerbang.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>


                        <!-- Card 4: Sosial -->
                        <?php if (in_array('sosial', $cardModules)): ?>
                            <div class="col-xl-<?= $colSize ?> col-md-6 mb-4">
                                <div class="card highlight-card bg-warning text-white shadow-lg">
                                    <div class="card-body d-flex align-items-center justify-content-between">
                                        <div>
                                            <h3><?= number_format($totalSosial) ?></h3>
                                            <p>Total Tanggung Jawab</p>
                                        </div>
                                        <i class="fas fa-users fa-3x text-light"></i>
                                    </div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="sosial.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>Nama</th>
                        <th>Username</th>

                        <th>Email</th>
                        <th>Tipe</th>
                        <th>Jabatan</th>
                        <th>Sub Unit</th>

                        <th>Gender</th>
                        <th>Akses Modul</th>

                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sql = "SELECT users.*, sub_unit.sub_unit_name FROM users 
        LEFT JOIN sub_unit ON users.sub_unit_id = sub_unit.id
        WHERE users.username = ?";


                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("s", $username);
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr class='text-center'>";

                            // Nama
                            echo "<td>" . (!empty($row['nama']) ? htmlspecialchars($row['nama']) : '-') . "</td>";

                            // Username & password
                            echo "<td>" . htmlspecialchars($row['username']) . "</td>";


                            // Email
                            echo "<td>" . (!empty($row['email']) ? htmlspecialchars($row['email']) : '-') . "</td>";

                            // Tipe user
                            if ($row['tipe'] === 'admin') {
                                echo "<td style='color: blue; font-weight:bold;'>" . strtoupper($row['tipe']) . "</td>";
                            } elseif ($row['tipe'] === 'editor') {
                                echo "<td><p class='card mt-2 text-white text-center bg-primary'>Editor</p></td>";
                            } elseif ($row['tipe'] === 'user') {
                                echo "<td><p class='card mt-2 text-dark text-center bg-warning'>User</p></td>";
                            } else {
                                echo "<td>-</td>";
                            }

                            // Jabatan
                            echo "<td>" . htmlspecialchars($row['jabatan'] ?? '-') . "</td>";
                            // Sub Unit
                            echo "<td>" . (!empty($row['sub_unit_name']) ? htmlspecialchars($row['sub_unit_name']) : '-') . "</td>";


                            // Gender
                            if ($row['gender'] === 'male') {
                                echo "<td style='color: #ffc107'><i class='fa fa-male' aria-hidden='true'></i></td>";
                            } elseif ($row['gender'] === 'female') {
                                echo "<td style='color: blue'><i class='fa fa-female' aria-hidden='true'></i></td>";
                            } else {
                                echo "<td>-</td>";
                            }

                            // Akses modul
                            $akses_aktif = [];
                            if (!empty($row['access_modul'])) {
                                $access = json_decode($row['access_modul'], true);
                                if (is_array($access)) {
                                    foreach ($access as $modul => $status) {
                                        if ($status === 'on') {
                                            if ($modul === 'sosial') {
                                                $akses_aktif[] = 'Tanggung Jawab';
                                            } elseif ($modul === 'todolist') {
                                                $akses_aktif[] = 'Todolist';
                                            } else {
                                                $akses_aktif[] = ucfirst($modul);
                                            }
                                        }
                                    }
                                }
                            }

                            echo "<td>" . (!empty($akses_aktif) ? implode(', ', $akses_aktif) : '-') . "</td>";


                            // Tombol Edit
                            echo "<td>
                    <button class='btn-sm btn btn-warning btn-edit'
                        data-id='" . $row['id'] . "'
                        data-username='" . $row['username'] . "'
                        data-nama='" . $row['nama'] . "'
                        data-email='" . $row['email'] . "'
                        data-access='" . htmlspecialchars($row['access_modul'], ENT_QUOTES) . "'
                        data-tipe='" . $row['tipe'] . "'
                        data-jabatan='" . $row['jabatan'] . "'
                        data-sub_unit_id='" . $row['sub_unit_id'] . "'
                        data-gender='" . $row['gender'] . "'>
                        <i class='fas fa-edit'></i>
                    </button>
                </td>";

                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='10' class='text-center'>Tidak ada data</td></tr>";
                    }
                    ?>
                </tbody>
            </table>



            <!-- Modal for Edit User -->
            <div id="editUserModal" class="modal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST" action="dashboard.php">
                                <input type="hidden" name="id" id="editUserId">
                                <div class="mb-3">
                                    <label for="editNama" class="form-label">Nama</label>
                                    <input type="text" name="nama" id="editNama" class="form-control">
                                </div>
                                <!-- Username disembunyikan -->
                                <input type="hidden" name="username" id="editUsername">

                                <div class="mb-3">
                                    <label for="editPassword" class="form-label">Password</label>
                                    <input type="password" name="password" id="editPassword" class="form-control" placeholder="Kosongkan jika tidak diubah">
                                </div>
                                <div class="mb-3">
                                    <label for="editEmail" class="form-label">Email</label>
                                    <input type="email" name="email" id="editEmail" class="form-control">
                                </div>

                                <!-- <div class="mb-3">
                        <label for="editTipe" class="form-label">Tipe</label>
                        <select name="tipe" id="editTipe" class="form-control">
                            <option value="admin">Admin</option>
                            <option value="user">User</option>
                            <option value="editor">Editor</option>
                        </select>
                    </div> -->

                                <div class="mb-3">
                                    <label for="editJabatan" class="form-label">Jabatan</label>
                                    <input type="text" name="jabatan" id="editJabatan" class="form-control">
                                </div>
                                <div class="mb-3">
                                    <label for="editSubUnit" class="form-label">Sub Unit (Opsional)</label>
                                    <select name="sub_unit_id" id="editSubUnit" class="form-control">
                                        <option value="">-- Tidak Memilih Sub Unit --</option>
                                        <?php
                                        $subQuery = $conn->query("SELECT id, sub_unit_name FROM sub_unit ORDER BY sub_unit_name ASC");
                                        while ($sub = $subQuery->fetch_assoc()) {
                                            echo "<option value='{$sub['id']}'>{$sub['sub_unit_name']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>



                                <div class="mb-3">
                                    <label for="editGender" class="form-label">Gender</label>
                                    <select name="gender" id="editGender" class="form-control">
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                    </select>
                                </div>



                                <a href="dashboard.php" class="btn btn-secondary">Kembali</a>
                                <button type="submit" name="edit_user" class="btn btn-primary">Update</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End flex container -->


        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

        <script>
            document.querySelectorAll('.btn-edit').forEach(button => {
                button.addEventListener('click', function() {
                    document.getElementById('editUserId').value = this.dataset.id;
                    document.getElementById('editUsername').value = this.dataset.username;
                    document.getElementById('editNama').value = this.dataset.nama;
                    document.getElementById('editEmail').value = this.dataset.email;
                    document.getElementById('editJabatan').value = this.dataset.jabatan;
                    document.getElementById('editGender').value = this.dataset.gender;
                    new bootstrap.Modal(document.getElementById('editUserModal')).show();
                });
            });

            document.addEventListener('DOMContentLoaded', function() {
                var editButtons = document.querySelectorAll('.btn-edit');
                var modal = new bootstrap.Modal(document.getElementById('editUserModal'));

                editButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        var userId = this.getAttribute('data-id');
                        var username = this.getAttribute('data-username');
                        document.getElementById('editUserId').value = userId;
                        document.getElementById('editUsername').value = username;
                        document.getElementById('editSubUnit').value = this.getAttribute('data-sub_unit_id');

                        modal.show();
                    });
                });
            });
        </script>
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>