<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Ambil data pengguna yang sedang login
$username = $_SESSION['username'];
$query = "SELECT tipe, id, nama, access_modul FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Jika user tidak ditemukan atau bukan 'user', keluar
if (!$user || $user['tipe'] !== 'user') {
    header('Location: ../login.php');
    exit();
}

// Decode access_modul
$access_modul = json_decode($user['access_modul'], true);

// Cek apakah modul 'berita' diset on
if (empty($access_modul['berita']) || $access_modul['berita'] !== 'on') {
    header('Location: login.php');
    exit();
}

$name = $user['nama']; // Nama asli user
$user_id = $user['id']; // ID user yang sedang login


date_default_timezone_set("Asia/Jakarta"); // Set timezone ke Jakarta
$hour = date("H"); // Mendapatkan jam saat ini (format 24 jam)



$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;


// Ambil parameter pencarian dan pagination
$search = $_GET['search'] ?? '';
$limitOptions = [10, 50, 'All'];
$selectedLimit = $_GET['limit'] ?? 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;

// Siapkan SQL dengan filter pencarian
$searchSql = '';
if (!empty($search)) {
    $searchEsc = $conn->real_escape_string($search);
    $searchSql = "WHERE judul LIKE '%$searchEsc%' 
               OR deskripsi LIKE '%$searchEsc%' 
               OR tanggal LIKE '%$searchEsc%' 
               OR created_at LIKE '%$searchEsc%'";
}

$sql = "SELECT * FROM berita $searchSql ORDER BY created_at DESC";
$result = $conn->query($sql);
if (!$result) {
    die("Query error: " . $conn->error);
}

$rows = $result->fetch_all(MYSQLI_ASSOC);
$totalData = count($rows);
$totalPages = ($selectedLimit === 'All') ? 1 : ceil($totalData / $selectedLimit);
$offset = ($page - 1) * ($selectedLimit === 'All' ? $totalData : $selectedLimit);
$paginatedRows = ($selectedLimit === 'All') ? $rows : array_slice($rows, $offset, $selectedLimit);





$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN user_id = ? THEN 1 ELSE 0 END) AS is_bawahan,
        SUM(CASE WHEN approver_id = ? THEN 1 ELSE 0 END) AS is_atasan
    FROM approval_chain
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$resApproval = $stmt->get_result()->fetch_assoc();
$stmt->close();

$isBawahan = $resApproval['is_bawahan'] > 0;
$isAtasan  = $resApproval['is_atasan'] > 0;
$isInChain = $isBawahan || $isAtasan;

// ====================
// Hitung jumlah yang perlu di-approve untuk badge
// ====================
$jumlahApproveTodo = 0;
if ($isAtasan) {
    $picsByLevel = [];
    $stmt = $conn->prepare("SELECT user_id, urutan FROM approval_chain WHERE approver_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($r = $res->fetch_assoc()) {
        $picsByLevel[(int)$r['urutan']][] = (int)$r['user_id'];
    }
    $stmt->close();

    $whereParts = [];
    foreach ($picsByLevel as $level => $pics) {
        if (empty($pics)) continue;
        $picList = implode(',', array_map('intval', $pics));
        $cond = "t.pic IN ($picList) AND t.approval_status_level{$level} = 'menunggu'";
        if ($level > 1) {
            $prev = $level - 1;
            $cond .= " AND (t.approval_status_level{$prev} IS NULL OR t.approval_status_level{$prev} != 'menunggu')";
        }
        $whereParts[] = "($cond)";
    }

    if (!empty($whereParts)) {
        $sqlCountApprove = "SELECT COUNT(*) AS jumlah FROM todolist t WHERE " . implode(' OR ', $whereParts);
        $resCount = $conn->query($sqlCountApprove);
        $jumlahApproveTodo = $resCount ? (int)$resCount->fetch_assoc()['jumlah'] : 0;
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>Berita</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 8px 12px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 250px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 6px 20px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo%20Header%20New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>

            <?php if (!empty($access_modul['gaji']) && $access_modul['gaji'] === 'on'): ?>
                <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji <?php echo htmlspecialchars($name); ?></a>
            <?php endif; ?>

            <?php if (!empty($access_modul['surat']) && $access_modul['surat'] === 'on'): ?>
                <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Anda</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['todolist']) && $access_modul['todolist'] === 'on'): ?>
                <!-- Toggle selalu tampil kalau modul todolist aktif -->
                <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                    <i class="fas fa-tasks"></i> To Do List Pekerjaan
                    <!-- Badge hanya tampil jika dia atasan (boleh approve) dan ada item yg menunggu -->
                    <?php if (!empty($isAtasan) && $isAtasan && !empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                        <span class="badge bg-danger ms-0"><?= intval($jumlahApproveTodo) ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
                </a>

                <div id="todolistSubmenu" class="collapse submenu">
                    <!-- Semua user yang memiliki modul tetap bisa lihat Aktif -->
                    <a href="todolist.php"><i class="fas fa-play-circle"></i> Aktif</a>

                    <!-- Approve hanya untuk atasan (isAtasan = true) -->
                    <?php if (!empty($isAtasan) && $isAtasan): ?>
                        <a href="approve-todolist.php">
                            <i class="fas fa-check-circle"></i> Approve
                            <?php if (!empty($jumlahApproveTodo) && $jumlahApproveTodo > 0): ?>
                                <span class="badge bg-danger ms-1"><?= intval($jumlahApproveTodo) ?></span>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>

                    <!-- Semua user yang memiliki modul tetap bisa lihat Record -->
                    <a href="record-todolist.php"><i class="fas fa-history"></i> Record Keseluruhan</a>
                </div>

            <?php endif; ?>

            <?php if (!empty($access_modul['agenda']) && $access_modul['agenda'] === 'on'): ?>
                <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                    <i class="fas fa-calendar-check"></i> Agenda Kerja
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                    <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
                </a>

                <div id="agendaSubmenu" class="collapse submenu">
                    <a href="list-agenda.php">
                        <i class="fas fa-clock"></i> List
                        <?php if ($jumlahAgendaAktif > 0): ?>
                            <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="record-agenda.php">
                        <i class="fas fa-clipboard-list"></i> Record
                    </a>
                </div>
            <?php endif; ?>


            <?php if (!empty($access_modul['berita']) && $access_modul['berita'] === 'on'): ?>
                <a href="berita.php" class="active"><i class="fas fa-newspaper"></i> Berita</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['gerbang']) && $access_modul['gerbang'] === 'on'): ?>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol</a>
            <?php endif; ?>

            <?php if (!empty($access_modul['sosial']) && $access_modul['sosial'] === 'on'): ?>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab</a>
            <?php endif; ?>
            <!-- <a href="#systemSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php" ><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                

            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php" ><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php" ><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php" ><i class="fas fa-road"></i> Gerbang Tol </a>
            </div> -->
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Data Berita</h2>
            <div class="d-flex justify-content-between align-items-center mb-2">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ($limitOptions as $option): ?>
                                <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                    <?= $option ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </form>
                    <div class="search-container-new">
                        <form method="get" action="" class="search-box-new me-3">
                            <input
                                type="text"
                                id="searchInputNew"
                                name="search"
                                class="search-input-new me-1"
                                placeholder="Tap untuk mencari..."
                                value="<?= htmlspecialchars($search) ?>">
                            <input type="hidden" name="limit" value="<?= htmlspecialchars($selectedLimit) ?>">
                            <button type="submit" id="searchButtonNew" class="search-btn-new">
                                <i class="fas fa-search"></i> Cari
                            </button>
                        </form>
                    </div>
                </div>

                <div>
                    <a href="add/user-add_berita.php" class="btn btn-success mb-0"><i class="fas fa-plus-circle"></i> Tambah Berita</a>
                </div>
            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th>Judul</th>
                        <th>Gambar</th>
                        <th>Deskripsi</th>
                        <th>Tanggal</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $id = $offset + 1;
                    foreach ($paginatedRows as $row): ?>
                        <tr>
                            <td class="text-center"><?= $id++; ?></td>
                            <td><?= htmlspecialchars($row['judul']); ?></td>
                            <td class="text-center">
                                <?php
                                $gambarArray = explode(",", $row['gambar']);
                                foreach ($gambarArray as $gambar) {
                                    echo '<img src="img/baru1/' . trim($gambar) . '" width="100" class="mb-1 me-1" alt="gambar">';
                                }
                                ?>
                            </td>
                            <td style="text-align: justify;"><small><?= htmlspecialchars($row['deskripsi']); ?></small></td>
                            <td class="text-center"><?= htmlspecialchars($row['tanggal']); ?></td>
                            <td class="text-center"><?= htmlspecialchars($row['created_at']); ?></td>
                            <td class="text-center">
                                <a href="edit/user-edit_berita.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm mb-1"><i class="fas fa-edit"></i></a>
                                <a href="delete/user-delete_berita.php?id=<?= $row['id']; ?>"
                                    class="btn btn-danger btn-sm"
                                    onclick="return confirm('Apakah Anda yakin ingin menghapus berita ini?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (count($paginatedRows) === 0): ?>
                        <tr>
                            <td colspan="7" class="text-center">Tidak ada data ditemukan</td>
                        </tr>
                    <?php endif; ?>
                </tbody>

            </table>
            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= max(1, $page - 1) ?>&search=<?= urlencode($search) ?>">Prev</a>
                        </li>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= min($totalPages, $page + 1) ?>&search=<?= urlencode($search) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>

        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        const searchInputNew = document.getElementById('searchInputNew');
        const searchButtonNew = document.getElementById('searchButtonNew');

        // Event listener untuk memperlihatkan tombol ketika input diklik
        searchInputNew.addEventListener('focus', function() {
            searchButtonNew.classList.add('show'); // Tampilkan tombol
            searchInputNew.placeholder = ''; // Hilangkan placeholder
        });

        // Event listener untuk menyembunyikan tombol ketika input kosong
        searchInputNew.addEventListener('blur', function() {
            if (!searchInputNew.value.trim()) {
                searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
            }
        });
    </script>
</body>

</html>