<?php
// Usage: php seed_letter_order.php
// This script will attempt to find users by name, using exact match first then LIKE fallback.

require_once 'koneksi.php';

$adminId = 1; // change if needed

$mapping = [
    'Netty Renova' => null,
    'Indarani' => 'Netty Renova',
    'Andri Supriadi' => 'Indarani',
    'Muhammad Reza Pahlevi Guntur' => 'Netty Renova',
    'Bambang Hermawan' => 'Andri Supriadi',
    'Fakirno' => 'Muhammad Reza Pahlevi Guntur',
    'Ragil Suparmadi' => 'Muhammad Reza Pahlevi Guntur',
    'Auzi Trisiyas Sulkha' => 'Bambang Hermawan',
    'Muhammad Tachyuddin' => 'Andri Supriadi',
    'Kukuh Prasojo' => 'Ragil Suparmadi',
    'Rendy Hendra Prasetya' => 'Bambang Hermawan',
    'Tedy Agus Harianto' => 'Andri Supriadi',
    'Budhi Satria Permana' => 'Bambang Hermawan',
    'M.Nafi Uddin' => 'Fakirno',
    'Harbetta Yurisa Tanydag' => 'Ragil Suparmadi',
    'Abdul Rokhman' => 'Andri Supriadi'
];

function findUserIdByName($conn, $name)
{
    // Try exact match first
    $stmt = $conn->prepare("SELECT id, nama FROM users WHERE nama = ? LIMIT 1");
    $stmt->bind_param('s', $name);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($row = $res->fetch_assoc()) {
        $stmt->close();
        return (int)$row['id'];
    }
    $stmt->close();

    // Fallback to LIKE query
    $like = '%' . str_replace(' ', '%', $name) . '%';
    $stmt2 = $conn->prepare("SELECT id, nama FROM users WHERE nama LIKE ? LIMIT 1");
    $stmt2->bind_param('s', $like);
    $stmt2->execute();
    $res2 = $stmt2->get_result();
    if ($row2 = $res2->fetch_assoc()) {
        $stmt2->close();
        echo "Fallback match found for '{$name}': '{$row2['nama']}' (ID: {$row2['id']})\n";
        return (int)$row2['id'];
    }
    $stmt2->close();

    return null;
}

$inserted = 0;
$missing = [];
foreach ($mapping as $u => $super) {
    $userId = findUserIdByName($conn, $u);
    if (!$userId) {
        $missing[] = "User not found: $u";
        continue;
    }

    $supervisorId = null;
    if ($super !== null) {
        $supervisorId = findUserIdByName($conn, $super);
        if (!$supervisorId) {
            $missing[] = "Supervisor not found for $u: $super";
            // We still proceed with NULL supervisor; admin can edit later
            $supervisorId = null;
        }
    }

    // Check if already exists
    $check = $conn->prepare("SELECT id FROM letter_order WHERE user_id = ? LIMIT 1");
    $check->bind_param('i', $userId);
    $check->execute();
    $r = $check->get_result();
    if ($r->fetch_assoc()) {
        $check->close();
        echo "Already exists for user: $u (ID: $userId)\n";
        continue;
    }
    $check->close();

    $insert = $conn->prepare("INSERT INTO letter_order (user_id, supervisor_id, created_by) VALUES (?, ?, ?)");
    if ($supervisorId === null) $insert->bind_param('iii', $userId, $supervisorId, $adminId);
    else $insert->bind_param('iii', $userId, $supervisorId, $adminId);
    if ($insert->execute()) {
        echo "Inserted letter_order: $u (ID: $userId) -> " . ($super ?? 'NULL') . "\n";
        $inserted++;
    } else {
        echo "Failed inserting: $u, error: {$insert->error}\n";
    }
    $insert->close();
}

echo "Done. Inserted: $inserted. Missing: " . count($missing) . "\n";
if (!empty($missing)) echo implode("\n", $missing) . "\n";
