<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['type'] !== 'admin') {
    header("Location: ../../login.php");
    exit();
}
require_once '../../config/database.php';
$db = new Database();
$conn = $db->getConnection();

// Mendapatkan informasi profil dari database berdasarkan user_id
$user_id = $_SESSION['user_id'];
$query = "SELECT name, profile_pic FROM users WHERE id = :user_id";
$stmt = $conn->prepare($query);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
$stmt->execute();

// Mengambil hasil query
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Cek jika data ditemukan
if ($user) {
    $name = $user['name'];
    $profile_pic = $user['profile_pic'];
} else {
    $name = "Unknown";
    $profile_pic = "default.png"; // Atur default jika tidak ditemukan
}

$stmt->closeCursor();

// Mengambil jumlah data dari tabel archived
$stmtArchived = $conn->query("SELECT COUNT(id) AS total_archived FROM archived");
$totalArchived = $stmtArchived->fetchColumn();
$stmtArchived->closeCursor();


// Mengambil jumlah circulation dengan status 'approved'
$stmtApproved = $conn->query("SELECT COUNT(id) AS total_approved FROM circulation WHERE status = 'approved'");
$totalApproved = $stmtApproved->fetchColumn();
$stmtApproved->closeCursor();

// Mengambil jumlah circulation dengan note 'not returned yet'
$stmtNotReturned = $conn->query("SELECT COUNT(id) AS total_not_returned FROM circulation WHERE note = 'not returned yet'");
$totalNotReturned = $stmtNotReturned->fetchColumn();
$stmtNotReturned->closeCursor();

// Query tambahan untuk setiap card
$totalLocations = $conn->query("SELECT COUNT(id) FROM code_loc")->fetchColumn();
$totalWaitingSend = $conn->query("SELECT COUNT(id) FROM circulation WHERE providing = 'Waiting for the admin to send'")->fetchColumn();
$totalWaitingReturn = $conn->query("SELECT COUNT(id) FROM circulation WHERE providing = 'Waiting for the admin to return'")->fetchColumn();
$totalUsers = $conn->query("SELECT COUNT(id) FROM users WHERE type = 'user'")->fetchColumn();

// Mengambil jumlah barang dengan status 'borrowed' dari tabel archived
$stmtBorrowed = $conn->query("SELECT COUNT(id) AS total_borrowed FROM archived WHERE status = 'borrowed'");
$totalBorrowed = $stmtBorrowed->fetchColumn();
$stmtBorrowed->closeCursor();

// Mengambil jumlah barang dengan status 'Waiting for the admin to return' dari tabel circulation
$stmtWaitingReturn = $conn->query("SELECT COUNT(id) AS total_waiting_return FROM circulation WHERE providing = 'Waiting for the admin to return'");
$totalWaitingReturn = $stmtWaitingReturn->fetchColumn();
$stmtWaitingReturn->closeCursor();

// Menghitung total barang yang ada di luar (borrowed + waiting for return)
$totalOutside = $totalBorrowed + $totalWaitingReturn;

// Mengambil 3 data terbaru dari tabel history
$queryHistory = "
    SELECT u.name, h.note, h.created_at
    FROM history h
    JOIN users u ON h.user_id = u.id
    ORDER BY h.created_at DESC
    LIMIT 3
";
$stmtHistory = $conn->prepare($queryHistory);
$stmtHistory->execute();
$historyData = $stmtHistory->fetchAll(PDO::FETCH_ASSOC);
$stmtHistory->closeCursor();

// Query untuk mendapatkan jumlah arsip per sub unit per bulan
$queryArchive = "
    SELECT su.sub_unit_name, DATE_FORMAT(a.date_input, '%Y-%m') AS archive_month, COUNT(a.id) AS archive_count
    FROM archived a
    JOIN sub_unit su ON a.subunit_id = su.id
    GROUP BY su.sub_unit_name, archive_month
    ORDER BY archive_month ASC
";
$stmtArchive = $conn->prepare($queryArchive);
$stmtArchive->execute();
$archiveData = $stmtArchive->fetchAll(PDO::FETCH_ASSOC);
$stmtArchive->closeCursor();

// Memformat data untuk digunakan di chart
$chartData = [];
foreach ($archiveData as $data) {
    $subUnit = $data['sub_unit_name'];
    $month = $data['archive_month'];
    $count = $data['archive_count'];

    if (!isset($chartData[$subUnit])) {
        $chartData[$subUnit] = [];
    }
    $chartData[$subUnit][$month] = $count;
}

// Menyiapkan data untuk JavaScript
$subUnitNames = array_keys($chartData);
$months = [];
foreach ($chartData as $subUnit => $data) {
    foreach (array_keys($data) as $month) {
        if (!in_array($month, $months)) {
            $months[] = $month;
        }
    }
}
sort($months); // Mengurutkan bulan

// Daftar warna dengan nama warna CSS yang mencolok dan cukup besar untuk sub unit baru
$colors = [
    'red',
    'blue',
    'green',
    'orange',
    'purple',
    'yellow',
    'pink',
    'brown',
    'cyan',
    'magenta',
    'lime',
    'indigo',
    'teal',
    'olive',
    'coral',
    'turquoise',
    'maroon',
    'navy',
    'silver',
    'gold',
    'lavender',
    'peachpuff',
    'crimson',
    'darkgreen'
];

// Menyusun dataset untuk Chart.js
$datasets = [];
foreach ($subUnitNames as $index => $subUnit) {
    $data = [];
    foreach ($months as $month) {
        $data[] = $chartData[$subUnit][$month] ?? 0; // Isi dengan 0 jika tidak ada data
    }
    $datasets[] = [
        'label' => $subUnit,
        'data' => $data,
        'backgroundColor' => $colors[$index % count($colors)], // Memastikan tidak ada warna yang diulang
    ];
}

// Mengambil data status dari tabel circulation
$statusQuery = $conn->query("SELECT status, COUNT(*) as count FROM circulation GROUP BY status");
$statusCounts = [];
$totalStatus = 0;
while ($row = $statusQuery->fetch(PDO::FETCH_ASSOC)) {
    $statusCounts[$row['status']] = $row['count'];
    $totalStatus += $row['count'];
}

// Mengambil data note dari tabel circulation
$noteQuery = $conn->query("SELECT note, COUNT(*) as count FROM circulation GROUP BY note");
$noteCounts = [];
$totalNote = 0;
while ($row = $noteQuery->fetch(PDO::FETCH_ASSOC)) {
    $noteCounts[$row['note']] = $row['count'];
    $totalNote += $row['count'];
}

// Mengambil data status dari tabel archived
$archiveQuery = $conn->query("SELECT status, COUNT(*) as count FROM archived GROUP BY status");
$archiveCounts = [];
$totalArchive = 0;
while ($row = $archiveQuery->fetch(PDO::FETCH_ASSOC)) {
    $archiveCounts[$row['status']] = $row['count'];
    $totalArchive += $row['count'];
}



// Mengambil semua nama sub unit dari tabel sub_unit
$querySubUnits = "SELECT sub_unit_name FROM sub_unit";
$stmtSubUnits = $conn->prepare($querySubUnits);
$stmtSubUnits->execute();
$subUnits = $stmtSubUnits->fetchAll(PDO::FETCH_COLUMN);
$stmtSubUnits->closeCursor();

// Inisialisasi array untuk menghitung jumlah akun per sub unit
$subUnitCounts = array_fill_keys($subUnits, 0); // Membuat array dengan nama sub unit dan nilai awal 0

// Mengambil data users dengan type 'user'
$queryUsers = "SELECT access_class FROM users WHERE type = 'user'";
$stmtUsers = $conn->prepare($queryUsers);
$stmtUsers->execute();
$users = $stmtUsers->fetchAll(PDO::FETCH_COLUMN);
$stmtUsers->closeCursor();

// Proses data untuk menghitung jumlah akun per sub unit
foreach ($users as $accessClass) {
    $accessList = explode(',', $accessClass); // Pisahkan sub unit berdasarkan koma
    foreach ($accessList as $access) {
        $access = trim($access); // Hilangkan spasi tambahan
        // Cari kecocokan dengan nama sub_unit (case-insensitive)
        foreach ($subUnits as $subUnitName) {
            if (strcasecmp($access, $subUnitName) === 0) {
                $subUnitCounts[$subUnitName] += 1; // Tambahkan jumlah akun untuk sub unit ini
            }
        }
    }
}

// Daftar warna untuk grafik
$colors = [
    'red',
    'blue',
    'green',
    'orange',
    'purple',
    'yellow',
    'pink',
    'brown',
    'cyan',
    'magenta',
    'lime',
    'indigo',
    'teal',
    'olive',
    'coral',
    'turquoise',
    'maroon',
    'navy',
    'silver',
    'gold',
    'lavender',
    'peachpuff',
    'crimson',
    'darkgreen'
];

// Siapkan data untuk JavaScript
$subUnitNames = array_keys($subUnitCounts);
$subUnitData = array_values($subUnitCounts);




// Query untuk mendapatkan data access_modul dari users dengan type 'user'
$queryUsersModules = "SELECT access_modul FROM users WHERE type = 'user'";
$stmtUsersModules = $conn->prepare($queryUsersModules);
$stmtUsersModules->execute();
$usersModules = $stmtUsersModules->fetchAll(PDO::FETCH_COLUMN);
$stmtUsersModules->closeCursor();

// Daftar modul dalam bahasa Inggris dan Indonesia
$modulEnglish = ["archive", "circulation", "unit", "sub_unit", "media", "location", "room", "cupboard", "rack", "fromleft", "code_loc", "user", "now", "history", "restore", "import"];
$modulIndonesian = ["Arsip", "Sirkulasi", "Unit", "Sub Unit Kerja", "Media", "Lokasi", "Ruang", "Lemari", "Rak", "Urutan dari Kiri", "Kode Lokasi", "Pengguna", "Lokasi Sekarang", "Rekam Jejak", "Pemulihan", "Impor"];

// Inisialisasi array untuk menghitung jumlah pengguna yang memiliki akses "on" untuk setiap modul
$modulCounts = array_fill_keys($modulEnglish, 0);

// Menghitung jumlah akses "on" untuk setiap modul
foreach ($usersModules as $accessModul) {
    $accessModulData = json_decode($accessModul, true); // Dekode JSON dari kolom access_modul

    foreach ($modulEnglish as $modul) {
        if (isset($accessModulData[$modul]) && $accessModulData[$modul] === "on") {
            $modulCounts[$modul]++;
        }
    }
}

// Mengatur data modul dan jumlah pengguna dalam format yang akan digunakan oleh Chart.js
$modulLabels = json_encode($modulIndonesian);
$modulData = json_encode(array_values($modulCounts));



// Mengambil data format per bulan
$queryFormat = "
    SELECT DATE_FORMAT(created_at, '%Y-%m') AS month, format, COUNT(*) AS count
    FROM archived
    GROUP BY month, format
    ORDER BY month ASC";
$stmtFormat = $conn->prepare($queryFormat);
$stmtFormat->execute();
$dataForFormatChart = [];

while ($row = $stmtFormat->fetch(PDO::FETCH_ASSOC)) {
    $month = $row['month'];
    $format = $row['format'];
    $count = $row['count'];

    if (!isset($dataForFormatChart[$month])) {
        $dataForFormatChart[$month] = ['original' => 0, 'copy' => 0];
    }

    if ($format === 'original') {
        $dataForFormatChart[$month]['original'] = $count;
    } elseif ($format === 'copy') {
        $dataForFormatChart[$month]['copy'] = $count;
    }
}
$stmtFormat->closeCursor();

// Mengambil data media per bulan
$queryMedia = "
    SELECT DATE_FORMAT(a.created_at, '%Y-%m') AS month, m.media_type AS media_name, COUNT(a.id) AS count
    FROM archived a
    JOIN media m ON a.media_id = m.id
    GROUP BY month, media_name
    ORDER BY month ASC";
$stmtMedia = $conn->prepare($queryMedia);
$stmtMedia->execute();
$dataForMediaChart = [];

while ($row = $stmtMedia->fetch(PDO::FETCH_ASSOC)) {
    $month = $row['month'];
    $mediaName = $row['media_name'];
    $count = $row['count'];

    if (!isset($dataForMediaChart[$month])) {
        $dataForMediaChart[$month] = [];
    }
    $dataForMediaChart[$month][$mediaName] = $count;
}
$stmtMedia->closeCursor();

date_default_timezone_set("Asia/Jakarta"); // Set timezone ke Jakarta
$hour = date("H"); // Mendapatkan jam saat ini (format 24 jam)

if ($hour >= 5 && $hour < 12) {
    $greeting = "pagi";
    $icon = "fa-sun"; // Ikon matahari
    $color = "#FFD700"; // Warna kuning
} elseif ($hour >= 12 && $hour < 15) {
    $greeting = "siang";
    $icon = "fa-cloud-sun"; // Ikon matahari berawan
    $color = "#FF8C00"; // Warna oranye
} elseif ($hour >= 15 && $hour < 18) {
    $greeting = "sore";
    $icon = "fa-cloud"; // Ikon awan
    $color = "#1E90FF"; // Warna jingga
} else {
    $greeting = "malam";
    $icon = "fa-moon"; // Ikon bulan
    $color = "#0800A9FF"; // Warna biru malam
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Beranda Admin - Arsip PT Jasamarga Pandaan Tol</title>
    <link rel="icon" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-32x32.png" type="image/x-icon">
    <meta name="msapplication-TileImage" content="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-144x144.png">
    <link rel="apple-touch-icon-precomposed" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-152x152.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="../../public/assets/stylecreate10.css">
    <style>
        .greeting {
            text-align: center;
            color: <?php echo $color; ?>;
            animation: fadeIn 2s ease-in-out;
        }

        .icon {
            margin-top: 40px;
            font-size: 50px;
            margin-bottom: 0px;
            animation: bounce 1.5s infinite;
        }

        @keyframes bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        #clock {
            color: white;
            /* Ganti dengan warna yang diinginkan */
        }

        #calendar {
            font-size: 8.5px;
            margin-size: 0px;
            padding: 0px;
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        /* Styling untuk highlight-card */
        .highlight-card {
            border-radius: 5px;
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .highlight-card:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        /* H3 Styling */
        h3 {
            font-size: 2.0rem;
            font-weight: 700;
            margin: 0;
            line-height: 1.2;
        }

        /* Icon Styling */
        .fa-3x {
            opacity: 0.7;
        }

        /* Footer Hover Effect untuk highlight-card */
        .highlight-card .card-footer {
            background-color: rgba(0, 0, 0, 0.1);
            transition: background-color 0.3s;
        }

        .highlight-card .card-footer:hover {
            background-color: rgba(255, 255, 255, 0.2);
        }

        /* Interactive Ripple Effect */
        .stretched-link::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.3);
            opacity: 0;
            transition: opacity 0.2s;
            pointer-events: none;
        }

        .stretched-link:hover::after {
            opacity: 1;
        }

        .custom-modal-position {
            margin-top: 111px;
            /* Ubah angka ini sesuai keinginan */
        }

        /* Sidebar style */
        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        /* Navbar links */
        .navbar-custom .navbar-nav .nav-link {
            color: #ffffff;
            /* White text */
            font-size: 1rem;
            font-weight: 500;
            padding: 10px 15px;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .navbar-custom .navbar-nav .nav-link:hover {
            color: #ffc107;
            transform: translateY(-3px);
            /* Adds subtle lift effect */
        }

        /* Dropdown profile styling */
        .navbar-custom .dropdown-toggle {
            display: flex;
            align-items: center;
            color: #ffffff;
            transition: color 0.3s ease;
        }

        .navbar-custom .dropdown-toggle:hover {
            color: #ffc107;
        }

        /* Profile dropdown menu */
        .animated-dropdown {
            border-radius: 8px;
            margin-top: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            animation: fadeIn 0.3s ease;
        }

        /* Profile image and icon */
        .profile-img {
            border-radius: 50%;
            margin-right: 5px;
            transition: transform 0.3s ease;
        }

        .profile-icon {
            color: #ffffff;
            margin-right: 4px;
        }

        .navbar-custom .dropdown-item {
            color: #001eff;
            padding: 8px 15px;
            font-size: 0.95rem;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .navbar-custom .dropdown-item:hover {
            background-color: #ffc107;
            color: #ffffff;
        }

        /* Profile dropdown arrow */
        .profile-dropdown {
            color: #fff;
            transition: transform 0.3s;
        }

        .dropdown-toggle:hover .profile-dropdown {
            transform: rotate(180deg);
        }

        /* Dropdown animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Footer custom styling */
        .footer-custom {
            background-color: #001eff;
            /* Sama dengan sidebar dan navbar */
            color: #ffffff;
            padding: 15px 0;
            font-size: 0.9rem;
            font-weight: 500;
            box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.1);
            /* Subtle shadow on the top */
            transition: background-color 0.3s ease;
        }

        .footer-custom p {
            margin: 0;
            padding: 0;
            color: #e1e1e1;
            /* Light color for text */
        }

        .footer-custom p:hover {
            color: #ffc107;
            /* Warna hover */
            transform: translateY(-3px);
            /* Sedikit animasi naik saat hover */
            transition: color 0.3s ease, transform 0.3s ease;
        }

        /* Custom thead styling */
        .table .thead-dark th {
            background-color: #001eff;
            /* Warna latar belakang sesuai tema */
            color: #ffffff;
            /* Warna teks putih */
            font-weight: bold;
            text-align: center;
            /* Pusatkan teks */
            padding: 12px;
            transition: background-color 0.3s ease;
        }

        /* Hover effect on table headers */
        .table .thead-dark th:hover {
            background-color: #ffc107;
            /* Warna latar hover */
            color: #001eff;
            /* Warna teks pada hover */
            transform: translateY(-2px);
            /* Animasi sedikit naik */
        }

        /* Custom button styling */
        .btn-custom {
            background-color: #001eff;
            /* Sesuai dengan tema */
            color: #ffffff;
            font-size: 1rem;
            font-weight: 500;
            padding: 10px 20px;
            border-radius: 8px;
            border: none;
            display: inline-flex;
            align-items: center;
            transition: background-color 0.3s ease, transform 0.3s ease;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            /* Menambahkan bayangan untuk kedalaman */
        }

        .btn-custom i {
            margin-right: 2px;
            /* Jarak antara ikon dan teks */
            font-size: 1.2rem;
        }

        .btn-custom:hover {
            background-color: #ffc107;
            /* Warna hover */
            color: #001eff;
            /* Warna teks saat hover */
            transform: translateY(-2px);
            /* Sedikit efek naik saat hover */
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.25);
            /* Menambah bayangan pada hover */
        }

        .btn-custom:focus {
            outline: none;
            box-shadow: 0 0 0 4px rgba(0, 94, 255, 0.4);
            /* Fokus dengan outline biru transparan */
        }

        /* Styles for primary (blue) and warning (yellow) sections on card headers only */
        .card-header.bg-primary1 {
            background-color: #001eff !important;
            color: #ffffff !important;
        }

        .card-header.bg-warning1 {
            background-color: #ffc107 !important;
            color: #001eff !important;
        }

        /* Button hover effects */
        .btn-primary:hover,
        .btn-warning:hover,
        .btn-dark:hover,
        .btn-danger:hover,
        .btn-info:hover,
        .btn-success:hover,
        .btn-secondary:hover,
        .btn-light:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        }

        #ManagementArchive {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #PersentaseStatus {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #PersentaseItem {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #PersentaseAsli {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #Pengguna {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #Area {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #Format {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }

        #Media {
            width: 100% !important;
            /* Lebar 100% dari elemen induk */
            height: auto !important;
            /* Tinggi otomatis berdasarkan lebar */
            max-height: 300px;
            /* Batasi tinggi maksimal */
        }
    </style>
</head>

<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="../../public/assets/images/logo-jpt-350.png" alt="PT Jasamarga Pandaan Tol" width="150" height="83">
                <span class="toggle-sidebar-btn" id="toggleSidebar">
                    <i class="fas fa-bars"></i>
                </span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="profileDropdown" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php if ($profile_pic): ?>
                                <img src="../../public/assets/images/<?php echo $profile_pic; ?>" class="rounded-circle profile-img" height="30" alt="Profile">
                            <?php else: ?>
                                <i class="fas fa-user-circle fa-2x profile-icon"></i>
                            <?php endif; ?>
                            <span class="ml-1 mr-1"><?php echo $name; ?></span>
                            <i class="fas fa-caret-down profile-dropdown" id="profileArrow"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right animated-dropdown" aria-labelledby="profileDropdown">
                            <a class="dropdown-item" href="profile.php"><i class="fas fa-user"></i> Profil</a>
                            <a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt"></i> Keluar</a>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Sidebar -->
    <div class="sidebar sidebar-animated" id="sidebar">
        <br>
        <a href="dashboard.php" class="active"><i class="fas fa-home"></i> Beranda</a>
        <a href="entry.php"><i class="fas fa-folder-open"></i> ARSIP</a>
        <a href="approved.php"><i class="fas fa-recycle"></i> Sirkulasi</a>
        <a href="#manageSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#manageSubmenu" aria-expanded="false">
            <i class="fas fa-cogs"></i>Manajemen
            <i class="fas fa-caret-down arrow-icon ml-1" id="manageArrow"></i>
        </a>
        <div id="manageSubmenu" class="collapse submenu">
            <a href="unit.php"><i class="fas fa-building"></i> Unit</a>
            <a href="subunit.php"><i class="fas fa-sitemap"></i> Sub Unit Kerja</a>
            <a href="media.php"><i class="fas fa-photo-video"></i> Media</a>
        </div>
        <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
            <i class="fas fa-map-marker-alt"></i> Kelola Lokasi
            <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
        </a>
        <div id="locSubmenu" class="collapse submenu">
            <a href="location.php"><i class="fas fa-map-marker"></i> Lokasi</a>
            <a href="room.php"><i class="fas fa-door-open"></i>Ruang</a>
            <a href="cupboard.php"><i class="fas fa-archive"></i> Lemari</a>
            <a href="rack.php"><i class="fas fa-layer-group"></i> Rak</a>
            <a href="fromleft.php"><i class="fas fa-list-ol"></i> Urutan dari Kiri</a>
        </div>
        <a href="codeloc.php"><i class="fas fa-barcode"></i> Kode Lokasi</a>
        <a href="#trackSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#trackSubmenu" aria-expanded="false">
            <i class="fas fa-history"></i> Pelacakan
            <i class="fas fa-caret-down arrow-icon ml-1" id="trackArrow"></i>
        </a>
        <div id="trackSubmenu" class="collapse submenu">
            <a href="history.php"><i class="fas fa-clipboard-list"></i> Rekam Jejak</a>
            <a href="locnow.php"><i class="fas fa-clock"></i> Lokasi Sekarang</a>
        </div>
        <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
            <i class="fas fa-wrench"></i> Sistem
            <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
        </a>
        <div id="systemSubmenu" class="collapse submenu">
            <a href="restore.php"><i class="fas fa-undo-alt"></i> Pemulihan</a>
            <a href="import.php"><i class="fas fa-file-import"></i> Impor</a>
        </div>
        <a href="user.php"><i class="fas fa-users"></i> Pengguna</a>
        <br><br>
    </div>

    <!-- Main Content -->
    <div id="mainContent" class="content-container">
        <div class="dashboard-content">
            <div class="greeting">
                <i class="fas <?php echo $icon; ?> icon" style="color: <?php echo $color; ?>;"></i>
            </div>
            <h1 class="text-center mt-3 mb-2" style="color: blue;">Hello, <?php echo $name; ?>!</h1>
            <div class="greeting">
                <p class="mb-4">Selamat <?php echo $greeting; ?></p>
            </div>
            <p class="text-center" style="color: orange;"><strong>Kelola data Anda, sirkulasi, dan pengaturan sistem dari aplikasi arsip</strong></p><br>
            <p class="text-left mb-2">Silakan gunakan navigasi di sebelah kiri untuk mengakses informasi yang Anda butuhkan.</p>

            <div class="row">
                <!-- Card 1: Total Archive Documents -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-primary text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalArchived, 0, '', '.')) ?></h3>
                                <p>Keseluruhan Arsip Dokumen</p>
                            </div>
                            <i class="fas fa-folder-open fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="entry.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card 2: Items Outside -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-warning text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalOutside, 0, '', '.')) ?></h3>
                                <p>Barang di Luar (tidak bisa minjam)</p>
                            </div>
                            <i class="fas fa-book-reader fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="approved.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card 3: Circulation Approved -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-success text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalApproved, 0, '', '.')) ?></h3>
                                <p>Sirkulasi Disepakati Keduanya</p>
                            </div>
                            <i class="fas fa-check-circle fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="approved.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card 4: Items Not Returned -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-danger text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalNotReturned, 0, '', '.')) ?></h3>
                                <p>Barang Belum Dikembalikan</p>
                            </div>
                            <i class="fas fa-exclamation-triangle fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="approved.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card: Total Location -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-info text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalLocations, 0, '', '.')) ?></h3>
                                <p>Lokasi Tersedia Siap Digunakan</p>
                            </div>
                            <i class="fas fa-map-marker-alt fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="codeloc.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card: Waiting for Send -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-dark text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalWaitingSend, 0, '', '.')) ?></h3>
                                <p>Menunggu Pengiriman Anda</p>
                            </div>
                            <i class="fas fa-shipping-fast fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="approved.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card: Waiting for Return -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-secondary text-white shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalWaitingReturn, 0, '', '.')) ?></h3>
                                <p>Menunggu Pengembalian Anda</p>
                            </div>
                            <i class="fas fa-undo fa-3x text-light"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-white stretched-link" href="approved.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>

                <!-- Card: Total Users -->
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card highlight-card bg-light text-dark shadow-lg">
                        <div class="card-body d-flex align-items-center justify-content-between">
                            <div>
                                <h3><?= str_replace('.', '. ', number_format($totalUsers, 0, '', '.')) ?></h3>
                                <p>Data Karyawan Pengguna</p>
                            </div>
                            <i class="fas fa-users fa-3x text-dark"></i>
                        </div>
                        <div class="card-footer d-flex align-items-center justify-content-between">
                            <a class="small text-dark stretched-link" href="user.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                            <div class="small text-dark"><i class="fas fa-angle-right"></i></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4" id="row-management">
                <div class="col-xl-12">
                    <div class="card mb-4">
                        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-bar me-1"></i>
                                Manajemen Arsip
                            </div>
                            <div>
                                <button id="btn-minimize" class="btn btn-light btn-sm">
                                    <i id="icon-minimize" class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close" class="btn btn-light btn-sm">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body">
                            <div style="overflow-x: auto; width: 100%;">
                                <canvas id="ManagementArchive" style="min-width: 1000px;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <!-- Persentase Status Items based on Circulation -->
                <div class="col-xl-4" id="row-ttd">
                    <div class="card mb-4">
                        <div class="card-header bg-primary1 text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-pie me-1"></i>
                                Persentase Status
                            </div>
                            <div>
                                <button id="btn-minimize-ttd" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-ttd" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-ttd">
                            <canvas id="PersentaseStatus"></canvas>
                        </div>
                    </div>
                </div>
                <!-- Persentase Items Borrowed based on Return -->
                <div class="col-xl-4" id="row-tembusan">
                    <div class="card mb-4">
                        <div class="card-header bg-warning1 text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-pie me-1"></i>
                                Persentase Catatan
                            </div>
                            <div>
                                <button id="btn-minimize-tembusan" class="btn btn-light btn-sm text-warning">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-tembusan" class="btn btn-light btn-sm text-warning">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-tembusan">
                            <canvas id="PersentaseItem"></canvas>
                        </div>
                    </div>
                </div>
                <!-- Persentase Items Borrowed based on Return -->
                <div class="col-xl-4" id="row-asli">
                    <div class="card mb-4">
                        <div class="card-header bg-primary1 text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-pie me-1"></i>
                                Persentase Barang
                            </div>
                            <div>
                                <button id="btn-minimize-asli" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-asli" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-asli">
                            <canvas id="PersentaseAsli"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pengguna -->
            <div class="row mt-2">
                <div class="col-xl-6" id="row-pengguna">
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-area me-1"></i>
                                Pengguna
                            </div>
                            <div>
                                <button id="btn-minimize-pengguna" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-pengguna" class="btn btn-light btn-sm text-primary">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-pengguna">
                            <div style="overflow-x: auto; width: 100%;">
                                <canvas id="Pengguna" style="min-width: 500px;"></canvas>
                                <canvas id="Area" class="mt-4" style="min-width: 500px;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6" id="row-area">
                    <div class="card mb-4">
                        <div class="card-header bg-warning text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-chart-line me-1"></i>
                                Data Arsip
                            </div>
                            <div>
                                <button id="btn-minimize-area" class="btn btn-light btn-sm text-warning">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-area" class="btn btn-light btn-sm text-warning">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-area">
                            <div style="overflow-x: auto; width: 100%;">
                                <canvas id="Format" style="min-width: 500px;"></canvas>
                                <canvas id="Media" class="mt-4" style="min-width: 500px;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row mt-2">
                <!-- Last Update -->
                <div class="col-xl-9" id="row-lastupdate">
                    <div class="card mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-clock me-1"></i>
                                Pembaruan Terakhir
                            </div>
                            <div>
                                <button id="btn-minimize-lastupdate" class="btn btn-light btn-sm">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-lastupdate" class="btn btn-light btn-sm">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-lastupdate">
                            <!-- Konten tabel last update -->

                            <div class="table-wrapper">
                                <table class="table table-bordered table-hover table-striped">
                                    <thead class="thead-dark">
                                        <tr class="text-center">
                                            <th>No</th>
                                            <th>Nama</th>
                                            <th>Kegiatan</th>
                                            <th>Waktu</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $no = 1;
                                        foreach ($historyData as $history) {
                                            echo "<tr class='text-center'>";
                                            echo "<td>{$no}</td>";
                                            echo "<td>{$history['name']}</td>";
                                            echo "<td>{$history['note']}</td>";
                                            echo "<td>{$history['created_at']}</td>";
                                            echo "</tr>";
                                            $no++;
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-center">
                                <small><a href="history.php">&#x2022; Selengkapnya.. <i class="fas fa-external-link-alt"></i><span> &#x2022;</span></a></small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Kalender -->
                <div class="col-xl-3" id="row-kalender">
                    <div class="card mb-4">
                        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                            <div>
                                <i class="text-white icon-white fas fa-calendar-alt me-1"></i>
                                Kalender
                                <span id="clock" class="ms-0 mt-costum1 animate__animated animate__backInLeft animate__slow float-end"></span>
                            </div>
                            <div>
                                <button id="btn-minimize-kalender" class="btn btn-light btn-sm">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <button id="btn-close-kalender" class="btn btn-light btn-sm">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body" id="card-body-kalender">
                            <span id="date" class="ms-0 animate__animated animate__backInLeft animate__slow"></span>
                            <div id="calendar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer id="footer" class="mt-4 footer-custom">
        <div class="container text-center">
            <p>&copy; 2024 - <span id="currentYear"></span> PT Jasamarga Pandaan Tol. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // --- Grafik Format ---
            const dataForFormatChart = <?php echo json_encode($dataForFormatChart); ?>;
            const months = Object.keys(dataForFormatChart).sort();

            const formatChartData = {
                labels: months.map(month => month.replace('-', '/')),
                datasets: [{
                        label: "Original",
                        borderColor: '#001eff',
                        backgroundColor: 'rgba(0, 30, 255, 0.2)', // Tambah transparansi background
                        fill: true,
                        data: months.map(month => dataForFormatChart[month]?.original || 0),
                        tension: 0.4
                    },
                    {
                        label: "Copy",
                        borderColor: '#ffc107',
                        backgroundColor: 'rgba(255, 193, 7, 0.2)',
                        fill: true,
                        data: months.map(month => dataForFormatChart[month]?.copy || 0),
                        tension: 0.4
                    }
                ]
            };

            const formatChartConfig = {
                type: 'line',
                data: formatChartData,
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: {
                                    size: 12
                                },
                                padding: 10,
                                usePointStyle: true
                            }
                        },
                        title: {
                            display: true,
                            text: 'Format Data Arsip',
                            font: {
                                size: 14,
                                family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                weight: 'bold'
                            }
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false,
                            backgroundColor: 'rgba(0, 0, 0, 0.7)',
                            titleFont: {
                                size: 14
                            },
                            bodyFont: {
                                size: 12
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Jumlah',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                            },
                            grid: {
                                color: 'rgba(200, 200, 200, 0.2)'
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Bulan',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                            },
                            grid: {
                                color: 'rgba(200, 200, 200, 0.2)'
                            },
                            ticks: {
                                callback: function(value, index) {
                                    return this.getLabelForValue(index).replace('-', '/');
                                }
                            }
                        }
                    },
                    elements: {
                        point: {
                            radius: 3,
                            hoverRadius: 6
                        }
                    }
                }
            };

            const ctxFormat = document.getElementById('Format').getContext('2d');
            new Chart(ctxFormat, formatChartConfig);

            // --- Grafik Media ---
            const dataForMediaChart = <?php echo json_encode($dataForMediaChart); ?>;
            const monthsMedia = Object.keys(dataForMediaChart).sort();

            const mediaNames = new Set();
            monthsMedia.forEach(month => {
                Object.keys(dataForMediaChart[month]).forEach(mediaName => {
                    mediaNames.add(mediaName);
                });
            });

            const mediaColors = [
                'rgba(255, 0, 0, 1)', 'rgba(0, 128, 0, 1)', 'rgba(128, 0, 128, 1)', 'rgba(255, 255, 0, 1)',
                'rgba(255, 192, 203, 1)', 'rgba(165, 42, 42, 1)', 'rgba(0, 255, 255, 1)', 'rgba(255, 0, 255, 1)',
                'rgba(0, 255, 0, 1)', 'rgba(75, 0, 130, 1)', 'rgba(0, 128, 128, 1)', 'rgba(128, 128, 0, 1)',
                'rgba(255, 127, 80, 1)', 'rgba(64, 224, 208, 1)', 'rgba(128, 0, 0, 1)', 'rgba(0, 0, 128, 1)',
                'rgba(192, 192, 192, 1)', 'rgba(255, 215, 0, 1)', 'rgba(230, 230, 250, 1)', 'rgba(255, 218, 185, 1)',
                'rgba(220, 20, 60, 1)', 'rgba(0, 100, 0, 1)'
            ];

            let colorIndex = 0;
            const mediaChartData = {
                labels: monthsMedia.map(month => month.replace('-', '/')),
                datasets: Array.from(mediaNames).map(mediaName => {
                    const color = mediaColors[colorIndex % mediaColors.length];
                    const backgroundColor = color.replace(', 1)', ', 0.2)'); // Mengatur transparansi background color
                    colorIndex++;

                    return {
                        label: mediaName,
                        borderColor: color,
                        backgroundColor: backgroundColor,
                        fill: true,
                        data: monthsMedia.map(month => dataForMediaChart[month]?.[mediaName] || 0),
                        tension: 0.4
                    };
                })
            };

            const mediaChartConfig = {
                type: 'line',
                data: mediaChartData,
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: {
                                    size: 12
                                },
                                padding: 10,
                                usePointStyle: true
                            }
                        },
                        title: {
                            display: true,
                            text: 'Media Data Arsip',
                            font: {
                                size: 14,
                                family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                weight: 'bold'
                            }
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false,
                            backgroundColor: 'rgba(0, 0, 0, 0.7)',
                            titleFont: {
                                size: 14
                            },
                            bodyFont: {
                                size: 12
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Jumlah',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                            },
                            grid: {
                                color: 'rgba(200, 200, 200, 0.2)'
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Bulan',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                            },
                            grid: {
                                color: 'rgba(200, 200, 200, 0.2)'
                            },
                            ticks: {
                                callback: function(value, index) {
                                    return this.getLabelForValue(index).replace('-', '/');
                                }
                            }
                        }
                    },
                    elements: {
                        point: {
                            radius: 3,
                            hoverRadius: 6
                        }
                    }
                }
            };

            const ctxMedia = document.getElementById('Media').getContext('2d');
            new Chart(ctxMedia, mediaChartConfig);
        });



        document.addEventListener("DOMContentLoaded", function() {
            var ctx = document.getElementById('Pengguna').getContext('2d');
            var chartPengguna = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($subUnitNames); ?>, // Sumbu X dengan nama sub unit
                    datasets: [{
                        label: 'Jumlah Akun Pengguna per Sub Unit Kerja',
                        data: <?php echo json_encode($subUnitData); ?>, // Sumbu Y dengan jumlah pengguna
                        backgroundColor: 'rgba(0, 123, 255, 0.2)', // Biru dengan transparansi
                        borderColor: 'rgba(0, 123, 255, 1)', // Garis biru solid
                        pointBackgroundColor: <?php echo json_encode($colors); ?>, // Warna titik sesuai sub unit
                        pointBorderColor: 'rgba(0, 123, 255, 1)',
                        pointHoverBackgroundColor: 'rgba(0, 123, 255, 1)',
                        pointHoverBorderColor: 'rgba(255, 255, 255, 1)',
                        borderWidth: 2,
                        pointRadius: 5,
                        pointHoverRadius: 7,
                        fill: true,
                        tension: 0.5 // Smooth curve pada garis
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                            labels: {
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                    weight: 'bold'
                                },
                                color: '#333'
                            }
                        }
                    },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: 'Sub Unit Kerja',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                                color: '#333'
                            },
                            ticks: {
                                color: '#555',
                                font: {
                                    size: 12
                                }
                            }
                        },
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Jumlah',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                                color: '#333'
                            },
                            ticks: {
                                color: '#555',
                                font: {
                                    size: 12
                                }
                            },
                            grid: {
                                color: 'rgba(0, 123, 255, 0.1)'
                            }
                        }
                    }
                }
            });
        });


        document.addEventListener("DOMContentLoaded", function() {
            const ctx = document.getElementById('Area').getContext('2d');

            const areaChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: <?php echo $modulLabels; ?>,
                    datasets: [{
                        label: 'Jumlah Pengguna per Modul',
                        data: <?php echo $modulData; ?>,
                        backgroundColor: 'rgba(255, 165, 0, 0.2)', // Warna latar belakang oranye dengan transparansi
                        borderColor: 'rgba(255, 140, 0, 1)', // Garis oranye yang lebih cerah
                        borderWidth: 2, // Ketebalan garis
                        pointBackgroundColor: 'rgba(255, 140, 0, 1)', // Warna titik oranye
                        fill: true,
                        tension: 0.5 // Efek kurva halus pada garis
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                    weight: 'bold'
                                },
                                color: '#333'
                            }
                        }
                    },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: 'Modul',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                                color: '#333'
                            },
                            ticks: {
                                font: {
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                    size: 12
                                },
                                color: '#333'
                            }
                        },
                        y: {
                            title: {
                                display: true,
                                text: 'Jumlah',
                                font: {
                                    size: 14,
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif"
                                },
                                color: '#333'
                            },
                            ticks: {
                                font: {
                                    family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                                    size: 12
                                },
                                color: '#333'
                            }
                        }
                    }
                }
            });
        });

        // Data dari PHP
        const labels = <?php echo json_encode($months); ?>;
        const datasets = <?php echo json_encode($datasets); ?>;

        // Membuat chart
        const ctx = document.getElementById('ManagementArchive').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: datasets
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        title: {
                            display: true,
                            text: 'Bulan'
                        },
                        stacked: false
                    },
                    y: {
                        title: {
                            display: true,
                            text: 'Jumlah Arsip'
                        },
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                size: 12
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return `${context.dataset.label}: ${context.raw}`;
                            }
                        }
                    }
                }
            }
        });


        // Data dari PHP untuk status circulation
        const statusData = {
            labels: [
                `Menunggu <?php echo $statusCounts['waiting'] ?? 0; ?> item`,
                `Kondisi <?php echo $statusCounts['conditions'] ?? 0; ?> item`,
                `Disetujui <?php echo $statusCounts['approved'] ?? 0; ?> item`,
                `Ditolak <?php echo $statusCounts['rejected'] ?? 0; ?> item`
            ],
            datasets: [{
                data: [
                    <?php echo $statusCounts['waiting'] ?? 0; ?>,
                    <?php echo $statusCounts['conditions'] ?? 0; ?>,
                    <?php echo $statusCounts['approved'] ?? 0; ?>,
                    <?php echo $statusCounts['rejected'] ?? 0; ?>
                ],
                backgroundColor: ['#6c757d', '#17a2b8', '#28a745', '#dc3545']
            }]
        };
        const totalStatus = <?php echo $totalStatus; ?>;

        // Donut chart untuk status circulation
        new Chart(document.getElementById('PersentaseStatus'), {
            type: 'doughnut',
            data: statusData,
            options: {
                cutout: '50%',
                plugins: {
                    legend: {
                        position: 'bottom'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return `${context.label}: ${context.raw} item`;
                            }
                        }
                    }
                }
            }
        });

        <?php
        // Menghitung totalNote berdasarkan nilai yang valid (tidak null atau kosong)
        $totalNote = ($noteCounts['returned on time'] ?? 0) + ($noteCounts['returned late'] ?? 0) + ($noteCounts['not returned yet'] ?? 0);
        ?>

        // Data dari PHP untuk note circulation
        const noteData = {
            labels: [
                `Kembali Tepat Waktu <?php echo $noteCounts['returned on time'] ?? 0; ?> item`,
                `Kembali Telat <?php echo $noteCounts['returned late'] ?? 0; ?> item`,
                `Belum Dikembalikan <?php echo $noteCounts['not returned yet'] ?? 0; ?> item`
            ],
            datasets: [{
                data: [
                    <?php echo $noteCounts['returned on time'] ?? 0; ?>,
                    <?php echo $noteCounts['returned late'] ?? 0; ?>,
                    <?php echo $noteCounts['not returned yet'] ?? 0; ?>
                ],
                backgroundColor: ['blue', '#576afc', 'red']
            }]
        };
        const totalNote = <?php echo $totalNote; ?>;

        // Donut chart untuk note circulation
        new Chart(document.getElementById('PersentaseItem'), {
            type: 'doughnut',
            data: noteData,
            options: {
                cutout: '25%',
                plugins: {
                    legend: {
                        position: 'bottom'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return `${context.label}: ${context.raw} item`;
                            }
                        }
                    }
                }
            }
        });

        // Data dari PHP untuk status archived
        const archiveData = {
            labels: [
                `Arsip <?php echo $archiveCounts['archived'] ?? 0; ?> item`,
                `Dipinjam <?php echo $archiveCounts['borrowed'] ?? 0; ?> item`
            ],
            datasets: [{
                data: [
                    <?php echo $archiveCounts['archived'] ?? 0; ?>,
                    <?php echo $archiveCounts['borrowed'] ?? 0; ?>
                ],
                backgroundColor: ['blue', 'orange']
            }]
        };
        const totalArchive = <?php echo $totalArchive; ?>;

        // Pie chart untuk status archived
        new Chart(document.getElementById('PersentaseAsli'), {
            type: 'pie',
            data: archiveData,
            options: {
                plugins: {
                    legend: {
                        position: 'bottom'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return `${context.label}: ${context.raw} item`;
                            }
                        }
                    }
                }
            }
        });

        // Menampilkan total di bawah setiap chart
        document.getElementById('PersentaseStatus').insertAdjacentHTML('afterend', `<div style="text-align: center; margin-top: 5px;"><small>Total status sirkulasi: ${totalStatus}</small></div>`);
        document.getElementById('PersentaseItem').insertAdjacentHTML('afterend', `<div style="text-align: center; margin-top: 5px;"><small>Total catatan sirkulasi: ${totalNote}</small></div>`);
        document.getElementById('PersentaseAsli').insertAdjacentHTML('afterend', `<div style="text-align: center; margin-top: 5px;"><small>Total status barang: ${totalArchive}</small></div>`);


        // Script to update the year dynamically
        document.getElementById('currentYear').textContent = new Date().getFullYear();

        $(document).ready(function() {
            // Minimize button functionality
            $('#btn-minimize').click(function() {
                const body = $('#card-body');
                const icon = $(this).find('i');

                if (body.is(':visible')) {
                    body.slideUp(); // animasi menutup body
                    icon.removeClass('fa-minus').addClass('fa-plus'); // ganti ikon jadi plus
                } else {
                    body.slideDown(); // animasi membuka body
                    icon.removeClass('fa-plus').addClass('fa-minus'); // ganti ikon jadi minus
                }
            });

            // Close button functionality
            $('#btn-close').click(function() {
                $('#row-management').fadeOut(); // Hilangkan seluruh row
            });
        });
        $(document).ready(function() {
            // Fungsi Minimize dan Close untuk Tanda Tangan
            $('#btn-minimize-ttd').click(function() {
                const body = $('#card-body-ttd');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-ttd').click(function() {
                $('#row-ttd').fadeOut();
            });

            // Fungsi Minimize dan Close untuk Tembusan
            $('#btn-minimize-tembusan').click(function() {
                const body = $('#card-body-tembusan');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-tembusan').click(function() {
                $('#row-tembusan').fadeOut();
            });

            // Fungsi Minimize dan Close untuk Pengguna
            $('#btn-minimize-pengguna').click(function() {
                const body = $('#card-body-pengguna');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-pengguna').click(function() {
                $('#row-pengguna').fadeOut();
            });
            // Fungsi Minimize dan Close untuk Asli
            $('#btn-minimize-asli').click(function() {
                const body = $('#card-body-asli');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-asli').click(function() {
                $('#row-asli').fadeOut();
            });
            // Fungsi Minimize dan Close untuk Area
            $('#btn-minimize-area').click(function() {
                const body = $('#card-body-area');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-area').click(function() {
                $('#row-area').fadeOut();
            });

            // Fungsi Minimize dan Close untuk Last Update
            $('#btn-minimize-lastupdate').click(function() {
                const body = $('#card-body-lastupdate');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-lastupdate').click(function() {
                $('#row-lastupdate').fadeOut();
            });

            // Fungsi Minimize dan Close untuk Kalender
            $('#btn-minimize-kalender').click(function() {
                const body = $('#card-body-kalender');
                const icon = $(this).find('i');
                body.slideToggle();
                icon.toggleClass('fa-minus fa-plus');
            });
            $('#btn-close-kalender').click(function() {
                $('#row-kalender').fadeOut();
            });
        });
        document.addEventListener('DOMContentLoaded', function() {
            var sidebarToggle = document.getElementById('sidebarToggle');
            var body = document.body;

            sidebarToggle.addEventListener('click', function() {
                body.classList.toggle('sb-sidenav-toggled');
            });
        });
        // FullCalendar
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: 'path_to_your_api_or_php_script_for_calendar_events',
            });
            calendar.render();
        });

        function updateClock() {
            var currentTime = new Date();
            var currentHours = currentTime.getHours();
            var currentMinutes = currentTime.getMinutes();
            var currentSeconds = currentTime.getSeconds();
            currentMinutes = (currentMinutes < 10 ? "0" : "") + currentMinutes;
            currentSeconds = (currentSeconds < 10 ? "0" : "") + currentSeconds;
            var timeOfDay = (currentHours < 12) ? "AM" : "PM";
            currentHours = (currentHours > 12) ? currentHours - 12 : currentHours;
            currentHours = (currentHours == 0) ? 12 : currentHours;
            var currentTimeString = currentHours + ":" + currentMinutes + ":" + currentSeconds + " " + timeOfDay;
            document.getElementById("clock").innerHTML = currentTimeString;

            var days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
            var months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober',
                'November', 'Desember'
            ];
            var day = days[currentTime.getUTCDay()];
            var date = currentTime.getUTCDate();
            var month = months[currentTime.getUTCMonth()];
            var year = currentTime.getUTCFullYear();
            var dateString = day + ', ' + date + ' ' + month + ' ' + year;
            document.getElementById("date").innerHTML = dateString;
        }
        setInterval(updateClock, 1000);


        // Toggle Sidebar
        document.getElementById('toggleSidebar').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
            document.getElementById('mainContent').classList.toggle('content-shifted');
            document.getElementById('footer').classList.toggle('content-shifted');
        });

        // Toggle Profile Arrow
        $('#profileDropdown').on('click', function() {
            let arrow = $('#profileArrow');
            if ($(this).attr('aria-expanded') === 'true') {
                arrow.removeClass('fa-caret-up').addClass('fa-caret-down');
            } else {
                arrow.removeClass('fa-caret-down').addClass('fa-caret-up');
            }
        });

        // Toggle Manage Arrow
        $('#manageSubmenu').on('shown.bs.collapse', function() {
            $('#manageArrow').removeClass('fa-caret-down').addClass('fa-caret-up');
        }).on('hidden.bs.collapse', function() {
            $('#manageArrow').removeClass('fa-caret-up').addClass('fa-caret-down');
        });

        // Toggle System Arrow
        $('#systemSubmenu').on('shown.bs.collapse', function() {
            $('#systemArrow').removeClass('fa-caret-down').addClass('fa-caret-up');
        }).on('hidden.bs.collapse', function() {
            $('#systemArrow').removeClass('fa-caret-up').addClass('fa-caret-down');

        });
        // Toggle Track Arrow
        $('#trackSubmenu').on('shown.bs.collapse', function() {
            $('#trackArrow').removeClass('fa-caret-down').addClass('fa-caret-up');
        }).on('hidden.bs.collapse', function() {
            $('#trackArrow').removeClass('fa-caret-up').addClass('fa-caret-down');

        });
        // Toggle Loc Arrow
        $('#locSubmenu').on('shown.bs.collapse', function() {
            $('#locArrow').removeClass('fa-caret-down').addClass('fa-caret-up');
        }).on('hidden.bs.collapse', function() {
            $('#locArrow').removeClass('fa-caret-up').addClass('fa-caret-down');

        });
    </script>

</body>

</html>