<?php
session_start();
include('koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

function fetchBerita($conn)
{
    $sql = "SELECT * FROM berita ORDER BY created_at DESC";
    return $conn->query($sql);
}

$berita = fetchBerita($conn);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Berita</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo%20Header%20New.png" alt="#" style="width: 200px"></a>
            <a href="berita.php" class="active"><i class="fas fa-newspaper"></i> Berita</a>
            <a href="sosial.php"><i class="fas fa-share-alt"></i> Sosial</a>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Data Berita</h2>
            <a href="add_berita.php" class="btn btn-success mb-3"><i class="fas fa-plus-circle"></i> Tambah Berita</a>
            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th>Judul</th>
                        <th>Gambar</th>
                        <th>Deskripsi</th>
                        <th>Tanggal</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $id = 1;
                    while ($row = $berita->fetch_assoc()) { ?>
                        <tr>
                            <td class="text-center"><?php echo $id++; ?></td>
                            <td><?php echo $row['judul']; ?></td>
                            <td class="text-center"><img src="img/baru1/<?php echo $row['gambar']; ?>" width="200" alt="gambar"></td>
                            <td style="text-align: justify;"><small><?php echo $row['deskripsi']; ?></small></td>
                            <td class="text-center"><?php echo $row['tanggal']; ?></td>
                            <td class="text-center"><?php echo $row['created_at']; ?></td>
                            <td class="text-center">
                                <a href="edit_berita.php?id=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm mb-1"><i class="fas fa-edit"></i></a>
                                <a href="delete_berita.php?id=<?php echo $row['id']; ?>"
                                    class="btn btn-danger btn-sm"
                                    onclick="return confirm('Apakah Anda yakin ingin menghapus berita ini?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>