import json

# Buka file JSON
with open("penumbalan_data.json", "r", encoding="utf-8") as f:
    data = json.load(f)

# Cetak seluruh isi JSON
print("=== Isi JSON ===")
print(json.dumps(data, indent=4, ensure_ascii=False))

# Contoh akses data tertentu
print("\n=== Akses Data Tertentu ===")
print("Judul Cerita:", data["judul"])

print("\nTokoh-tokoh:")
for tokoh in data["tokoh"]:
    print(f"- {tokoh['nama']} ({tokoh['peran']})")

print("\nLokasi yang muncul:")
for lokasi in data["lokasi"]:
    print("-", lokasi)

print("\nPeristiwa Kronologis:")
for p in data["peristiwa"]:
    print(f"Step {p['tahap']}: {p['deskripsi']}")
