<?php
// Simple test to isolate the dari_tipe issue
// This will test the exact SQL statement that's failing

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Simple dari_tipe Insert Test</h1>";

include('koneksi.php');

if (!$conn || $conn->connect_error) {
    die("Connection failed: " . ($conn->connect_error ?? 'No connection object'));
}

echo "<p>✅ Database connected successfully</p>";

// Test the exact INSERT statement structure from create-letter.php
$test_sql = "INSERT INTO office(
    kepentingan, tipe_surat_id, jenis_surat_id, tempat_dibuat, klasifikasi_arsip_id, subjenis_surat_id,
    nomor_surat, sequence_number, tanggal_surat, dari_tipe, dari_pribadi, dibuat_oleh,
    kepada, perihal, paraf,
    lampiran_path, lampiran_orig_name, lampiran_mime, lampiran_size, file_surat,
    created_at, updated_at
) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, NOW(), NOW())";

echo "<h3>Testing INSERT with 'internal' value</h3>";

$stmt = $conn->prepare($test_sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

// Test values similar to what create-letter.php would use
$kepentingan = 'internal';
$tipe_surat_id = 1;
$jenis_surat_id = null;
$tempat_dibuat = 'Test Location';
$klasifikasi_arsip_id = null;
$subjenis_surat_id = null;
$nomor_surat = 'TEST-' . time();
$sequence_number = 1;
$tanggal_surat = date('Y-m-d');
$dari_tipe_db = 'internal';  // This is the problematic field
$dari_pribadi_db = 1;
$dibuat_oleh = 1;
$kepada = 'Test Kepada';
$perihal = 'Test Perihal';
$paraf = 'Test Paraf';
$lampiran_path = null;
$lampiran_orig = null;
$lampiran_mime = null;
$lampiran_size = 0;
$fileSuratPath = 'test.pdf';

echo "<p><strong>dari_tipe_db value:</strong> '$dari_tipe_db' (length: " . strlen($dari_tipe_db) . ")</p>";

// Debug the bind_param types and values
echo "<h4>Bind Parameters Debug:</h4>";
echo "<pre>";
echo "Type String: 'siisiisisissssssssis'\n";
echo "Values:\n";
echo "1. kepentingan: '$kepentingan'\n";
echo "2. tipe_surat_id: $tipe_surat_id\n";
echo "3. jenis_surat_id: " . ($jenis_surat_id ?? 'NULL') . "\n";
echo "4. tempat_dibuat: '$tempat_dibuat'\n";
echo "5. klasifikasi_arsip_id: " . ($klasifikasi_arsip_id ?? 'NULL') . "\n";
echo "6. subjenis_surat_id: " . ($subjenis_surat_id ?? 'NULL') . "\n";
echo "7. nomor_surat: '$nomor_surat'\n";
echo "8. sequence_number: $sequence_number\n";
echo "9. tanggal_surat: '$tanggal_surat'\n";
echo "10. dari_tipe: '$dari_tipe_db'\n";
echo "11. dari_pribadi_db: " . ($dari_pribadi_db ?? 'NULL') . "\n";
echo "12. dibuat_oleh: $dibuat_oleh\n";
echo "13. kepada: '$kepada'\n";
echo "14. perihal: '$perihal'\n";
echo "15. paraf: '$paraf'\n";
echo "16. lampiran_path: " . ($lampiran_path ?? 'NULL') . "\n";
echo "17. lampiran_orig: " . ($lampiran_orig ?? 'NULL') . "\n";
echo "18. lampiran_mime: " . ($lampiran_mime ?? 'NULL') . "\n";
echo "19. lampiran_size: $lampiran_size\n";
echo "20. fileSuratPath: '$fileSuratPath'\n";
echo "</pre>";

$stmt->bind_param(
    'siisiisisissssssssis',
    $kepentingan,
    $tipe_surat_id,
    $jenis_surat_id,
    $tempat_dibuat,
    $klasifikasi_arsip_id,
    $subjenis_surat_id,
    $nomor_surat,
    $sequence_number,
    $tanggal_surat,
    $dari_tipe_db,
    $dari_pribadi_db,
    $dibuat_oleh,
    $kepada,
    $perihal,
    $paraf,
    $lampiran_path,
    $lampiran_orig,
    $lampiran_mime,
    $lampiran_size,
    $fileSuratPath
);

if ($stmt->execute()) {
    $insert_id = $conn->insert_id;
    echo "<p style='color: green;'>✅ SUCCESS! Record inserted with ID: $insert_id</p>";

    // Clean up
    $conn->query("DELETE FROM office WHERE id = $insert_id");
    echo "<p>Test record cleaned up.</p>";
} else {
    echo "<p style='color: red;'>❌ FAILED!</p>";
    echo "<p><strong>Error:</strong> " . $stmt->error . "</p>";
    echo "<p><strong>Error Number:</strong> " . $stmt->errno . "</p>";
}

$stmt->close();

// Also test with direktif eksternal
echo "<hr><h3>Testing INSERT with 'eksternal' value</h3>";

$stmt2 = $conn->prepare($test_sql);
$dari_tipe_db2 = 'eksternal';
$kepentingan2 = 'eksternal';
$nomor_surat2 = 'TEST-EXT-' . time();

echo "<p><strong>dari_tipe_db value:</strong> '$dari_tipe_db2' (length: " . strlen($dari_tipe_db2) . ")</p>";

$stmt2->bind_param(
    'siisiisisissssssssis',
    $kepentingan2,
    $tipe_surat_id,
    $jenis_surat_id,
    $tempat_dibuat,
    $klasifikasi_arsip_id,
    $subjenis_surat_id,
    $nomor_surat2,
    $sequence_number,
    $tanggal_surat,
    $dari_tipe_db2,
    $dari_pribadi_db,
    $dibuat_oleh,
    $kepada,
    $perihal,
    $paraf,
    $lampiran_path,
    $lampiran_orig,
    $lampiran_mime,
    $lampiran_size,
    $fileSuratPath
);

if ($stmt2->execute()) {
    $insert_id2 = $conn->insert_id;
    echo "<p style='color: green;'>✅ SUCCESS! Record inserted with ID: $insert_id2</p>";

    // Clean up
    $conn->query("DELETE FROM office WHERE id = $insert_id2");
    echo "<p>Test record cleaned up.</p>";
} else {
    echo "<p style='color: red;'>❌ FAILED!</p>";
    echo "<p><strong>Error:</strong> " . $stmt2->error . "</p>";
    echo "<p><strong>Error Number:</strong> " . $stmt2->errno . "</p>";
}

$stmt2->close();
$conn->close();
?>

<style>
    body {
        font-family: Arial, sans-serif;
        margin: 20px;
    }

    pre {
        background: #f5f5f5;
        padding: 15px;
        border-radius: 5px;
    }

    hr {
        margin: 30px 0;
    }
</style>