<?php
// Debug script to check dari_tipe column and test values
// Upload this to your cPanel and run it to diagnose the issue

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Debug: dari_tipe Column Issue</h1>";

// Include database connection
if (file_exists('koneksi.php')) {
    include 'koneksi.php';

    if (isset($conn) && !$conn->connect_error) {
        echo "<h2>✅ Database Connection Successful</h2>";

        // Check column structure
        echo "<h3>1. Check dari_tipe Column Structure</h3>";
        $result = $conn->query("SHOW COLUMNS FROM office WHERE Field = 'dari_tipe'");
        if ($result && $result->num_rows > 0) {
            echo "<table border='1'>";
            echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                foreach ($row as $key => $value) {
                    echo "<td><strong>$key:</strong> " . htmlspecialchars($value ?? 'NULL') . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "❌ dari_tipe column not found!";
        }

        // Check existing data
        echo "<h3>2. Check Existing Data in dari_tipe Column</h3>";
        $result2 = $conn->query("SELECT dari_tipe, COUNT(*) as count FROM office GROUP BY dari_tipe ORDER BY dari_tipe");
        if ($result2 && $result2->num_rows > 0) {
            echo "<table border='1'>";
            echo "<tr><th>dari_tipe Value</th><th>Count</th><th>Length</th></tr>";
            while ($row = $result2->fetch_assoc()) {
                $value = $row['dari_tipe'];
                $length = strlen($value);
                echo "<tr>";
                echo "<td>'" . htmlspecialchars($value) . "'</td>";
                echo "<td>" . $row['count'] . "</td>";
                echo "<td>$length characters</td>";
                echo "</tr>";
            }
            echo "</table>";
        }

        // Test inserting different values
        echo "<h3>3. Test Inserting Values</h3>";
        $test_values = ['internal', 'eksternal', 'pribadi', 'sendiri'];

        foreach ($test_values as $test_val) {
            echo "<p>Testing value: '<strong>$test_val</strong>' (length: " . strlen($test_val) . ")</p>";

            // Map the value like in the actual code
            $mapped_val = '';
            switch ($test_val) {
                case 'pribadi':
                case 'sendiri':
                case 'internal':
                    $mapped_val = 'internal';
                    break;
                case 'eksternal':
                    $mapped_val = 'eksternal';
                    break;
            }

            echo "<p>Mapped to: '<strong>$mapped_val</strong>' (length: " . strlen($mapped_val) . ")</p>";

            // Try a simple test insert
            $test_sql = "INSERT INTO office (
                kepentingan, tipe_surat_id, tempat_dibuat, nomor_surat, tanggal_surat, 
                dari_tipe, kepada, perihal, file_surat, created_at, updated_at
            ) VALUES (
                'internal', 1, 'Test Location', 'TEST-" . time() . "', '" . date('Y-m-d') . "', 
                ?, 'Test Kepada', 'Test Perihal', 'test.pdf', NOW(), NOW()
            )";

            $stmt = $conn->prepare($test_sql);
            if ($stmt) {
                $stmt->bind_param('s', $mapped_val);
                if ($stmt->execute()) {
                    $insert_id = $conn->insert_id;
                    echo "<span style='color: green;'>✅ SUCCESS - Inserted with ID: $insert_id</span><br>";

                    // Clean up test record
                    $conn->query("DELETE FROM office WHERE id = $insert_id");
                } else {
                    echo "<span style='color: red;'>❌ FAILED - Error: " . $stmt->error . "</span><br>";
                }
                $stmt->close();
            } else {
                echo "<span style='color: red;'>❌ PREPARE FAILED - Error: " . $conn->error . "</span><br>";
            }
            echo "<hr>";
        }

        // Show full table structure
        echo "<h3>4. Full Office Table Structure</h3>";
        $result3 = $conn->query("DESCRIBE office");
        if ($result3) {
            echo "<table border='1'>";
            echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
            while ($row = $result3->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . htmlspecialchars($row['Field']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Type']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Null']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Key']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Default'] ?? 'NULL') . "</td>";
                echo "<td>" . htmlspecialchars($row['Extra']) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "<h2>❌ Database Connection Failed</h2>";
        echo "Error: " . $conn->connect_error;
    }
} else {
    echo "<h2>❌ koneksi.php file not found</h2>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        margin: 20px;
    }

    table {
        border-collapse: collapse;
        margin: 10px 0;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }

    hr {
        margin: 20px 0;
    }
</style>