<?php
// Enhanced test to isolate the exact issue with parameter binding
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Enhanced dari_tipe Debug Test</h1>";

include('koneksi.php');

if (!$conn || $conn->connect_error) {
    die("Connection failed: " . ($conn->connect_error ?? 'No connection object'));
}

echo "<p>✅ Database connected successfully</p>";

// Check MySQL mode
$result = $conn->query("SELECT @@sql_mode");
if ($result) {
    $row = $result->fetch_row();
    echo "<p><strong>MySQL SQL Mode:</strong> " . $row[0] . "</p>";
}

// Test 1: Minimal INSERT (only required fields)
echo "<h3>Test 1: Minimal INSERT (required fields only)</h3>";

$minimal_sql = "INSERT INTO office (kepentingan, tempat_dibuat, nomor_surat, tanggal_surat, dari_tipe, kepada, perihal, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";

$stmt1 = $conn->prepare($minimal_sql);
if (!$stmt1) {
    die("Prepare failed: " . $conn->error);
}

$kepentingan = 'internal';
$tempat_dibuat = 'Test Location';
$nomor_surat = 'MINIMAL-TEST-' . time();
$tanggal_surat = date('Y-m-d');
$dari_tipe = 'internal';
$kepada = 'Test Kepada';
$perihal = 'Test Perihal';

echo "<p>Testing with: kepentingan='$kepentingan', dari_tipe='$dari_tipe'</p>";

$stmt1->bind_param('ssssss', $kepentingan, $tempat_dibuat, $nomor_surat, $tanggal_surat, $dari_tipe, $kepada, $perihal);

if ($stmt1->execute()) {
    $insert_id = $conn->insert_id;
    echo "<p style='color: green;'>✅ SUCCESS! Minimal insert worked with ID: $insert_id</p>";
    $conn->query("DELETE FROM office WHERE id = $insert_id");
} else {
    echo "<p style='color: red;'>❌ FAILED! Error: " . $stmt1->error . "</p>";
}
$stmt1->close();

// Test 2: Add fields one by one to find the problematic one
echo "<hr><h3>Test 2: Progressive field addition</h3>";

// Test with tipe_surat_id added
$progressive_sql = "INSERT INTO office (kepentingan, tipe_surat_id, tempat_dibuat, nomor_surat, tanggal_surat, dari_tipe, kepada, perihal, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";

$stmt2 = $conn->prepare($progressive_sql);
$tipe_surat_id = 1;
$nomor_surat2 = 'PROG-TEST-' . time();

echo "<p>Adding tipe_surat_id = $tipe_surat_id</p>";

$stmt2->bind_param('sissssss', $kepentingan, $tipe_surat_id, $tempat_dibuat, $nomor_surat2, $tanggal_surat, $dari_tipe, $kepada, $perihal);

if ($stmt2->execute()) {
    $insert_id = $conn->insert_id;
    echo "<p style='color: green;'>✅ SUCCESS! With tipe_surat_id worked with ID: $insert_id</p>";
    $conn->query("DELETE FROM office WHERE id = $insert_id");
} else {
    echo "<p style='color: red;'>❌ FAILED! Error: " . $stmt2->error . "</p>";
}
$stmt2->close();

// Test 3: Test the exact parameter types and order from original
echo "<hr><h3>Test 3: Check original bind_param type string</h3>";

// The original has: 'siisiisisissssssssis'
// Let's count: s-i-i-s-i-i-s-i-s-i-s-i-s-s-s-s-s-s-s-i-s = 21 parameters
// But your SQL has 20 placeholders

echo "<p><strong>Issue found!</strong> The type string 'siisiisisissssssssis' has 21 characters but SQL has only 20 placeholders!</p>";

// Let's fix the type string
$corrected_sql = "INSERT INTO office(
    kepentingan, tipe_surat_id, jenis_surat_id, tempat_dibuat, klasifikasi_arsip_id, subjenis_surat_id,
    nomor_surat, sequence_number, tanggal_surat, dari_tipe, dari_pribadi, dibuat_oleh,
    kepada, perihal, paraf,
    lampiran_path, lampiran_orig_name, lampiran_mime, lampiran_size, file_surat,
    created_at, updated_at
) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, NOW(), NOW())";

echo "<p>SQL placeholders count: " . substr_count($corrected_sql, '?') . "</p>";

$stmt3 = $conn->prepare($corrected_sql);

// Test values
$kepentingan = 'internal';
$tipe_surat_id = 1;
$jenis_surat_id = null;
$tempat_dibuat = 'Test Location';
$klasifikasi_arsip_id = null;
$subjenis_surat_id = null;
$nomor_surat = 'CORRECTED-' . time();
$sequence_number = 1;
$tanggal_surat = date('Y-m-d');
$dari_tipe_db = 'internal';
$dari_pribadi_db = 1;
$dibuat_oleh = 1;
$kepada = 'Test Kepada';
$perihal = 'Test Perihal';
$paraf = 'Test Paraf';
$lampiran_path = null;
$lampiran_orig = null;
$lampiran_mime = null;
$lampiran_size = 0;
$fileSuratPath = 'test.pdf';

// Corrected type string (should be 20 characters for 20 parameters)
$type_string = 'siisisisissssssssis';
echo "<p>Corrected type string: '$type_string' (length: " . strlen($type_string) . ")</p>";

$stmt3->bind_param(
    $type_string,
    $kepentingan,          // s
    $tipe_surat_id,        // i
    $jenis_surat_id,       // i
    $tempat_dibuat,        // s
    $klasifikasi_arsip_id, // i
    $subjenis_surat_id,    // s - WAIT, this should be i
    $nomor_surat,          // s
    $sequence_number,      // i
    $tanggal_surat,        // s
    $dari_tipe_db,         // i - WAIT, this should be s
    $dari_pribadi_db,      // s - WAIT, this should be i
    $dibuat_oleh,          // s
    $kepada,               // s
    $perihal,              // s
    $paraf,                // s
    $lampiran_path,        // s
    $lampiran_orig,        // s
    $lampiran_mime,        // s
    $lampiran_size,        // i
    $fileSuratPath         // s
);

if ($stmt3->execute()) {
    $insert_id = $conn->insert_id;
    echo "<p style='color: green;'>✅ SUCCESS! Corrected version worked with ID: $insert_id</p>";
    $conn->query("DELETE FROM office WHERE id = $insert_id");
} else {
    echo "<p style='color: red;'>❌ FAILED! Error: " . $stmt3->error . "</p>";
}

$stmt3->close();
$conn->close();
?>

<style>
    body {
        font-family: Arial, sans-serif;
        margin: 20px;
    }

    pre {
        background: #f5f5f5;
        padding: 15px;
        border-radius: 5px;
    }

    hr {
        margin: 30px 0;
    }
</style>