<?php
// Simple PHP info and database connection test for cPanel
// Upload this file to your cPanel and access it via browser to debug issues

echo "<h1>PHP Environment Test for Jasa Marga</h1>";

echo "<h2>PHP Information</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Server Software: " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "<br>";
echo "Current Directory: " . __DIR__ . "<br>";

echo "<h2>PHP Extensions Check</h2>";
echo "MySQLi Extension: " . (extension_loaded('mysqli') ? "✅ Available" : "❌ Missing") . "<br>";
echo "GD Extension: " . (extension_loaded('gd') ? "✅ Available" : "❌ Missing") . "<br>";
echo "cURL Extension: " . (extension_loaded('curl') ? "✅ Available" : "❌ Missing") . "<br>";
echo "ZIP Extension: " . (extension_loaded('zip') ? "✅ Available" : "❌ Missing") . "<br>";

echo "<h2>File Permissions Check</h2>";
$directories = [
    'letter/uploads',
    'letter/uploads/lampiran',
    'letter/print',
    'img',
    'cache'
];

foreach ($directories as $dir) {
    $path = __DIR__ . '/' . $dir;
    if (file_exists($path)) {
        $writable = is_writable($path);
        echo "$dir: " . ($writable ? "✅ Writable" : "❌ Not writable") . "<br>";
    } else {
        echo "$dir: ❌ Directory doesn't exist<br>";
    }
}

echo "<h2>Database Connection Test</h2>";

// Test database connection
if (file_exists('koneksi.php')) {
    echo "koneksi.php file: ✅ Found<br>";

    try {
        // Suppress errors temporarily to avoid exposing credentials
        $old_error_reporting = error_reporting(0);

        include 'koneksi.php';

        if (isset($conn) && $conn instanceof mysqli) {
            if ($conn->connect_error) {
                echo "Database Connection: ❌ Failed<br>";
                echo "Error: " . $conn->connect_error . "<br>";
            } else {
                echo "Database Connection: ✅ Successful<br>";

                // Test if main tables exist
                $tables = ['users', 'office', 'agenda'];
                foreach ($tables as $table) {
                    $result = $conn->query("SHOW TABLES LIKE '$table'");
                    echo "Table '$table': " . ($result && $result->num_rows > 0 ? "✅ Exists" : "❌ Missing") . "<br>";
                }
            }
        } else {
            echo "Database Connection: ❌ Connection object not created<br>";
        }

        error_reporting($old_error_reporting);
    } catch (Exception $e) {
        echo "Database Connection: ❌ Exception occurred<br>";
        echo "Error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "koneksi.php file: ❌ Not found<br>";
}

echo "<h2>Common Issues & Solutions</h2>";
echo "<ul>";
echo "<li><strong>HTTP 500 Error:</strong> Usually database connection issues or PHP errors</li>";
echo "<li><strong>Database Connection Failed:</strong> Check credentials in koneksi.php</li>";
echo "<li><strong>File Upload Issues:</strong> Check directory permissions (should be 755 or 777)</li>";
echo "<li><strong>Image Display Issues:</strong> Check img/ directory and file paths</li>";
echo "</ul>";

echo "<h2>Next Steps</h2>";
echo "<ol>";
echo "<li>Fix any ❌ issues shown above</li>";
echo "<li>Update koneksi.php with correct cPanel database credentials</li>";
echo "<li>Import your database using cPanel phpMyAdmin</li>";
echo "<li>Set proper directory permissions if needed</li>";
echo "<li>Delete this test file after fixing issues</li>";
echo "</ol>";
