<?php
try {
    $pdo = new PDO('mysql:host=localhost;dbname=jasa_marga', 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    echo "=== Checking PP Jenis in Database ===\n\n";
    
    $stmt = $pdo->query("
        SELECT js.id, js.kode, js.nama, ka.kode as klas, ka.id as klas_id
        FROM jenis_surat js 
        JOIN klasifikasi_arsip ka ON js.id_klasifikasi = ka.id 
        WHERE ka.kode = 'PP' 
        ORDER BY CAST(js.kode AS UNSIGNED)
    ");
    
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($rows)) {
        echo "NO JENIS FOUND FOR PP!\n\n";
        
        // Check if PP klasifikasi exists
        $stmt2 = $pdo->query("SELECT id, kode, nama FROM klasifikasi_arsip WHERE kode = 'PP'");
        $pp = $stmt2->fetch(PDO::FETCH_ASSOC);
        
        if ($pp) {
            echo "PP Klasifikasi EXISTS: ID={$pp['id']}, Nama={$pp['nama']}\n";
            echo "But NO jenis found for this klasifikasi!\n";
        } else {
            echo "PP Klasifikasi NOT FOUND!\n";
        }
    } else {
        foreach ($rows as $row) {
            echo "{$row['klas']}-{$row['kode']}: {$row['nama']} (ID:{$row['id']}, KlasID:{$row['klas_id']})\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>