<?php
/**
 * PHPUnit Bootstrap File
 * This file is loaded before all tests are run
 */

// Set test environment
define('TESTING', true);
define('TEST_MODE', true);

// Set up error reporting for tests
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load Composer autoloader if it exists
if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
}

// Set up test database connection
$testDbConfig = [
    'host' => 'localhost',
    'port' => 3306,
    'database' => 'jasa_marga_test',
    'username' => 'root',
    'password' => 'root'
];

// You can add any global test setup here
class TestHelper
{
    public static function getTestDbConnection()
    {
        global $testDbConfig;
        
        try {
            $pdo = new PDO(
                "mysql:host={$testDbConfig['host']};port={$testDbConfig['port']};dbname={$testDbConfig['database']}",
                $testDbConfig['username'],
                $testDbConfig['password']
            );
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $pdo;
        } catch (PDOException $e) {
            throw new Exception("Test database connection failed: " . $e->getMessage());
        }
    }
    
    public static function cleanTestDatabase()
    {
        $pdo = self::getTestDbConnection();
        
        // Add cleanup queries here
        // $pdo->exec("TRUNCATE TABLE office");
        // $pdo->exec("TRUNCATE TABLE users");
    }
}

echo "Test environment initialized\n";