<?php
include(__DIR__ . '/../includes/koneksi.php');

$token = $_GET['token'] ?? '';
$id = isset($_GET['id']) && is_numeric($_GET['id']) ? (int)$_GET['id'] : 0;
$letterData = null;
$error = null;

if (!empty($token)) {
    // Query letter data by token (must be validated)
    $query = "
        SELECT 
            o.id, o.nomor_surat, o.tanggal_surat, o.tempat_dibuat,
            o.dari_pribadi, o.kepada, o.perihal, o.created_at,
            o.is_validated, o.qr_code,
            js.nama AS jenis_surat,
            ka.nama AS klasifikasi_arsip,
            u.nama AS nama_penandatangan,
            u.jabatan AS jabatan_penandatangan
        FROM office o
        LEFT JOIN jenis_surat js ON js.id = o.jenis_surat_id
        LEFT JOIN klasifikasi_arsip ka ON ka.id = o.klasifikasi_arsip_id
        LEFT JOIN users u ON u.id = o.dari_pribadi
        WHERE o.validation_token = ? AND o.is_validated = 1
        LIMIT 1
    ";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    $letterData = $result->fetch_assoc();

    if (!$letterData) {
        $error = "Surat tidak ditemukan atau belum divalidasi";
    }
} elseif ($id > 0) {
    // Query by ID – allow showing validation status even if not validated
    $query = "
        SELECT 
            o.id, o.nomor_surat, o.tanggal_surat, o.tempat_dibuat,
            o.dari_pribadi, o.kepada, o.perihal, o.created_at,
            o.is_validated, o.qr_code,
            js.nama AS jenis_surat,
            ka.nama AS klasifikasi_arsip,
            u.nama AS nama_penandatangan,
            u.jabatan AS jabatan_penandatangan
        FROM office o
        LEFT JOIN jenis_surat js ON js.id = o.jenis_surat_id
        LEFT JOIN klasifikasi_arsip ka ON ka.id = o.klasifikasi_arsip_id
        LEFT JOIN users u ON u.id = o.dari_pribadi
        WHERE o.id = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $letterData = $result->fetch_assoc();

    if (!$letterData) {
        $error = "Surat tidak ditemukan";
    }
} else {
    $error = "Token atau ID validasi tidak ditemukan";
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi Surat - PT Jasamarga Pandaan Tol</title>
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Header Styles - Top info bar */
        .top-info-bar {
            background: white;
            padding: 12px 0;
        }

        .info-container {
            display: flex;
            justify-content: flex-end;
            gap: 30px;
        }

        .info-item {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .info-icon {
            width: 45px;
            height: 45px;
            background: #0c50e1;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
        }

        .info-text h6 {
            margin: 0;
            font-size: 18px;
            color: #0c50e1;
            font-weight: 600;
            text-transform: capitalize;
        }

        .info-text p {
            margin: 0;
            font-size: 15px;
            color: #0c50e1;
            font-weight: 400;
        }

        /* Navigation Bar */
        .main-header {
            background: #0c50e1;
            padding: 0;
        }

        .nav-container {
            display: flex;
            justify-content: flex-start;
            align-items: center;
            gap: 15px;
        }

        .header-nav {
            display: flex;
            gap: 5px;
        }

        .header-nav .nav-item {
            position: relative;
        }

        .header-nav .nav-link {
            color: white;
            text-decoration: none;
            font-weight: 500;
            padding: 26px 20px;
            display: inline-block;
            transition: background 0.3s;
        }

        .header-nav .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .header-nav .nav-link i {
            font-size: 10px;
            margin-left: 5px;
        }

        .header-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            left: 0;
            background: white;
            min-width: 200px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            display: none;
            z-index: 1000;
        }

        .header-nav .nav-item:hover .dropdown-menu {
            display: block;
        }

        .header-nav .dropdown-menu a {
            color: #333;
            padding: 12px 20px;
            display: block;
            transition: background 0.3s;
        }

        .header-nav .dropdown-menu a:hover {
            background: #f0f5ff;
            color: #0c50e1;
        }

        .search-icon {
            padding: 22px 20px;
            color: white;
            border: 2px solid white;
            margin-left: 15px;
            cursor: pointer;
            transition: all 0.3s;
        }

        .search-icon:hover {
            background: white;
            color: #0c50e1;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            padding: 40px 0;
        }

        .verify-container {
            max-width: 900px;
            margin: 0 auto;
        }

        .verify-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .card-header-custom {
            background: #0c50e1;
            color: white;
            padding: 25px 40px;
            text-align: center;
        }

        .card-header-custom h2 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }

        .card-body-custom {
            padding: 40px;
        }

        /* Footer Styles */
        .site-footer {
            background: #f0f5ff;
            padding: 40px 0 20px;
            margin-top: auto;
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 30px;
        }

        .footer-logo img {
            height: 60px;
            margin-bottom: 15px;
        }

        .footer-logo p {
            color: #666;
            font-size: 13px;
            line-height: 1.6;
            max-width: 350px;
        }

        .footer-contact h5 {
            color: #0c50e1;
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .footer-contact p {
            color: #666;
            font-size: 13px;
            margin: 5px 0;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .footer-contact i {
            color: #0c50e1;
            width: 16px;
        }

        .footer-social {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }

        .footer-social a {
            width: 35px;
            height: 35px;
            background: #0c50e1;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
        }

        .footer-social a:hover {
            background: #001eff;
        }

        .footer-bottom {
            border-top: 1px solid #ddd;
            padding-top: 20px;
            text-align: center;
        }

        .footer-bottom p {
            margin: 0;
            color: #0c50e1;
            font-size: 13px;
            font-weight: 600;
        }

        .info-row {
            display: flex;
            padding: 15px 0;
            border-bottom: 1px solid #e9ecef;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: #0c50e1;
            min-width: 200px;
            flex-shrink: 0;
        }

        .info-value {
            color: #333;
            flex-grow: 1;
        }

        .status-badge {
            display: inline-block;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: 600;
            margin-top: 20px;
        }

        .status-valid {
            background: #28a745;
            color: white;
        }

        .status-invalid {
            background: #dc3545;
            color: white;
        }

        .qr-code-display {
            text-align: center;
            margin-top: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
        }

        .qr-code-display img {
            max-width: 200px;
            border: 3px solid #0c50e1;
            border-radius: 10px;
        }

        .error-container {
            text-align: center;
            padding: 60px 20px;
        }

        .error-icon {
            font-size: 80px;
            color: #dc3545;
            margin-bottom: 20px;
        }

        .success-icon {
            font-size: 80px;
            color: #28a745;
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <!-- Top Info Bar (White Background) -->
    <div class="top-info-bar">
        <div class="container">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div class="header-logo">
                    <a href="index.php">
                        <img src="img/logojpt/JmGempolPandaan.png" alt="Jasamarga Pandaan" style="height: 65px;">
                    </a>
                </div>
                <div class="info-container">
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="far fa-clock"></i>
                        </div>
                        <div class="info-text">
                            <h6>Opening Hour</h6>
                            <p>Mon - Fri, 8:00 - 17:00</p>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <div class="info-text">
                            <h6>Call Us</h6>
                            <p>(0343) 5650729</p>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="far fa-envelope"></i>
                        </div>
                        <div class="info-text">
                            <h6>Email Us</h6>
                            <p>jasamarga.pandaantol@gmail.com</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Bar (Blue Background) -->
    <div class="main-header">
        <div class="container">
            <div class="nav-container">
                <div class="header-nav">
                    <div class="nav-item">
                        <a href="index.php" class="nav-link">Home</a>
                    </div>
                    <div class="nav-item">
                        <a href="login.php" class="nav-link">Login</a>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">Tentang Kami <i class="fas fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Profil</a>
                            <a href="#">Visi & Misi</a>
                            <a href="#">Struktur Organisasi</a>
                        </div>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">Informasi Tol <i class="fas fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Tarif Tol</a>
                            <a href="#">Ruas Tol</a>
                            <a href="#">Layanan</a>
                        </div>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">Tata Kelola <i class="fas fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">GCG</a>
                            <a href="#">Pedoman</a>
                        </div>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">Berita</a>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">Contact</a>
                    </div>
                </div>
                <div class="search-icon">
                    <i class="fas fa-search"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="verify-container">
            <div class="verify-card">
                <div class="card-header-custom">
                    <h2>Verifikasi Surat Resmi</h2>
                </div>

                <div class="card-body-custom">
                    <?php if ($error): ?>
                        <div class="error-container">
                            <div class="error-icon">
                                <i class="fas fa-xmark"></i>
                            </div>
                            <h3 class="text-danger"><?= htmlspecialchars($error) ?></h3>
                        </div>
                    <?php else: ?>
                        <?php if (!empty($letterData) && (int)$letterData['is_validated'] === 1): ?>
                            <div class="text-center mb-4">
                                <div class="success-icon">
                                    <i class="fas fa-square-check"></i>
                                </div>
                                <h3 class="text-success">Approved, surat valid</h3>
                                <span class="status-badge status-valid">
                                    <i class="fas fa-square-check"></i> Approved — Surat valid
                                </span>
                            </div>

                            <!-- Letter Information Section -->
                            <div style="background: #f8f9fa; padding: 20px; border-radius: 10px; margin: 20px 0;">
                                <h5 style="color: #0c50e1; font-weight: 600; margin-bottom: 20px;">
                                    <i class="fas fa-file-lines"></i> Detail Surat
                                </h5>

                                <?php if (!empty($letterData['nomor_surat'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Nomor Surat</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['nomor_surat']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['jenis_surat'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Jenis Surat</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['jenis_surat']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['tanggal_surat'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Tanggal Surat</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['tanggal_surat']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['tempat_dibuat'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Tempat Dibuat</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['tempat_dibuat']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['perihal'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Perihal</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['perihal']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['kepada'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Ditujukan Kepada</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['kepada']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['nama_penandatangan'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Penandatangan</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['nama_penandatangan']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['jabatan_penandatangan'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Jabatan Penandatangan</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['jabatan_penandatangan']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['klasifikasi_arsip'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Klasifikasi Arsip</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['klasifikasi_arsip']) ?></div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($letterData['created_at'])): ?>
                                    <div class="info-row">
                                        <div class="info-label">Tanggal Dibuat Sistem</div>
                                        <div class="info-value"><?= htmlspecialchars($letterData['created_at']) ?></div>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if (!empty($letterData['qr_code']) && file_exists($letterData['qr_code'])): ?>
                                <div class="qr-code-display">
                                    <h6 style="color: #0c50e1;">QR Code Verifikasi</h6>
                                    <img src="<?= htmlspecialchars($letterData['qr_code']) ?>" alt="QR Code">
                                    <p class="text-muted mb-0 mt-2" style="font-size: 12px;">
                                        Scan QR Code ini untuk verifikasi ulang
                                    </p>
                                </div>
                            <?php endif; ?>

                            <div class="alert alert-info mt-4">
                                <i class="fas fa-info-circle"></i>
                                <strong>Informasi:</strong> Dokumen ini telah diverifikasi dan merupakan surat resmi dari PT
                                Jasamarga Pandaan Tol.
                                Jika Anda memiliki pertanyaan, silakan hubungi kantor kami.
                            </div>
                        <?php else: ?>
                            <div class="error-container">
                                <div class="error-icon">
                                    <i class="fas fa-xmark"></i>
                                </div>
                                <h3 class="text-danger">Surat belum di-approve</h3>
                                <p class="text-muted">Surat ini belum di-approve. Jika Anda menduga ini valid, mohon hubungi administrator.</p>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="site-footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="Jasamarga Pandaan">
                    <p>JasaMarga adalah perusahaan milik negara (BUMN) di Indonesia yang bergerak di bidang pengelolaan,
                        pembangunan, pengoperasian, dan pemeliharaan jalan tol.</p>
                </div>
                <div class="footer-contact">
                    <h5>GET IN TOUCH</h5>
                    <p><i class="fas fa-map-marker-alt"></i> 8PM4+J2C, Kali Tengah, Karang Jati, Kec. Pandaan, Pasuruan,
                        Jawa Timur 67156</p>
                    <p><i class="fas fa-phone"></i> 14080</p>
                    <p><i class="far fa-envelope"></i> jasamarga.pandaantol@gmail.com</p>
                    <div class="footer-social">
                        <a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" target="_blank"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <p>© 2024 - 2025 © PT Jasamarga Pandaan Tol, Kelompok Usaha PT Jasa Marga (Persero) Tbk | PT Jasamarga
                    Pandaan Tol Jumlah Pengunjung: 66156</p>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>