<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat Keputusan Direksi - Jasa Marga Pandaan Tol</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #111;
            background: #fff;
        }

        @page {
            size: A4;
            margin: 12mm 14mm 28mm 12mm;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 12mm 14mm 42mm 12mm;
            margin: 0 auto;
            position: relative;
            background: #fff;
        }

        .header {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 16px;
            margin-bottom: 15mm;
            width: 100%;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-shrink: 0;
        }

        .brand img.logo {
            height: 70px;
            width: auto;
            object-fit: contain;
            flex-shrink: 0;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            color: #0c50e1;
            margin-bottom: 5px;
        }

        .company-subtitle {
            text-align: right;
            font-size: 13px;
            color: #333;
            margin-bottom: 15px;
            flex-shrink: 0;
        }

        .doc-title {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
        }

        .doc-number {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
        }

        .doc-subject {
            font-size: 18px;
            font-weight: 600;
            text-align: center;
        }

        .content {
            font-size: 14px;
            line-height: 1.6;
            text-align: justify;
            margin-bottom: 15mm;
        }

        .content p {
            margin-bottom: 10px;
        }

        .considering-section,
        .remembering-section,
        .deciding-section {
            margin-bottom: 15px;
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 8px;
        }

        .section-title-2 {
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 12px;
            text-align: center;
        }

        .section-content {
            margin-left: 20px;
        }

        .two-column-section {
            display: flex;
        }

        .two-column-section .column {
            flex: 1;
        }

        .two-column-section .column-2 {
            flex: 8;
        }

        .two-column-section .column-2 p {
            margin: 0;
        }

        .numbered-list {
            padding-left: 4px;
            list-style: none;
        }

        .numbered-list ol {
            margin: 0;
        }

        .numbered-list li {
            margin-bottom: 5px;
            margin-top: 0px;
            position: relative;
        }

        .deciding-section {
            counter-reset: list-counter;
        }

        .page-break {
            page-break-before: always;
            break-before: page;
        }

        .signature-section {
            margin-top: 25mm;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            gap: 10mm;
        }

        .signature-info-table {
            margin-left: auto;
            margin-right: 0;
            width: auto;
            font-size: 14px;
        }

        .signature-info-table td {
            vertical-align: top;
        }

        .signature-info-table .label {
            font-weight: 600;
        }

        .signature-info-table .colon {
            font-weight: 600;
        }

        .company-title {
            text-align: center;
            font-weight: 600;
            font-size: 14px;
        }

        .signature-table {
            margin-left: 0;
            margin-right: 0;
            text-align: left;
            font-size: 14px;
        }

        .signature-table td {
            font-weight: 600;
            padding-right: 12px;
        }

        .signature-section-container {
            position: relative;
            text-align: center;
            flex: 1;
            order: 1;
        }

        .signature-paraf {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #000;
            text-align: center;
            margin-bottom: 8mm;
            min-height: 6mm;
            line-height: 1.2;
        }

        .signature-content {
            text-align: center;
        }

        .signature-qr-container {
            flex: 0 0 35mm;
            order: 2;
            display: flex;
            justify-content: center;
            align-items: flex-start;
        }

        .signature-qr-container .qr-code {
            width: 35mm;
            height: 35mm;
            display: block;
            margin: 0;
            border: none;
            padding: 0;
            background: transparent;
        }

        .signature-img {
            height: 22mm;
            width: auto;
            display: block;
            margin: 0 auto;
        }

        .signature-name {
            font-weight: 600;
            margin-top: 5mm;
            margin-right: 0;
            text-align: right;
        }

        .signature-sub-name {
            margin-right: 0;
            font-weight: 700;
            text-align: right;
        }

        .sign-block {
            margin-top: 20mm;
            width: 100%;
            display: flex;
            justify-content: flex-end;
        }

        .sign {
            width: 80mm;
            text-align: center;
            font-size: 14px;
            position: relative;
        }

        .sign .place-date {
            margin-bottom: 25mm;
        }

        .sign .qr-container {
            text-align: center;
            margin: 0 0 10mm 0;
        }

        .sign .qr-code {
            width: 35mm;
            height: 35mm;
            display: block;
            margin: 0 auto;
            margin-top: 60mm;
            border: none;
            padding: 0;
            background: transparent;
        }

        /* Standalone QR code image - now inside signature-qr-container */
        img.qr-code {
            display: none;
        }

        .signature-qr-container img.qr-code {
            display: block;
        }

        .sign .signature {
            height: 22mm;
            width: auto;
            display: block;
            margin: -4mm auto 0;
        }

        .sign .name {
            font-weight: 700;
            margin-top: 5mm;
        }

        .sign .sub-name {
            font-weight: 700;
        }

        .sign .title {
            margin-top: 2mm;
            min-height: 4mm;
        }

        .sign .paraf {
            position: absolute;
            bottom: -10mm;
            left: -40mm;
            font-size: 12px;
            color: #666;
        }

        /* Hide placeholder images - but NOT signature images with [[PATH_TANDA_TANGAN]] */
        img[src=""],
        img.qr-code[src*="[[QR_CODE"],
        img[src*="[[PATH_"]:not([src="[[PATH_TANDA_TANGAN]]"]) {
            display: none !important;
        }

        /* Hide empty QR container */
        .qr-container:has(img[src*="[[QR_CODE"]) {
            display: none !important;
        }

        .footer {
            position: absolute;
            bottom: 0mm;
            right: 16mm;
            width: auto;
            text-align: right;
            font-size: 10px;
            color: #333;
            line-height: 1.4;
            z-index: 1;
        }

        /* Nomor Surat editable parts styling */
        .nomor-surat-wrapper {
            display: inline;
        }

        .editable-sequence,
        .editable-year {
            background-color: #fff3cd;
            border: 1px dashed #ffc107;
            border-radius: 3px;
            padding: 0 4px;
            min-width: 30px;
            display: inline-block;
            cursor: text;
        }

        .editable-sequence:focus,
        .editable-year:focus {
            background-color: #fff8e1;
            border-color: #ff9800;
            outline: none;
        }

        .editable-sequence:hover,
        .editable-year:hover {
            background-color: #ffecb3;
        }

        @media print {
            @page {
                size: A4;
                margin: 12mm 20mm 28mm;
            }

            .page {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .editable-sequence,
            .editable-year {
                background-color: transparent;
                border: none;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="page">
        <header class="header">
            <div class="brand">
                <img class="logo" src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="Jasamarga">
            </div>
            <div class="company-subtitle">Penyelenggara Jalan Tol Gempol-Pandaan<br>Kelompok Usaha Jasa Marga</div>
        </header>

        <div class="doc-title">KEPUTUSAN DIREKSI PT JASAMARGA PANDAAN TOL</div>
        <div class="doc-number">NOMOR : <span class="editable-field" data-field="NOMOR_SURAT" contenteditable="true">[[NOMOR_SURAT]]</span></div>
        <div class="doc-title">TENTANG</div>
        <div class="doc-subject">PEDOMAN TATA PERSURATAN DAN KLASIFIKASI ARSIP</div>
        <hr>
        <div class="content">
            <div class="doc-title" style="margin-bottom: 12px;">DIREKSI PT JASAMARGA PANDAAN TOL</div>
            <div class="considering-section">
                <div class="two-column-section">
                    <div class="column">
                        <div class="section-title">Menimbang</div>
                    </div>
                    <div class="column">
                        <div class="section-title" style="text-align: center;">:</div>
                    </div>
                    <div class="column-2">
                        <p style="margin-bottom: 4px">a. bahwa dalam rangka penerapan administrasi persuratan yang baik dan Pengelolaan Arsip di
                            lingkungan PT Jasamarga Pandaan Tol, maka dipandang perlu mengatur Pedoman Tata Persuratan dan
                            Pengarsipan di lingkungan Perusahaan;</p>
                        <p style="margin-bottom: 9px">b. bahwa berdasarkan pertimbangan sebagaimana dimaksud dalam huruf a, maka dipandang perlu untuk
                            dituangkan dalam suatu Keputusan Direksi.</p>
                    </div>
                </div>
            </div>

            <div class="remembering-section">
                <div class="two-column-section">
                    <div class="column">
                        <div class="section-title">Mengingat</div>
                    </div>
                    <div class="column">
                        <div class="section-title" style="text-align: center;">:</div>
                    </div>
                    <div class="column-2">
                        <ol class="numbered-list" style="counter-reset: list-counter;">
                            <li>1. Peraturan Anggaran Dasar PT Jasamarga Pandaan Tol sesuai Akta Perubahan Anggaran Dasar PT
                                Jasamarga Pandaan Tol Nomor 1 tanggal 29 Januari 2020 yang dibuat dihadapan Dra. EC.
                                Mongkarli Djojosudiarso, SH Notaris di Surabaya, dan telah diberitahukan kepada Menteri
                                Jenderal Administrasi Hukum Umum Kementerian Hukum dan Hak Asasi Manusia Republik Indonesia
                                Nomor : AHU.0004004.AH.01.02 Tahun 2020 tanggal 30 Januari 2020;</li>
                            <li>2. Akta Pernyataan Keputusan Rapat Umum Pemegang Saham Luar Biasa Perusahaan Terbatas PT
                                Jasamarga Pandaan Tol Nomor: 13 tanggal 28 April 2022 yang dibuat dihadapan Ec.
                                Djojosudiarso, SH Notaris di Surabaya tentang Perubahan Susunan Pengurus Perseroan dan Hak
                                Asasi persetujuan Direktorat Jenderal Administrasi Hukum Umum Kementerian Hukum dan Hak
                                Asasi Manusia Republik Indonesia Nomor: AHU-AH.01.09-0010505 tanggal 28 April 2022;</li>
                            <li>3. Keputusan Direksi PT Jasa Marga (Persero) Tbk. Nomor : 62/KPTS/2021 tentang Instrumen
                                Pengelolaan Arsip Bagi PT Jasa Marga (Persero) Tbk. ;</li>
                            <li>4. Keputusan Direksi PT Jasamarga Pandaan Tol Nomor: 06/KPTS-JPT/2022 tanggal 29 April 2022
                                tentang Perubahan Pertama atas Keputusan Direksi PT Jasamarga Pandaan Tol Nomor :
                                02/KPTS-JPT/2022 tentang Struktur Organisasi PT Jasamarga Pandaan Tol.</li>
                        </ol>
                    </div>
                </div>
            </div>
            <br /><br /><br /><br /><br /><br /><br />
            <br /><br /><br /><br /><br />
            <div class="deciding-section">
                <div class="section-title-2">MEMUTUSKAN:</div>
                <div class="two-column-section">
                    <div class="column">
                        <div class="section-title">Menetapkan</div>
                    </div>
                    <div class="column">
                        <div class="section-title" style="text-align: center;">:</div>
                    </div>
                    <div class="column-2">
                        <p style="font-weight: bold;">KEPUTUSAN DIREKSI PT JASAMARGA PANDAAN TOL TENTANG
                            PEDOMAN TATA PERSURATAN DAN KLASIFIKASI ARSIP</p>
                        <p style="text-align: right; margin-top: 4px; margin-right: 12px;"><strong>BAB I .....</strong></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="signature-section">
            <div class="signature-section-container">
                <div class="signature-paraf">[[PARAF]]</div>
                <div class="signature-content">
                    <table class="signature-table">
                        <tr>
                            <td>Ditetapkan di</td>
                            <td>:</td>
                            <td><span class="editable-field" data-field="KOTA" contenteditable="true">[[KOTA]]</span></td>
                        </tr>
                        <tr>
                            <td>Pada tanggal</td>
                            <td>:</td>
                            <td><span class="editable-field" data-field="TANGGAL_SURAT" contenteditable="true">[[TANGGAL_SURAT]]</span></td>
                        </tr>
                    </table>
                    <div class="company-title">DIREKSI PT JASAMARGA PANDAAN TOL</div>
                    <img class="signature signature-img" src="[[PATH_TANDA_TANGAN]]" alt="Tanda Tangan">
                    <div class="signature-name">[[NAMA_PEJABAT]]</div>
                    <div class="signature-sub-name">[[JABATAN_PEJABAT]]</div>
                </div>
            </div>
            <div class="signature-qr-container">
                <img class="qr-code" src="[[QR_CODE]]" alt="QR Code">
            </div>
        </div>

        <footer class="footer">
            <div class="address">
                PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan, Pandaan<br>
                Pasuruan, Jawa Timur 67156<br>
                Telp: (0343) 5650727, 5650728, 5650729<br>
                Fax: (0343) 5650730<br>
                Email: jasamarga.pandaantol@gmail.com
            </div>
        </footer>
    </div>
</body>

</html>