<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat Keluar - Jasa Marga Pandaan Tol</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #111;
            background: #fff;
        }

        @page {
            size: A4;
            margin: 12mm 14mm 28mm 12mm;
        }

        :root {
            --page-w: 210mm;
            --page-h: 297mm;
            --pad-top: 12mm;
            --pad-right: 14mm;
            --pad-bottom: 42mm;
            --pad-left: 12mm;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 12mm 14mm 42mm 12mm;
            margin: 0 auto;
            position: relative;
            background: #fff;
        }

        .header {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 16px;
            margin-bottom: 8mm;
            width: 100%;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-shrink: 0;
        }

        .brand img.logo {
            height: 70px;
            width: auto;
            object-fit: contain;
            flex-shrink: 0;
        }

        .header .topnote {
            text-align: right;
            font-size: 13px;
            color: #333;
            max-width: 300px;
            margin-top: 20px;
            flex-shrink: 0;
        }

        /* Letter metadata section (Nomor, Lampiran, Hal) */
        .letter-meta {
            display: flex;
            justify-content: space-between;
            margin-bottom: 6mm;
            font-size: 14px;
        }

        .letter-meta-left {
            width: 60%;
        }

        .letter-meta-right {
            width: 40%;
            text-align: right;
        }

        .letter-meta table {
            border-collapse: collapse;
        }

        .letter-meta table td {
            padding: 2px 0;
            vertical-align: top;
        }

        .letter-meta table td.label {
            width: 80px;
        }

        .letter-meta table td.colon {
            width: 15px;
            text-align: center;
        }

        .letter-meta table td.value {
            font-weight: 500;
        }

        .place-date-header {
            font-size: 14px;
            margin-bottom: 2mm;
        }

        /* Recipient section */
        .recipient-section {
            margin-bottom: 6mm;
            font-size: 14px;
        }

        .recipient-section .yth {
            margin-bottom: 2mm;
        }

        .recipient-section .recipient-name {
            font-weight: 600;
        }

        .recipient-section .recipient-title {
            margin-bottom: 1mm;
        }

        .recipient-section .recipient-address {
            margin-bottom: 1mm;
        }

        /* Content section */
        .content-section {
            margin-bottom: 6mm;
            font-size: 14px;
            line-height: 1.6;
            text-align: justify;
        }

        .content-section p {
            margin-bottom: 4mm;
        }

        .content-section ul,
        .content-section ol {
            margin: 2mm 0 4mm 5mm;
            padding-left: 5mm;
        }

        .content-section li {
            margin-bottom: 2mm;
        }

        /* Opening/closing text */
        .opening-text {
            margin-bottom: 4mm;
        }

        .closing-text {
            margin-top: 4mm;
            margin-bottom: 6mm;
        }

        /* Signature block */
        .sign-block {
            margin-top: 12mm;
            width: 100%;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            position: relative;
            gap: 10mm;
        }

        .signature-paraf {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #000;
            text-align: left;
            margin-bottom: 0;
            min-height: 6mm;
            line-height: 1.2;
            flex: 1;
        }

        .sign {
            width: 72mm;
            text-align: center;
            font-size: 14px;
            position: relative;
            padding-top: 0;
            flex-shrink: 0;
        }

        .sign .qr-container {
            text-align: center;
            margin: 0 0 2mm 0;
        }

        .sign .qr-code {
            width: 35mm;
            height: 35mm;
            display: block;
            margin: 0 auto;
            border: none;
            padding: 0;
            background: transparent;
        }

        .sign .signature {
            height: 20mm;
            width: auto;
            display: block;
            margin: 0 auto 3mm;
        }

        /* Hide placeholder images */
        img[src*="[[PATH_"],
        img[src=""],
        img.qr-code[src*="[[QR_CODE"] {
            display: none !important;
        }

        /* Hide empty QR container */
        .qr-container:has(img[src*="[[QR_CODE"]) {
            display: none !important;
        }

        .sign .signature-info {
            display: block;
            margin-top: 0mm;
            text-align: center;
        }

        .sign-block .paraf {
            position: absolute;
            left: 0;
            bottom: 0;
            font-size: 14px;
            color: #333;
            text-align: left;
            font-weight: 500;
            white-space: nowrap;
        }

        .signature-paraf {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #000;
            text-align: left;
            margin-bottom: 10mm;
            min-height: 6mm;
            line-height: 1.2;
        }

        .sign .name {
            font-weight: 700;
            margin: 2mm 0 0 0;
            text-decoration: underline;
        }

        .sign .title {
            margin-top: 2mm;
            min-height: 4mm;
        }

        /* Footer */
        .footer {
            position: absolute;
            right: 14mm;
            bottom: 0mm;
            left: auto;
            width: auto;
            text-align: right;
            font-size: 10px;
            color: #333;
            line-height: 1.4;
        }

        .page .footer {
            display: block !important;
        }

        /* Page break controls */
        .sign-block,
        .footer,
        .letter-meta,
        .recipient-section {
            page-break-inside: avoid;
        }

        .page-appendix {
            page-break-before: always;
        }

        .lampiran-title {
            text-align: center;
            margin: 0 0 6mm;
            font-size: 16px;
            font-weight: 700;
        }

        .lampiran-meta {
            font-size: 12px;
            margin: 0 0 4mm;
            color: #444;
            text-align: center;
        }

        .lampiran-box {
            border: 1px solid #e0e0e0;
            padding: 6mm;
            text-align: center;
        }

        .lampiran-img {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
            max-height: calc(297mm - 12mm - 28mm - 26mm);
            object-fit: contain;
        }

        .editable-field {
            min-width: 50px;
            display: inline-block;
        }

        /* Nomor Surat editable parts styling */
        .nomor-surat-wrapper {
            display: inline;
        }

        .editable-sequence,
        .editable-year {
            background-color: #fff3cd;
            border: 1px dashed #ffc107;
            border-radius: 3px;
            padding: 0 4px;
            min-width: 30px;
            display: inline-block;
            cursor: text;
        }

        .editable-sequence:focus,
        .editable-year:focus {
            background-color: #fff8e1;
            border-color: #ff9800;
            outline: none;
        }

        .editable-sequence:hover,
        .editable-year:hover {
            background-color: #ffecb3;
        }

        @media print {
            @page {
                size: A4;
                margin: 12mm 20mm 28mm;
            }

            .page {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .editable-sequence,
            .editable-year {
                background-color: transparent;
                border: none;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="page">

        <header class="header">
            <div class="brand">
                <img class="logo" src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="Jasamarga">
            </div>
            <div class="topnote">
                Penyelenggara Jalan Tol Gempol-Pandaan<br>
                Kelompok Usaha Jasa Marga
            </div>
        </header>

        <!-- Letter Metadata Section -->
        <div class="letter-meta">
            <div class="letter-meta-left">
                <table>
                    <tr>
                        <td class="label">Nomor</td>
                        <td class="colon">:</td>
                        <td class="value"><span class="editable-field" data-field="NOMOR_SURAT"
                                contenteditable="true">[[NOMOR_SURAT]]</span></td>
                    </tr>
                    <tr>
                        <td class="label">Lampiran</td>
                        <td class="colon">:</td>
                        <td class="value"><span class="editable-field" data-field="LAMPIRAN"
                                contenteditable="true">-</span></td>
                    </tr>
                    <tr>
                        <td class="label">Hal</td>
                        <td class="colon">:</td>
                        <td class="value"><span class="editable-field" data-field="PERIHAL"
                                contenteditable="true">Konfirmasi Praktik Kerja Lapangan</span></td>
                    </tr>
                </table>
            </div>
            <div class="letter-meta-right">
                <div class="place-date-header"><span class="editable-field" data-field="KOTA"
                        contenteditable="true">[[KOTA]]</span>, <span class="editable-field" data-field="TANGGAL_SURAT"
                        contenteditable="true">[[TANGGAL_SURAT]]</span></div>
            </div>
        </div>

        <!-- Recipient Section -->
        <div class="recipient-section">
            <div class="yth">Yth.</div>
            <div class="recipient-name editable-field" data-field="KEPADA" contenteditable="true">Prof. Dr. Tika
                Widiastuti, S.E., M.Si</div>
            <div class="recipient-title editable-field" data-field="JABATAN_TUJUAN" contenteditable="true">Wakil Dekan I
            </div>
            <div class="recipient-address editable-field" data-field="ALAMAT_TUJUAN" contenteditable="true">Universitas
                Airlangga Surabaya</div>
        </div>

        <!-- Content Section -->
        <div class="content-section">
            <p class="opening-text">Berkenaan dengan surat Saudara Nomor <span class="editable-field"
                    contenteditable="true">8497/B/UN3.FV/I/PK.01.04/2025</span> tanggal <span class="editable-field"
                    contenteditable="true">25 Agustus 2025</span> Perihal Permohonan Ijin Praktik Kerja Lapangan untuk :
            </p>

            <table class="student-info" style="margin-left: 20px; margin-bottom: 4mm; border-collapse: collapse;">
                <tr>
                    <td style="width: 100px; padding: 2px 0;">Nama</td>
                    <td style="width: 15px; padding: 2px 0;">:</td>
                    <td style="padding: 2px 0; font-weight: 600;" class="editable-field" contenteditable="true">Feliza
                        Adelia Desti Rohmawati</td>
                </tr>
                <tr>
                    <td style="padding: 2px 0;">NIM</td>
                    <td style="padding: 2px 0;">:</td>
                    <td style="padding: 2px 0;" class="editable-field" contenteditable="true">434221033</td>
                </tr>
                <tr>
                    <td style="padding: 2px 0;">Program Studi</td>
                    <td style="padding: 2px 0;">:</td>
                    <td style="padding: 2px 0;" class="editable-field" contenteditable="true">D-IV Teknik Informatika
                    </td>
                </tr>
            </table>

            <p>Pada prinsipnya kami menyetujui Mahasiswa Saudara untuk melaksanakan Pratik Kerja Lapangan di PT
                Jasamarga Pandaan Tol mulai tanggal <span class="editable-field" contenteditable="true">15
                    September</span> s.d <span class="editable-field" contenteditable="true">15 Desember 2025</span>,
                dengan ketentuan sebagai berikut :</p>

            <ul style="margin-left: 5mm; padding-left: 5mm;">
                <li>Bahwa semua data yang dipelajari di Perusahaan selama Magang hanya untuk kepentingan akademis dan
                    tidak untuk dipublikasikan.</li>
                <li>Perusahaan tidak memberikan bantuan biaya atau dana selama Mahasiswi yang bersangkutan melaksanakan
                    Magang dimaksud.</li>
                <li>Selama pelaksanaan Magang, Mahasiswi yang bersangkutan diwajibkan mengikuti arahan dari unit kerja
                    terkait.</li>
                <li>Membuat laporan (<em>hard/soft copy</em>) hasil penelitian yang dipresentasikan kepada Direksi PT
                    Jasamarga Pandaan Tol.</li>
            </ul>

            <p class="closing-text">Demikian disampaikan, atas perhatian dan kerja samanya diucapkan terima kasih.</p>
        </div>

        <!-- Signature Block -->
        <div class="sign-block">
            <div class="signature-paraf">[[PARAF]]</div>
            <div class="sign">
                <div class="qr-container">
                    <img class="qr-code" src="[[QR_CODE]]" alt="QR Code">
                </div>
                <img class="signature" src="[[PATH_TANDA_TANGAN]]" alt="Tanda Tangan">
                <div class="signature-info">
                    <div class="name">[[NAMA_PEJABAT]]</div>
                    <div class="title">[[JABATAN_PEJABAT]]</div>
                </div>
            </div>
        </div>

        <footer class="footer">
            <div class="address">
                PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan<br>
                Pasuruan, Jawa Timur 67156<br>
                Telp: (0343) 5650727, 5650672, 5650729<br>
                Fax: (0343) 5650730<br>
                Email: jasamarga.pandaantol@gmail.com
            </div>
        </footer>

    </div>
</body>

</html>