<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat Edaran - Jasa Marga Pandaan Tol</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #111;
            background: #fff;
        }

        @page {
            size: A4;
            margin: 12mm 14mm 28mm 12mm;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 12mm 14mm 42mm 12mm;
            margin: 0 auto;
            position: relative;
            background: #fff;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15mm;
        }

        .header-left {
            flex: 1;
        }

        /* .header-left img.logo {
        height: 60px;
        width: auto;
        object-fit: contain;
    } */
        .header-left img.logo {
            height: 90px;
            width: 360px;
            object-fit: contain;
            display: block;
            /* Force maximum height */
        }

        .header-right {
            flex: 1;
            text-align: right;
            font-size: 13px;
            color: #333;
            line-height: 1.4;
        }

        .date-section .date-section-tanggal {
            text-align: right;
            font-size: 14px;
            font-weight: bold;
        }

        .address-section {
            margin-bottom: 12px;
        }

        .address-left {
            font-size: 14px;
            line-height: 1.5;
        }

        .doc-title-section {
            text-align: center;
            margin-bottom: 15mm;
        }

        .doc-title {
            font-size: 20px;
            font-weight: 900;
        }

        .doc-number {
            font-size: 16px;
            font-weight: 700;
        }

        .content {
            font-size: 14px;
            line-height: 1.6;
            text-align: justify;
            margin-bottom: 15mm;
        }

        .content p {
            margin-bottom: 12px;
        }

        .content-hal {
            font-weight: bold;
            margin-bottom: 8px;
        }

        .sign-section {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-top: 20mm;
            gap: 10mm;
        }

        .sign-left {
            flex: 1;
            font-size: 16px;
            font-weight: bold;
            color: #000;
            padding-top: 0;
            text-align: left;
            min-height: 8mm;
        }

        .signature-paraf {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #000;
            text-align: left;
            margin-bottom: 8mm;
            min-height: 6mm;
            line-height: 1.2;
        }

        .sign-right {
            flex: 1;
            text-align: center;
            font-size: 14px;
        }

        .sign-right .company-name {
            font-weight: bold;
            margin-bottom: 0mm;
        }

        .sign-right .qr-code {
            width: 35mm;
            height: 35mm;
            display: block;
            margin: 0 auto 0mm;
            border: none;
            padding: 0;
            background: transparent;
        }

        .sign-right .signature {
            height: 16mm;
            width: auto;
            display: block;
            margin: 0 auto 0mm;
        }

        .sign-right .name {
            font-weight: 700;
            margin-top: 0mm;
            text-decoration: underline;
        }

        .sign-right .title {
            margin-top: 0mm;
            min-height: 4mm;
        }

        /* Hide placeholder images */
        img[src*="[[PATH_"],
        img[src=""],
        img.qr-code[src*="[[QR_CODE"] {
            display: none !important;
        }

        .footer {
            position: absolute;
            right: 14mm;
            bottom: 10mm;
            text-align: right;
            font-size: 10px;
            color: #333;
            line-height: 1.4;
        }

        /* Nomor Surat editable parts styling */
        .nomor-surat-wrapper {
            display: inline;
        }

        .editable-sequence,
        .editable-year {
            background-color: #fff3cd;
            border: 1px dashed #ffc107;
            border-radius: 3px;
            padding: 0 4px;
            min-width: 30px;
            display: inline-block;
            cursor: text;
        }

        .editable-sequence:focus,
        .editable-year:focus {
            background-color: #fff8e1;
            border-color: #ff9800;
            outline: none;
        }

        .editable-sequence:hover,
        .editable-year:hover {
            background-color: #ffecb3;
        }

        @media print {
            @page {
                size: A4;
                margin: 12mm 20mm 28mm;
            }

            .page {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .editable-sequence,
            .editable-year {
                background-color: transparent;
                border: none;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="header">
            <div class="header-left">
                <img class="logo" src="/jasa_marga/img/logojpt-new/Logo%20Header%20New.png" alt="Jasamarga">
            </div>
            <div class="header-right">
                Penyelenggara Jalan Tol Gempol-Pandaan<br>
                Kelompok Usaha Jasa Marga
            </div>
        </div>

        <div class="date-section">
            <div class="date-section-tanggal">
                <span class="editable-field" data-field="TANGGAL_SURAT" contenteditable="true">[[TANGGAL_SURAT]]</span>
            </div>
        </div>

        <div class="address-section">
            <div class="address-left">
                Yth<br>
                Seluruh Karyawan PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan, Jalan Tol Gempol - Pandaan<br>
                Pasuruan
            </div>
        </div>

        <div class="doc-title-section">
            <div class="doc-title">SURAT EDARAN</div>
            <div class="doc-number">Nomor: <span class="editable-field" data-field="NOMOR_SURAT" contenteditable="true">[[NOMOR_SURAT]]</span></div>
        </div>

        <div class="content">
            <p class="content-hal">Hal: Perubahan Atas Pelaksanaan Hari Libur Nasional & Cuti Bersama Tahun 2025</p>

            <p>Menunjuk Surat Direktur Keuangan PT Jasamarga Transjawa Tol nomor : AC-JTT/HC/VIII/2025/551 tanggal 13
                Agustus 2025 tentang Perubahan Pelaksanaan Hari Libur Nasional dan Cuti Bersama Tahun 2025, maka Direksi
                memandang perlu menetapkan Perubahan Pelaksanaan Libur Nasional dan Cuti Bersama Tahun 2025 bagi
                Karyawan di Lingkungan PT Jasamarga Pandaan Tol sebagai berikut</p>

            <p>Demikian Surat Edaran ini dibuat untuk dilaksanakan sebagaimana mestinya.</p>
        </div>

        <div class="sign-section">
            <div class="sign-left">
                <div class="signature-paraf">[[PARAF]]</div>
            </div>
            <div class="sign-right">
                <div class="company-name">PT. Jasamarga Pandaan Tol</div>
                <img class="qr-code" src="[[QR_CODE]]" alt="QR Code">
                <img class="signature" src="[[PATH_TANDA_TANGAN]]" alt="Tanda Tangan">
                <div class="name">[[NAMA_PEJABAT]]</div>
                <div class="title">[[JABATAN_PEJABAT]]</div>
            </div>
        </div>

        <footer class="footer">
            <div class="address">
                PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan, Pandaan<br>
                Pasuruan, Jawa Timur 67156<br>
                Telp: (0343) 5650727, 5650728, 5650729<br>
                Fax: (0343) 5650730<br>
                Email: jasamarga.pandaantol@gmail.com
            </div>
        </footer>
    </div>
</body>

</html>