<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat [[JENIS_SURAT]] - Jasa Marga Pandaan Tol</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #111;
            background: #fff;
        }

        @page {
            size: A4;
            margin: 12mm 14mm 28mm 12mm;
        }

        :root {
            --page-w: 210mm;
            --page-h: 297mm;
            --pad-top: 12mm;
            --pad-right: 14mm;
            --pad-bottom: 42mm;
            --pad-left: 12mm;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 12mm 14mm 42mm 12mm;
            margin: 0 auto;
            position: relative;
            background: #fff;
        }

        .header {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 16px;
            margin-bottom: 10mm;
            width: 100%;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-shrink: 0;
        }

        .brand img.logo {
            height: 70px;
            width: auto;
            object-fit: contain;
            flex-shrink: 0;
        }

        .brand .title {
            line-height: 1.1;
            font-weight: 700;
            letter-spacing: .3px;
        }

        .brand .title .main {
            font-size: 22px;
            color: #0c50e1;
        }

        .brand .title .sub {
            font-size: 18px;
            color: #0c50e1;
            text-transform: uppercase;
        }

        .header .topnote {
            text-align: right;
            font-size: 13px;
            color: #333;
            max-width: 300px;
            margin-top: 20px;
            flex-shrink: 0;
        }

        .doc-title {
            text-align: center;
            margin: 2mm 0 0.8mm;
            font-weight: 900;
            font-size: 20px;
        }

        .doc-number {
            text-align: center;
            font-size: 18px;
            margin-bottom: 10mm;
            font-weight: 700;
        }

        .divider {
            height: 1px;
            background: #e6e9ef;
            margin: 2mm 0 8mm;
        }

        .section {
            margin-bottom: 6mm;
            font-size: 14px !important;
        }

        .lead {
            margin-bottom: 4mm;
        }

        table.kv {
            border-collapse: collapse;
            width: 100%;
            font-size: 14px;
        }

        table.kv td {
            padding: 2px 0;
            vertical-align: top;
        }

        table.kv td.col1 {
            width: 120px;
        }

        table.kv td.col2 {
            width: 10px;
        }

        table.kv td.col3 {
            width: auto;
        }

        span.highlight {
            font-weight: 700 !important;
        }

        .sign-block {
            margin-top: 8mm;
            width: 100%;
            display: flex;
            justify-content: flex-end;
            position: relative;
        }

        .sign {
            width: 72mm;
            text-align: left;
            font-size: 14px;
            position: relative;
            padding-top: 0;
        }

        .sign .place-date {
            margin-bottom: 15mm;
        }

        .sign .stamp {
            position: absolute;
            right: -8mm;
            top: 18mm;
            opacity: .85;
            width: 34mm;
            height: auto;
        }

        .sign .qr-container {
            text-align: center;
            margin: 0 0 6mm 0;
        }

        .sign .qr-code {
            width: 50mm;
            height: 50mm;
            display: block;
            margin: 0 auto;
            border: none;
            padding: 0;
            background: transparent;
        }

        .sign .signature {
            height: 18mm;
            width: auto;
            display: block;
            margin: -4mm 0 0 0;
        }

        /* Hide placeholder images */
        img[src*="[[PATH_"],
        img[src=""],
        img.qr-code[src*="[[QR_CODE"] {
            display: none !important;
        }

        /* Hide empty QR container */
        .qr-container:has(img[src*="[[QR_CODE"]) {
            display: none !important;
        }

        .sign .signature-info {
            display: block;
            margin-top: 20mm;
        }

        .sign-block .paraf {
            position: absolute;
            left: 0;
            bottom: 0;
            font-size: 14px;
            color: #333;
            text-align: left;
            font-weight: 500;
            white-space: nowrap;
        }

        .sign .name {
            font-weight: 700;
            margin: 0;
        }

        .sign .title {
            margin-top: 1mm;
            min-height: 4mm;
        }

        .footer {
            position: absolute;
            right: 14mm;
            bottom: 8mm;
            left: auto;
            width: auto;
            text-align: right;
            font-size: 10px;
            color: #333;
            line-height: 1.4;
        }

        .page .footer {
            display: block !important;
        }

        .sign-block,
        .footer,
        .doc-title,
        .doc-number,
        table.kv {
            page-break-inside: avoid;
        }

        .page-appendix {
            page-break-before: always;
        }

        .lampiran-title {
            text-align: center;
            margin: 0 0 6mm;
            font-size: 16px;
            font-weight: 700;
        }

        .lampiran-meta {
            font-size: 12px;
            margin: 0 0 4mm;
            color: #444;
            text-align: center;
        }

        .lampiran-box {
            border: 1px solid #e0e0e0;
            padding: 6mm;
            text-align: center;
        }

        .lampiran-img {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
            max-height: calc(297mm - 12mm - 28mm - 26mm);
            object-fit: contain;
        }

        .lampiran-frame {
            width: 100%;
            height: calc(297mm - 12mm - 28mm - 26mm);
            border: 0;
            display: none;
        }

        /* Nomor Surat editable parts styling */
        .nomor-surat-wrapper {
            display: inline;
        }

        .editable-sequence,
        .editable-year {
            background-color: #fff3cd;
            border: 1px dashed #ffc107;
            border-radius: 3px;
            padding: 0 4px;
            min-width: 30px;
            display: inline-block;
            cursor: text;
        }

        .editable-sequence:focus,
        .editable-year:focus {
            background-color: #fff8e1;
            border-color: #ff9800;
            outline: none;
        }

        .editable-sequence:hover,
        .editable-year:hover {
            background-color: #ffecb3;
        }

        @media print {
            @page {
                size: A4;
                margin: 12mm 20mm 28mm;
            }

            .page {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .editable-sequence,
            .editable-year {
                background-color: transparent;
                border: none;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="page">

        <header class="header">
            <div class="brand">
                <img class="logo" src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="Jasamarga">
            </div>
            <div class="topnote">
                Penyelenggara Jalan Tol Gempol-Pandaan<br>
                Kelompok Usaha Jasa Marga
            </div>
        </header>

        <div class="doc-title">[[DOCUMENT_TITLE]]</div>
        <div class="doc-number">Nomor : <span class="editable-field" data-field="NOMOR_SURAT" contenteditable="true">[[NOMOR_SURAT]]</span></div>

        <section class="section">
            <div class="lead" style="font-size: 14px;">Yang bertandatangan di bawah ini :</div>
            <table class="kv">
                <tr>
                    <td class="col1">Nama</td>
                    <td class="col2">:</td>
                    <td class="col3">[[NAMA_PEJABAT]]</td>
                </tr>
                <tr>
                    <td class="col1">NIK</td>
                    <td class="col2">:</td>
                    <td class="col3">[[NIK_PEJABAT]]</td>
                </tr>
                <tr>
                    <td class="col1">Jabatan</td>
                    <td class="col2">:</td>
                    <td class="col3">[[JABATAN_PEJABAT]]</td>
                </tr>
                <tr>
                    <td class="col1">Departemen</td>
                    <td class="col2">:</td>
                    <td class="col3">[[DEPARTEMEN]]</td>
                </tr>
                <tr>
                    <td class="col1">Perusahaan</td>
                    <td class="col2">:</td>
                    <td class="col3">[[NAMA_PERUSAHAAN]]</td>
                </tr>
            </table>
        </section>

        <section class="section">
            <div class="lead" style="font-size: 14px;">Menerangkan bahwa :</div>
            <table class="kv">
                <tr>
                    <td class="col1">Nama</td>
                    <td class="col2">:</td>
                    <td class="col3">[[NAMA_MAHASISWA]]</td>
                </tr>
                <tr>
                    <td class="col1">NIM</td>
                    <td class="col2">:</td>
                    <td class="col3">[[NIM]]</td>
                </tr>
                <tr>
                    <td class="col1">Jurusan</td>
                    <td class="col2">:</td>
                    <td class="col3">[[JURUSAN]]</td>
                </tr>
                <tr>
                    <td class="col1">Program Studi</td>
                    <td class="col2">:</td>
                    <td class="col3">[[PROGRAM_STUDI]]</td>
                </tr>
                <tr>
                    <td class="col1">Universitas</td>
                    <td class="col2">:</td>
                    <td class="col3">[[UNIVERSITAS]]</td>
                </tr>
            </table>
        </section>

        <section class="section" style="font-size:14px;">
            Adalah benar telah melaksanakan magang mandiri di <span class="highlight">[[NAMA_PERUSAHAAN]]</span> sejak
            tanggal
            <span class="highlight">[[TANGGAL_MULAI]]</span> s.d <span class="highlight">[[TANGGAL_SELESAI]]</span>.
        </section>

        <section class="section" style="font-size:14px;">
            Demikian surat keterangan ini saya buat dengan sebenarnya, untuk dipergunakan sebagaimana mestinya.
        </section>

        <div class="sign-block">
            <div class="paraf">[[PARAF]]</div>
            <div class="sign">
                <div class="place-date">[[KOTA]], [[TANGGAL_SURAT]]</div>
                <!-- <img class="stamp" src="[[PATH_STEMPEL]]" alt="Stempel"> -->
                <img class="signature" src="[[PATH_TANDA_TANGAN]]" alt="Tanda Tangan">
                <div class="signature-info">
                    <div class="name">[[NAMA_PEJABAT]]</div>
                    <div class="title">[[JABATAN_PEJABAT]]</div>
                </div>
            </div>
        </div>

        <footer class="footer">
            <div class="address">
                PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan<br>
                Pasuruan, Jawa Timur 67156<br>
                Telp: (0343) 5650727, 5650672, 5650729<br>
                Fax: (0343) 5650730<br>
                Email: jasamarga.pandaantol@gmail.com
            </div>
        </footer>

    </div>
</body>

</html>