<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>[[DOCUMENT_TITLE]] - Jasa Marga Pandaan Tol</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #111;
            background: #fff;
        }

        @page {
            size: A4;
            margin: 12mm 14mm 28mm 12mm;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 12mm 14mm 42mm 12mm;
            margin: 0 auto;
            position: relative;
            background: #fff;
        }

        .header {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 16px;
            margin-bottom: 10mm;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .brand img.logo {
            height: 70px;
            width: auto;
            object-fit: contain;
        }

        .brand .title {
            line-height: 1.1;
            font-weight: 700;
            letter-spacing: .3px;
        }

        .brand .title .main {
            font-size: 22px;
            color: #0c50e1;
        }

        .brand .title .sub {
            font-size: 18px;
            color: #0c50e1;
            text-transform: uppercase;
        }

        .header .topnote {
            text-align: right;
            font-size: 13px;
            color: #333;
            max-width: 300px;
            margin-top: 20px;
        }

        .doc-title {
            text-align: center;
            margin: 2mm 0 0.8mm;
            font-weight: 900;
            font-size: 20px;
            text-transform: uppercase;
            text-decoration: underline;
        }

        .doc-number {
            text-align: center;
            font-size: 16px;
            margin-bottom: 10mm;
            font-weight: 600;
        }

        .divider {
            height: 1px;
            background: #e6e9ef;
            margin: 2mm 0 8mm;
        }

        .section {
            margin-bottom: 6mm;
            font-size: 14px !important;
        }

        .lead {
            margin-bottom: 4mm;
        }

        table.kv {
            border-collapse: collapse;
            width: 100%;
            font-size: 14px;
        }

        table.kv td {
            padding: 2px 0;
            vertical-align: top;
        }

        table.kv td.col1 {
            width: 100px;
        }

        table.kv td.col2 {
            width: 10px;
        }

        table.kv td.col3 {
            width: auto;
        }

        span.highlight {
            font-weight: 700 !important;
        }

        .letter-body {
            margin: 8mm 0;
            font-size: 14px;
            line-height: 1.6;
            text-align: justify;
        }

        .letter-body p {
            margin: 0 0 4mm 0;
            text-indent: 10mm;
        }

        .sign-block {
            margin-top: 12mm;
            width: 100%;
            display: flex;
            justify-content: flex-end;
        }

        .sign {
            width: 72mm;
            text-align: left;
            font-size: 14px;
            position: relative;
            padding-top: 0;
        }

        .sign .place-date {
            margin-bottom: 22mm;
        }

        .sign .stamp {
            position: absolute;
            right: -8mm;
            top: 18mm;
            opacity: .85;
            width: 34mm;
            height: auto;
        }

        .sign .qr-container {
            text-align: center;
            margin: 0 0 10mm 0;
        }

        .sign .qr-code {
            width: 50mm;
            height: 50mm;
            display: block;
            margin: 0 auto;
            border: none;
            padding: 0;
            background: transparent;
        }

        .sign .signature {
            height: 22mm;
            width: auto;
            display: block;
            margin: -4mm 0 0 0;
        }

        /* Hide placeholder images */
        img[src*="[[PATH_"],
        img[src=""],
        img.qr-code[src*="[[QR_CODE"] {
            display: none !important;
        }

        /* Hide empty QR container */
        .qr-container:has(img[src*="[[QR_CODE"]) {
            display: none !important;
        }

        .sign .signature-info {
            display: inline-block;
            vertical-align: top;
            margin-top: 32mm;
            width: 55%;
        }

        .sign .name {
            font-weight: 700;
            margin: 0;
        }

        .sign .title {
            margin-top: 1mm;
            min-height: 4mm;
        }

        .sign .paraf {
            display: inline-block;
            vertical-align: top;
            margin-top: 32mm;
            margin-left: 4mm;
            width: 40%;
            font-size: 12px;
            color: #333;
            text-align: left;
            font-weight: 500;
        }

        .footer {
            position: absolute;
            right: 14mm;
            bottom: 0mm;
            left: auto;
            width: auto;
            text-align: right;
            font-size: 10px;
            color: #333;
            line-height: 1.4;
        }

        .page .footer {
            display: none !important;
        }

        .page:first-of-type .footer {
            display: block !important;
        }

        .sign-block,
        .footer,
        .doc-title,
        .doc-number,
        table.kv {
            page-break-inside: avoid;
        }

        .page-appendix {
            page-break-before: always;
        }

        .lampiran-title {
            text-align: center;
            margin: 0 0 6mm;
            font-size: 16px;
            font-weight: 700;
        }

        .lampiran-meta {
            font-size: 12px;
            margin: 0 0 4mm;
            color: #444;
            text-align: center;
        }

        .lampiran-box {
            border: 1px solid #e0e0e0;
            padding: 6mm;
            text-align: center;
        }

        .lampiran-img {
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
            max-height: calc(297mm - 12mm - 28mm - 26mm);
            object-fit: contain;
        }

        .lampiran-frame {
            width: 100%;
            height: calc(297mm - 12mm - 28mm - 26mm);
            border: 0;
            display: none;
        }

        /* Nomor Surat editable parts styling */
        .nomor-surat-wrapper {
            display: inline;
        }

        .editable-sequence,
        .editable-year {
            background-color: #fff3cd;
            border: 1px dashed #ffc107;
            border-radius: 3px;
            padding: 0 4px;
            min-width: 30px;
            display: inline-block;
            cursor: text;
        }

        .editable-sequence:focus,
        .editable-year:focus {
            background-color: #fff8e1;
            border-color: #ff9800;
            outline: none;
        }

        .editable-sequence:hover,
        .editable-year:hover {
            background-color: #ffecb3;
        }

        @media print {
            @page {
                size: A4;
                margin: 12mm 20mm 28mm;
            }

            .page {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .editable-sequence,
            .editable-year {
                background-color: transparent;
                border: none;
                padding: 0;
            }
        }
    </style>
</head>

<body>
    <div class="page">

        <header class="header">
            <div class="brand">
                <img class="logo" src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="Jasamarga">
            </div>
            <div class="topnote">
                Penyelenggara Jalan Tol Gempol-Pandaan<br>
                Kelompok Usaha Jasa Marga
            </div>
        </header>

        <div class="doc-title">[[DOCUMENT_TITLE]]</div>
        <div class="doc-number">Nomor : <span class="editable-field" data-field="NOMOR_SURAT" contenteditable="true">[[NOMOR_SURAT]]</span></div>

        <section class="section">
            <table class="kv">
                <tr>
                    <td class="col1">Kepada Yth</td>
                    <td class="col2">:</td>
                    <td class="col3"><strong>[[KEPADA]]</strong></td>
                </tr>
                <tr>
                    <td class="col1">Perihal</td>
                    <td class="col2">:</td>
                    <td class="col3"><strong>[[PERIHAL]]</strong></td>
                </tr>
            </table>
        </section>

        <div class="divider"></div>

        <section class="letter-body">
            <p>Dengan hormat,</p>
            <p>[[ISI_SURAT]]</p>
            <p>Demikian surat ini kami sampaikan. Atas perhatian dan kerjasamanya, kami ucapkan terima kasih.</p>
        </section>

        <div class="sign-block">
            <div class="sign">
                <div class="place-date">[[KOTA]], [[TANGGAL_SURAT]]</div>
                <img class="signature" src="[[PATH_TANDA_TANGAN]]" alt="Tanda Tangan">
                <div class="signature-info">
                    <div class="name">[[NAMA_PEJABAT]]</div>
                    <div class="title">[[JABATAN_PEJABAT]]</div>
                </div>
                <div class="paraf">[[PARAF]]</div>
            </div>
        </div>

        <footer class="footer">
            <div class="address">
                PT Jasamarga Pandaan Tol<br>
                Plaza Tol Pandaan<br>
                Pasuruan, Jawa Timur 67156<br>
                Telp: (0343) 5650727, 5650672, 5650729<br>
                Fax: (0343) 5650730<br>
                Email: jasamarga.pandaantol@gmail.com
            </div>
        </footer>

    </div>
</body>

</html>