<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$stmt = $conn->prepare("SELECT id, tipe FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$res  = $stmt->get_result();
$user = $res ? $res->fetch_assoc() : null;
$res?->free();
$stmt->close();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: record-letter.php?error=invalid_id');
    exit();
}

// Allow deletion if user is admin OR the creator of the letter (owner)
$stmt_owner = $conn->prepare("SELECT dibuat_oleh FROM office WHERE id = ?");
$stmt_owner->bind_param('i', $id);
$stmt_owner->execute();
$res_owner = $stmt_owner->get_result();
$row_owner = $res_owner ? $res_owner->fetch_assoc() : null;
$res_owner?->free();
$stmt_owner->close();

$allowed = false;
if ($user && strtolower(trim($user['tipe'])) === 'admin') {
    $allowed = true;
} elseif ($user && $row_owner && (int)$row_owner['dibuat_oleh'] === (int)$user['id']) {
    $allowed = true;
}

if (!$allowed) {
    header('Location: ../login.php');
    exit();
}
if ($id <= 0) {
    header('Location: record-letter.php?error=invalid_id');
    exit();
}

$sql = "SELECT file_surat, lampiran_path, signature_path, qr_code FROM office WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$surat = $res ? $res->fetch_assoc() : null;
$res?->free();
$stmt->close();

if (!$surat) {
    header('Location: record-letter.php?error=not_found');
    exit();
}

// Delete PDF file
if (!empty($surat['file_surat'])) {
    $filePath = __DIR__ . '/' . ltrim($surat['file_surat'], '/');
    if (is_file($filePath)) {
        @unlink($filePath);
    }
}

// Delete Signature file
if (!empty($surat['signature_path'])) {
    $sigPath = __DIR__ . '/' . ltrim($surat['signature_path'], '/');
    if (is_file($sigPath)) {
        @unlink($sigPath);
    }
}

// Delete QR Code file
if (!empty($surat['qr_code'])) {
    $qrPath = __DIR__ . '/' . ltrim($surat['qr_code'], '/');
    if (is_file($qrPath)) {
        @unlink($qrPath);
    }
}

if (!empty($surat['lampiran_path'])) {
    $paths = json_decode($surat['lampiran_path'], true);
    if (is_array($paths)) {
        foreach ($paths as $p) {
            $abs = __DIR__ . '/' . ltrim($p, '/');
            if (is_file($abs)) {
                @unlink($abs);
            }
        }
    }
}

// Delete approval chain entries for this letter
$del_chain = $conn->prepare("DELETE FROM urutan_paraf WHERE office_id = ?");
$del_chain->bind_param("i", $id);
$del_chain->execute();
$del_chain->close();

$del = $conn->prepare("DELETE FROM office WHERE id = ?");
$del->bind_param("i", $id);
$del->execute();
$del->close();

// Log deletion
error_log(sprintf('LETTER_DELETE: user_id=%s deleted office_id=%d', $user['id'] ?? 'unknown', $id));

header('Location: record-letter.php?deleted=1');
exit();
