<?php
$query = isset($_GET['q']) ? trim($_GET['q']) : '';
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
$baseUrl .= "://" . $_SERVER['HTTP_HOST'];



include(__DIR__ . '/includes/koneksi.php');

// Ambil data dari tabel logo untuk gambar dan link
$sql_logo = "SELECT gambar, link FROM logo LIMIT 1"; // Ambil data gambar dan link dari tabel logo
$result_logo = $conn->query($sql_logo);

// Default nilai untuk gambar dan link
$logo = "img/baru1/lg.png"; // Default gambar jika data kosong
$link = "index.php"; // Default link jika data kosong

if ($result_logo->num_rows > 0) {
    $row_logo = $result_logo->fetch_assoc();
    if (!empty($row_logo['gambar'])) {
        $logo = 'img/baru1/' . htmlspecialchars($row_logo['gambar']); // Path gambar dari database
    }
    if (!empty($row_logo['link'])) {
        $link = htmlspecialchars($row_logo['link']); // Link dari database
    }
}

// Ambil 3 data pertama dari tabel navbar
$sql_navbar = "SELECT ikon, judul_ikon, deskripsi_ikon FROM navbar LIMIT 3";
$result_navbar = $conn->query($sql_navbar);

$navbars = [];
if ($result_navbar->num_rows > 0) {
    while ($row = $result_navbar->fetch_assoc()) {
        $navbars[] = $row; // Simpan semua data navbar dalam array
    }
}

// Tentukan class untuk tiap kolom
$col_classes = ['col-4', 'col-3', 'col-5'];


// Ambil data dari tabel home
$sql_home = "SELECT * FROM home LIMIT 1"; // Ambil 1 baris data dari tabel home
$result_home = $conn->query($sql_home);

$home_data = [];
if ($result_home->num_rows > 0) {
    $home_data = $result_home->fetch_assoc(); // Ambil data baris pertama
}

// Pastikan path video menggunakan path relatif yang sesuai
$video_path = isset($home_data['video']) ? ltrim($home_data['video'], './') : 'default.mp4'; // Jika kosong, gunakan default

// Ambil data dari tabel bisnis
$sql_bisnis = "SELECT ikon_bisnis, judul_bisnis, deskripsi_bisnis FROM bisnis";
$result_bisnis = $conn->query($sql_bisnis);

$bisnis_data = [];
if ($result_bisnis->num_rows > 0) {
    while ($row = $result_bisnis->fetch_assoc()) {
        $bisnis_data[] = $row;
    }
}

// Ambil data dari tabel mitra
$sql_mitra = "SELECT gambar, link, judul FROM mitra";
$result_mitra = $conn->query($sql_mitra);

$mitra_data = [];
if ($result_mitra->num_rows > 0) {
    while ($row = $result_mitra->fetch_assoc()) {
        $mitra_data[] = $row;
    }
}

// Mengatur jumlah berita per halaman
$beritaPerHalaman = 3;
$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($currentPage - 1) * $beritaPerHalaman;

// Mengambil berita dari database dengan limit dan offset untuk pagination
function fetchBerita($conn, $offset, $limit)
{
    $sql = "SELECT id, judul, gambar, deskripsi, tanggal FROM berita ORDER BY created_at DESC LIMIT $offset, $limit";
    return $conn->query($sql);
}

$berita = fetchBerita($conn, $offset, $beritaPerHalaman);

// Menghitung jumlah total berita untuk pagination
function countBerita($conn)
{
    $sql = "SELECT COUNT(*) AS total FROM berita";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    return $row['total'];
}

$totalBerita = countBerita($conn);
$totalHalaman = ceil($totalBerita / $beritaPerHalaman);

// Ambil data footer
$sql_footer = "SELECT link_gambar, gambar, deskripsi_footer, keterangan_touch, copyright FROM footer LIMIT 1";
$result_footer = $conn->query($sql_footer);
$footer_data = $result_footer->fetch_assoc();

// Ambil semua data dari tabel ikon_footer
$sql_ikon_footer = "SELECT ikon, deskripsi_ikon FROM ikon_footer";
$result_ikon_footer = $conn->query($sql_ikon_footer);
$ikon_footer_data = [];
while ($row = $result_ikon_footer->fetch_assoc()) {
    $ikon_footer_data[] = $row;
}

// Ambil semua data dari tabel sosmed_footer
$sql_sosmed_footer = "SELECT link, ikon FROM sosmed_footer";
$result_sosmed_footer = $conn->query($sql_sosmed_footer);
$sosmed_footer_data = [];
while ($row = $result_sosmed_footer->fetch_assoc()) {
    $sosmed_footer_data[] = $row;
}

// Mulai sesi untuk melacak akun
session_start();

// Nama kunci sesi untuk pelacakan akun
$session_key_name = "account_visitor_tracking";

// Cek apakah halaman yang diakses adalah index.php
$current_page = basename($_SERVER['PHP_SELF']);
if ($current_page === "index.php") {
    // Periksa apakah akun baru sedang digunakan
    if (!isset($_SESSION[$session_key_name])) {
        // Ambil jumlah pengunjung saat ini dari database
        $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
        $result_counter = $conn->query($sql_counter);

        if ($result_counter->num_rows > 0) {
            $counter_data = $result_counter->fetch_assoc();
            $visitor_count = $counter_data['visit_count'];

            // Perbarui jumlah pengunjung di database
            $sql_update_counter = "UPDATE counter SET visit_count = visit_count + 1 WHERE id = 1";
            if ($conn->query($sql_update_counter) === TRUE) {
                $visitor_count += 1;

                // Tandai sesi untuk akun yang sedang digunakan
                $_SESSION[$session_key_name] = true;
            } else {
                echo "Error updating visitor count: " . $conn->error;
            }
        } else {
            // Jika tabel counter kosong, inisialisasi dengan 1
            $sql_init_counter = "INSERT INTO counter (visit_count) VALUES (1)";
            if ($conn->query($sql_init_counter) === TRUE) {
                $visitor_count = 1;

                // Tandai sesi untuk akun yang sedang digunakan
                $_SESSION[$session_key_name] = true;
            } else {
                echo "Error initializing visitor counter: " . $conn->error;
            }
        }
    } else {
        // Jika akun sudah ditandai dalam sesi, ambil jumlah pengunjung tanpa menambah
        $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
        $result_counter = $conn->query($sql_counter);
        if ($result_counter->num_rows > 0) {
            $counter_data = $result_counter->fetch_assoc();
            $visitor_count = $counter_data['visit_count'];
        } else {
            $visitor_count = 0;
        }
    }
} else {
    // Jika bukan index.php, ambil jumlah pengunjung tanpa menambah
    $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
    $result_counter = $conn->query($sql_counter);
    if ($result_counter->num_rows > 0) {
        $counter_data = $result_counter->fetch_assoc();
        $visitor_count = $counter_data['visit_count'];
    } else {
        $visitor_count = 0;
    }
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Hasil Pencarian: <?= htmlspecialchars($query) ?></title>
    <!-- Font Awesome -->
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free Website Template" name="keywords">
    <meta content="Free Website Template" name="description">

    <!-- Favicon -->
    <link href="img/baru/logojp.png" rel="icon">

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- CSS Libraries -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/flaticon/font/flaticon.css" rel="stylesheet">
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <!-- Algolia InstantSearch CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/instantsearch.css@8/themes/algolia-min.css" />

    <!-- Template Stylesheet -->
    <link href="css/style1.css" rel="stylesheet">
    <style>
        .chatbot-button {
            position: fixed;
            bottom: 15px;
            right: 75px;
            background: linear-gradient(45deg, #0d47a1, #1976d2);
            color: white;
            padding: 12px 25px;
            border-radius: 30px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            display: flex;
            align-items: center;
            font-size: 16px;
            z-index: 9999;
            transition: all 0.3s ease-in-out;
        }

        .chatbot-button:hover {
            background: linear-gradient(45deg, #1565c0, #2196f3);
            transform: scale(1.1);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.4);
        }

        .chat-icon {
            font-size: 20px;
            /* Ganti ukuran sesuai kebutuhan */
            margin-right: 10px;
            /* Atur jarak antara ikon dan teks */
        }


        /* Modal Chatbot */
        #chatbot-modal {
            position: fixed;
            bottom: 0;
            right: 20px;
            width: 400px;
            height: 600px;
            background: #ffffff;
            border: 1px solid #ddd;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
            border-radius: 10px 10px 0 0;
            display: none;
            z-index: 9999;
            flex-direction: column;
            overflow: hidden;
            animation: slideUp 0.4s ease;
        }

        .chatbot-header {
            background: #0078d7;
            color: white;
            padding: 15px;
            font-size: 18px;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-radius: 10px 10px 0 0;
        }

        .close-btn {
            background: none;
            border: none;
            color: white;
            font-size: 22px;
            cursor: pointer;
            transition: color 0.3s ease;
        }

        .close-btn:hover {
            color: #000000;
        }

        /* Animasi */
        @keyframes slideUp {
            from {
                transform: translateY(100%);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* Konten Modal */
        .chatbot-content {
            flex: 1;
            padding: 15px;
            overflow-y: auto;
            background-color: #f9f9f9;
        }

        .chatbot-footer {
            padding: 10px;
            border-top: 1px solid #ddd;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #f1f1f1;
        }

        .chatbot-footer input {
            flex: 1;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            margin-right: 10px;
        }

        .chatbot-footer button {
            background: linear-gradient(45deg, #0d47a1, #1976d2);
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .chatbot-footer button:hover {
            background: linear-gradient(45deg, #1565c0, #2196f3);
            transform: scale(1.05);
        }


        #visitor-counter p {
            margin: 0;
            font-size: 1.2em;
            /* Sesuaikan ukuran teks */
            font-weight: bold;
            /* Membuat teks tebal */
        }

        #visitor-counter strong {
            display: inline-block;
            background-color: rgb(255, 245, 245);
            /* Warna background angka */
            padding: 5px;
            font-size: 1.5em;
            /* Sesuaikan ukuran angka */
            border-radius: 3px;
            letter-spacing: 2px;
            /* Spasi antar huruf */
        }

        /* Pastikan navbar punya posisi relative agar search container absolute bisa tepat */
        .navbar {
            position: relative;
            overflow: visible;
            /* agar dropdown tidak terpotong */
            z-index: 1100;
            /* pastikan di bawah search-container */
        }

        /* Search container dropdown */
        #search-container {
            background: white;
            position: absolute;
            top: 70px;
            /* sesuaikan tinggi navbar */
            right: 20px;
            width: 250px;
            /* dikurangi lebarnya */
            padding: 8px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            z-index: 1200;
            /* lebih tinggi dari navbar */
            display: none;
        }

        /* Styling input search */
        #navbar-search-input {
            border: 1px solid #ccc;
            border-radius: 6px;
            padding: 10px 14px;
            /* dikurangi sedikit supaya seimbang */
            font-size: 16px;
            width: 100%;
            box-sizing: border-box;
            outline: none;
            transition: border-color 0.3s ease;
        }

        #navbar-search-input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        /* Tombol search di dalam form */
        #search-container button {
            padding: 10px 16px;
            /* disesuaikan dengan input */
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 0 6px 6px 0;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        #search-container button:hover {
            background-color: #0056b3;
        }

        /* Jika ada form dalam search-container */
        #search-container form {
            display: flex;
        }
    </style>
</head>

<body>

    <!-- Top Bar Start -->
    <div class="top-bar">
        <div class="container">
            <div class="row align-items-center">
                <!-- Bagian Logo -->
                <div class="col-lg-4 col-md-12">
                    <div class="logo">
                        <a href="<?= $link; ?>">
                            <img src="<?= $logo; ?>" alt="Logo" style="width: 200px;">
                        </a>
                    </div>
                </div>

                <!-- Tombol untuk membuka chatbot -->
                <div class="chatbot-button" onclick="toggleChatbot()">
                    <span class="chat-icon"><i class="fas fa-comment-dots"></i></span>
                    <span class="chat-text">Butuh Bantuan?</span>
                </div>

                <!-- Modal untuk chatbot -->
                <div id="chatbot-modal" style="display: none;">
                    <div class="chatbot-header">
                        PT Jasamarga Pandaan Tol
                        <button class="close-btn" onclick="toggleChatbot()">&times;</button>
                    </div>
                    <iframe id="chatbot-frame" src="" frameborder="0" style="width: 100%; height: 100%;"></iframe>
                </div>

                <!-- Bagian Navbar -->
                <div class="col-lg-8 col-md-7 d-none d-lg-block">
                    <div class="row">
                        <?php if (!empty($navbars)): ?>
                            <?php foreach ($navbars as $index => $navbar): ?>
                                <div class="<?= $col_classes[$index]; ?>">
                                    <div class="top-bar-item">
                                        <!-- Ikon langsung ditampilkan dari kolom `ikon` -->
                                        <div class="top-bar-icon">
                                            <?= $navbar['ikon']; ?> <!-- Menggunakan data HTML langsung -->
                                        </div>
                                        <!-- Judul dan Deskripsi -->
                                        <div class="top-bar-text">
                                            <h3><?= htmlspecialchars($navbar['judul_ikon']); ?></h3>
                                            <p><?= htmlspecialchars($navbar['deskripsi_ikon']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <p>Data tidak tersedia</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- Top Bar End -->
    <!-- Nav Bar Start -->
    <div class="nav-bar">
        <div class="container">
            <nav class="navbar navbar-expand-lg bg-dark navbar-dark">
                <a href="#" class="navbar-brand">MENU</a>
                <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                    <div class="navbar-nav mr-auto">
                        <?php
                        // Query untuk mengambil data header
                        $headers_query = "SELECT * FROM header ORDER BY created_at ASC";
                        $headers_result = $conn->query($headers_query);

                        if ($headers_result->num_rows > 0) {
                            while ($header = $headers_result->fetch_assoc()) {
                                $header_id = $header['id'];
                                $header_name = htmlspecialchars($header['nama_header']);
                                $header_link = htmlspecialchars($header['link'] ?? '#'); // Kolom link pada tabel header

                                // Query untuk mengambil data subheader terkait header ini
                                $subheaders_query = "SELECT * FROM subheader WHERE id_header = $header_id ORDER BY created_at ASC";
                                $subheaders_result = $conn->query($subheaders_query);

                                if ($subheaders_result->num_rows > 0) {
                                    // Jika ada subheader, tampilkan sebagai dropdown
                                    echo '<div class="nav-item dropdown">';
                                    echo '<a href="' . $header_link . '" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">' . $header_name . '</a>';
                                    echo '<div class="dropdown-menu">';
                                    while ($subheader = $subheaders_result->fetch_assoc()) {
                                        $subheader_name = htmlspecialchars($subheader['nama_subheader']);
                                        $subheader_link = htmlspecialchars($subheader['link'] ?? '#'); // Asumsikan ada kolom `link` pada tabel subheader
                                        echo '<a href="' . $subheader_link . '" class="dropdown-item">' . $subheader_name . '</a>';
                                    }
                                    echo '</div>';
                                    echo '</div>';
                                } else {
                                    // Jika tidak ada subheader, tampilkan sebagai link biasa
                                    echo '<a href="' . $header_link . '" class="nav-item nav-link">' . $header_name . '</a>';
                                }
                            }
                        } else {
                            echo '<a href="#" class="nav-item nav-link">Tidak ada data header</a>';
                        }
                        ?>
                    </div>
                    <!-- Tombol Search -->
                    <div class="top-bar-item text-right">
                        <button id="search-icon" class="btn btn-outline-light" title="Cari">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>

                    <!-- Search Container (Awalnya disembunyikan) -->
                    <div id="search-container" style="display:none;">
                        <form action="search-result.php" method="GET">
                            <input type="text" name="q" required>
                            <button type="submit">Cari</button>
                        </form>
                    </div>

                </div>
            </nav>
        </div>
    </div>
    <!-- Nav Bar End -->

    <div class="ml-1 mr-2">
        <h2 class="search-heading mt-4">
            Hasil Pencarian: <em><?= htmlspecialchars($query) ?></em>
        </h2>

        <div id="hits"></div>

        <!-- Algolia JS -->
        <script src="https://cdn.jsdelivr.net/npm/algoliasearch@4/dist/algoliasearch-lite.umd.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/instantsearch.js@4"></script>

        <script>
            const queryFromURL = <?php echo json_encode($query); ?>;

            if (!queryFromURL || queryFromURL.trim() === '') {
                document.getElementById('hits').innerHTML = '<div class="no-result">Silakan masukkan kata kunci untuk mencari data.</div>';
            } else {
                const searchClient = algoliasearch(
                    'KMALK22GMW', // App ID
                    '612ab2aace98b2a69d6674b80f7b0618' // Search-only key
                );

                const search = instantsearch({
                    indexName: 'web1',
                    searchClient,
                    searchFunction(helper) {
                        helper.setQuery(queryFromURL).search();
                    }
                });

                search.addWidgets([
                    instantsearch.widgets.configure({
                        hitsPerPage: 20
                    }),
                    instantsearch.widgets.hits({
                        container: '#hits',
                        templates: {
                            item(hit) {
                                let title = hit._highlightResult?.judul?.value || hit.judul || 'Tanpa Judul';
                                let desc = hit._highlightResult?.deskripsi?.value || (hit.deskripsi ? (hit.deskripsi.length > 100 ? hit.deskripsi.slice(0, 100) + '...' : hit.deskripsi) : '');

                                // Style highlight: biru background, hitam tebal
                                const highlightStyle = 'background:linear-gradient(90deg,#3B82F6,#2563EB);color:#000;font-weight:bold;padding:0 3px;border-radius:3px;font-style:normal;';
                                title = title.replace(/<em>/g, `<em style="${highlightStyle}">`);
                                desc = desc.replace(/<em>/g, `<em style="${highlightStyle}">`);

                                const category = hit.kategori || '';
                                const link = hit.link_url || '#';

                                return `
                        <a href="${link}" target="_blank" rel="noopener" class="hit-card">
                            <div class="hit-icon">
                                <i class="fa-solid fa-file-lines"></i>
                            </div>
                            <div class="hit-content">
                                <div class="hit-category">${category}</div>
                                <div class="hit-title">${title}</div>
                                <p class="hit-desc">${desc}</p>
                            </div>
                        </a>
                    `;
                            },
                            empty: '<div class="no-result">Tidak ditemukan hasil pencarian untuk kata kunci ini.</div>'
                        }
                    })
                ]);

                search.start();
            }
        </script>
    </div>
    <style>
        /* Heading */
        .search-heading {
            font-size: 1.4rem;
            color: #111827;
            margin-bottom: 20px;
        }

        /* Result Card */
        .hit-card {
            display: flex;
            align-items: flex-start;
            gap: 14px;
            padding: 18px;
            background: #f9fbff;
            /* Biru sangat lembut */
            border-radius: 16px;
            /* Sudut lebih lembut */
            box-shadow: 0 6px 20px rgba(8, 24, 40, 0.05);
            text-decoration: none;
            transition: transform 0.2s ease, box-shadow 0.2s ease, background 0.2s ease;
            margin-bottom: 16px;
            border: 1px solid #e2e8f0;
        }

        .search-heading em,
        .hit-card em {
            background: linear-gradient(90deg, #3B82F6, #2563EB);
            /* Biru gradasi */
            color: #000 !important;
            /* Hitam */
            font-weight: bold;
            padding: 0 3px;
            border-radius: 3px;
            font-style: normal;
        }

        .hit-card:hover {
            transform: translateY(-2px);
            background: #CADDFFFF;
            /* Biru sedikit lebih pekat saat hover */
            box-shadow: 0 8px 28px rgba(8, 24, 40, 0.08);
        }

        /* Icon */
        .hit-icon {
            font-size: 1.8rem;
            color: #ffffff;
            background: #0b5fff;
            /* Biru utama */
            padding: 12px;
            border-radius: 12px;
            flex-shrink: 0;
        }

        /* Content */
        .hit-content {
            flex: 1;
        }

        .hit-category {
            font-size: 0.85rem;
            font-weight: 600;
            color: #0b5fff;
            /* Biru kategori */
            margin-bottom: 4px;
        }

        .hit-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #111827;
            margin-bottom: 6px;
        }

        .hit-desc {
            font-size: 0.92rem;
            color: #555;
            margin: 0;
        }

        /* No Result */
        .no-result {
            padding: 14px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 6px 18px rgba(8, 24, 40, 0.04);
            text-align: center;
            color: #374151;
        }

        /* Highlighted text */
        /* Highlighted text (untuk heading dan hasil pencarian) */
        em {
            background: linear-gradient(90deg, #ffdd57, #ffb347);
            /* Kuning keoranyean */
            color: #000 !important;
            font-weight: bold;
            padding: 0 3px;
            border-radius: 3px;
            font-style: normal;
        }

        .search-heading em,
        .hit-card em {
            background: linear-gradient(90deg, #ffdd57, #ffb347);
            /* Kuning keoranyean */
            color: #000 !important;
            font-weight: bold;
            padding: 0 3px;
            border-radius: 3px;
            font-style: normal;
        }
    </style>



    <!-- Footer Start -->
    <div class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="footer-info">
                        <a href="<?= htmlspecialchars($footer_data['link_gambar']); ?>" class="logo d-flex align-items-center">
                            <span><img src="img/baru1/<?= htmlspecialchars($footer_data['gambar']); ?>" alt="logo"></span>
                        </a>
                        <p><?= htmlspecialchars($footer_data['deskripsi_footer']); ?></p>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6">
                    <div class="footer-contact">
                        <h2><?= htmlspecialchars($footer_data['keterangan_touch']); ?></h2>
                        <?php foreach ($ikon_footer_data as $ikon): ?>
                            <p><?= $ikon['ikon']; ?> <?= htmlspecialchars($ikon['deskripsi_ikon']); ?></p>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="footer-social">
                        <?php foreach ($sosmed_footer_data as $sosmed): ?>
                            <a class="btn" href="<?= htmlspecialchars($sosmed['link']); ?>">
                                <?= $sosmed['ikon']; ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="container copyright">
            <p> <a href="#"><?= htmlspecialchars($footer_data['copyright']); ?></a></p>

            <div id="visitor-counter">
                <p>Jumlah Pengunjung: <strong><?php echo $visitor_count; ?></strong></p>
            </div>
        </div>


    </div>
    <!-- Footer End -->

    <!-- Back to top button -->
    <a href="#" class="back-to-top"><i class="fa fa-chevron-up"></i></a>

    <!-- Pre Loader -->


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/counterup/counterup.min.js"></script>

    <!-- Contact Javascript File -->
    <script src="mail/jqBootstrapValidation.min.js"></script>
    <script src="mail/contact.js"></script>
    <script>
        // Toggle tampil/tidaknya kotak search
        document.getElementById('search-icon').addEventListener('click', () => {
            const container = document.getElementById('search-container');
            if (container.style.display === 'none' || container.style.display === '') {
                container.style.display = 'flex';
                document.getElementById('navbar-search-input').focus();
            } else {
                container.style.display = 'none';
            }
        });
    </script>

</body>

</html>