-- =====================================================
-- Reset Letter Sequences Migration
-- Run Date: 2025-12-17
-- Purpose: Reset all letter sequence counters to 0
--          to fix incorrect initial values that were
--          migrated from old office.id based system
-- =====================================================

-- Reset all sequences to 0
UPDATE letter_sequences SET last_number = 0, updated_at = NOW();

-- Verify the reset
SELECT 
    ls.id,
    ls.tipe_surat_id,
    ls.last_number,
    ts.kode,
    ts.nama,
    ls.updated_at
FROM letter_sequences ls 
JOIN tipe_surat ts ON ls.tipe_surat_id = ts.id
ORDER BY ls.tipe_surat_id;

-- Note: Existing letters in office table will keep their old sequence_number
-- values for historical reference, but new letters will start from 1
-- for each tipe_surat.
