<?php
include(__DIR__ . '/includes/koneksi.php');

// Cek apakah parameter id tersedia
if (!isset($_GET['id'])) {
    echo "ID tidak ditemukan di URL.";
    exit();
}

$id = intval($_GET['id']);

// Query data berdasarkan ID
$sql = "SELECT * FROM data_tarif_harian WHERE id = $id";
$result = $conn->query($sql);

// Cek apakah data ditemukan
if ($result->num_rows === 0) {
    echo "Data dengan ID $id tidak ditemukan.";
    exit();
}

$row = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html>

<head>
    <title>Detail Data Tarif Harian</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #eef2f3, #8e9eab);
            padding: 30px;
        }

        .container {
            max-width: 600px;
            margin: auto;
            background: #fff;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
        }

        table {
            width: 100%;
        }

        td {
            padding: 8px 0;
        }

        .label {
            font-weight: bold;
            width: 40%;
        }

        .back-button {
            display: block;
            text-align: center;
            margin-top: 20px;
            text-decoration: none;
            background-color: #007bff;
            color: #fff;
            padding: 8px 16px;
            border-radius: 5px;
        }

        .back-button:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>

    <div class="container">
        <h2>Detail Tarif ID <?= $row['id'] ?></h2>
        <table>
            <tr>
                <td class="label">Tanggal</td>
                <td>: <?= $row['tanggal'] ?></td>
            </tr>
            <tr>
                <td class="label">Waktu</td>
                <td>: <?= $row['waktu'] ?></td>
            </tr>
            <tr>
                <td class="label">Gerbang Tol</td>
                <td>: <?= $row['gerbang_tol'] ?></td>
            </tr>
            <tr>
                <td class="label">Arah</td>
                <td>: <?= $row['arah'] ?></td>
            </tr>
            <tr>
                <td class="label">Jenis Kendaraan</td>
                <td>: <?= $row['jenis_kendaraan'] ?></td>
            </tr>
            <tr>
                <td class="label">Kecepatan (km/jam)</td>
                <td>: <?= $row['kecepatan_km_jam'] ?></td>
            </tr>
            <tr>
                <td class="label">Cuaca</td>
                <td>: <?= $row['cuaca'] ?></td>
            </tr>
            <tr>
                <td class="label">Status</td>
                <td>: <?= $row['status'] ?></td>
            </tr>
            <tr>
                <td class="label">Dibuat</td>
                <td>: <?= $row['created_at'] ?></td>
            </tr>
        </table>

        <a href="tarif.php" class="back-button">Kembali</a>
    </div>

</body>

</html>