-- Add columns for QR code validation to office table
-- Run this SQL in your phpMyAdmin or MySQL console

ALTER TABLE `office` 
ADD COLUMN `is_validated` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Validation status: 0=not validated, 1=validated',
ADD COLUMN `qr_code` VARCHAR(255) NULL COMMENT 'Path to QR code image file',
ADD COLUMN `validation_token` VARCHAR(255) NULL COMMENT 'Unique token for validation verification',
ADD COLUMN `validated_at` TIMESTAMP NULL COMMENT 'Timestamp when letter was validated',
ADD INDEX `idx_validation_token` (`validation_token`),
ADD INDEX `idx_is_validated` (`is_validated`);

-- Update existing records to have validation_token if needed (optional)
-- UPDATE `office` SET `validation_token` = MD5(CONCAT(id, nomor_surat, NOW())) WHERE `validation_token` IS NULL;
