-- Check and fix dari_tipe column in office table for cPanel deployment
-- Run this on your cPanel phpMyAdmin to ensure the column structure is correct

-- First, check current structure
SHOW COLUMNS FROM office WHERE Field = 'dari_tipe';

-- If the column doesn't match the expected ENUM, update it
-- This will ensure the column accepts only 'internal' and 'eksternal'
ALTER TABLE office MODIFY COLUMN dari_tipe ENUM('internal','eksternal') NOT NULL;

-- Verify the change
SHOW COLUMNS FROM office WHERE Field = 'dari_tipe';

-- Check for any invalid data that might cause issues
SELECT id, dari_tipe, COUNT(*) as count 
FROM office 
GROUP BY dari_tipe
ORDER BY dari_tipe;

-- If you find any invalid data, you can fix it like this:
-- UPDATE office SET dari_tipe = 'internal' WHERE dari_tipe NOT IN ('internal', 'eksternal');