-- Migration to add sequence_number field to office table
-- This allows decoupling letter numbers from database auto-increment ID

-- Add sequence_number column
ALTER TABLE office ADD COLUMN sequence_number INT NULL AFTER nomor_surat;

-- Update existing records to set sequence_number = id (for backward compatibility)
UPDATE office SET sequence_number = id WHERE sequence_number IS NULL;

-- Add index for performance
ALTER TABLE office ADD INDEX idx_sequence_number (sequence_number);

-- Optional: Add unique constraint to prevent duplicate sequence numbers
-- (You may want to enable this after ensuring no conflicts)
ALTER TABLE office ADD UNIQUE INDEX unique_sequence_number (sequence_number);

-- Show the updated table structure
DESCRIBE office;