-- Migration: create letter_order table
-- Run this in your database before seeding

CREATE TABLE IF NOT EXISTS `letter_order` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT(11) NOT NULL,
  `supervisor_id` INT(11) DEFAULT NULL,
  `created_by` INT(11) DEFAULT NULL,
  `updated_by` INT(11) DEFAULT NULL,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `uq_letter_order_user` (`user_id`),
  KEY `idx_letter_order_user` (`user_id`),
  KEY `idx_letter_order_supervisor` (`supervisor_id`),
  CONSTRAINT `fk_letter_order_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_letter_order_supervisor` FOREIGN KEY (`supervisor_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
