-- Add letter_catatan table for storing notes on letters
-- Only supervisors/approvers with higher positions can add notes

CREATE TABLE IF NOT EXISTS letter_catatan (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    office_id BIGINT(20) UNSIGNED NOT NULL,
    user_id INT(11) NOT NULL,
    catatan TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (office_id) REFERENCES office(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_user_per_letter (office_id, user_id),
    INDEX idx_office (office_id),
    INDEX idx_user (user_id),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
