-- =====================================================
-- FOREIGN KEY ADDITION ONLY - SIMPLIFIED MIGRATION
-- =====================================================

-- Disable foreign key checks temporarily
SET FOREIGN_KEY_CHECKS = 0;

-- Clean up any existing foreign keys first
ALTER TABLE jenis_surat DROP FOREIGN KEY IF EXISTS fk_jenis_klasifikasi;
ALTER TABLE subjenis_surat DROP FOREIGN KEY IF EXISTS fk_subjenis_jenis;
ALTER TABLE subjenis_surat DROP FOREIGN KEY IF EXISTS fk_subjenis_klasifikasi;
ALTER TABLE office DROP FOREIGN KEY IF EXISTS fk_office_tipe_surat;
ALTER TABLE office DROP FOREIGN KEY IF EXISTS fk_office_subjenis;

-- Add foreign keys one by one with proper error checking
-- 1. Add foreign key jenis_surat -> klasifikasi_arsip
ALTER TABLE `jenis_surat` 
ADD CONSTRAINT `fk_jenis_klasifikasi` 
FOREIGN KEY (`id_klasifikasi`) REFERENCES `klasifikasi_arsip` (`id`) 
ON UPDATE CASCADE ON DELETE SET NULL;

-- 2. Add foreign key subjenis_surat -> jenis_surat
ALTER TABLE `subjenis_surat` 
ADD CONSTRAINT `fk_subjenis_jenis` 
FOREIGN KEY (`id_jenis`) REFERENCES `jenis_surat` (`id`) 
ON UPDATE CASCADE ON DELETE CASCADE;

-- 3. Add foreign key subjenis_surat -> klasifikasi_arsip
ALTER TABLE `subjenis_surat` 
ADD CONSTRAINT `fk_subjenis_klasifikasi` 
FOREIGN KEY (`id_klasifikasi`) REFERENCES `klasifikasi_arsip` (`id`) 
ON UPDATE CASCADE ON DELETE CASCADE;

-- 4. Add foreign key office -> tipe_surat
ALTER TABLE `office` 
ADD CONSTRAINT `fk_office_tipe_surat` 
FOREIGN KEY (`tipe_surat_id`) REFERENCES `tipe_surat` (`id`) 
ON UPDATE CASCADE ON DELETE SET NULL;

-- 5. Add foreign key office -> subjenis_surat
ALTER TABLE `office` 
ADD CONSTRAINT `fk_office_subjenis` 
FOREIGN KEY (`subjenis_surat_id`) REFERENCES `subjenis_surat` (`id`) 
ON UPDATE CASCADE ON DELETE SET NULL;

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS = 1;

-- Verification
SELECT 'Foreign keys added successfully!' as status;

-- Show all foreign keys
SELECT 
  TABLE_NAME,
  CONSTRAINT_NAME,
  COLUMN_NAME,
  REFERENCED_TABLE_NAME,
  REFERENCED_COLUMN_NAME
FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE CONSTRAINT_SCHEMA = DATABASE() 
AND REFERENCED_TABLE_NAME IS NOT NULL
ORDER BY TABLE_NAME;