< !--Simple Rich Text Editor Alternative(No API Key Required)-- >
    <script>
// Simple toolbar for basic text editing
        function makeTextBold() {
            document.execCommand('bold', false, null);
}

        function makeTextItalic() {
            document.execCommand('italic', false, null);
}

        function makeTextUnderline() {
            document.execCommand('underline', false, null);
}

        function insertBulletList() {
            document.execCommand('insertUnorderedList', false, null);
}

        function insertNumberList() {
            document.execCommand('insertOrderedList', false, null);
}

        function alignLeft() {
            document.execCommand('justifyLeft', false, null);
}

        function alignCenter() {
            document.execCommand('justifyCenter', false, null);
}

        function alignRight() {
            document.execCommand('justifyRight', false, null);
}

        function insertLink() {
    const url = prompt('Enter URL:');
        if (url) {
            document.execCommand('createLink', false, url);
    }
}

        function changeFontSize() {
    const size = prompt('Enter font size (1-7):');
        if (size) {
            document.execCommand('fontSize', false, size);
    }
}

        // Simple WYSIWYG implementation
        function initSimpleEditor(elementId) {
    const element = document.getElementById(elementId);
        if (element) {
            element.contentEditable = true;
        element.style.border = '1px solid #ccc';
        element.style.minHeight = '400px';
        element.style.padding = '10px';
        element.style.fontSize = '14px';
        element.style.fontFamily = 'Arial, sans-serif';
        element.style.lineHeight = '1.5';

        // Add toolbar
        const toolbar = document.createElement('div');
        toolbar.style.marginBottom = '10px';
        toolbar.style.padding = '5px';
        toolbar.style.border = '1px solid #ccc';
        toolbar.style.backgroundColor = '#f5f5f5';

        toolbar.innerHTML = `
        <button type="button" onclick="makeTextBold()" title="Bold"><b>B</b></button>
        <button type="button" onclick="makeTextItalic()" title="Italic"><i>I</i></button>
        <button type="button" onclick="makeTextUnderline()" title="Underline"><u>U</u></button>
        <button type="button" onclick="insertBulletList()" title="Bullet List">• List</button>
        <button type="button" onclick="insertNumberList()" title="Number List">1. List</button>
        <button type="button" onclick="alignLeft()" title="Align Left">◄</button>
        <button type="button" onclick="alignCenter()" title="Align Center">■</button>
        <button type="button" onclick="alignRight()" title="Align Right">►</button>
        <button type="button" onclick="insertLink()" title="Insert Link">Link</button>
        <button type="button" onclick="changeFontSize()" title="Font Size">Size</button>
        `;

        // Style toolbar buttons
        const buttons = toolbar.querySelectorAll('button');
        buttons.forEach(btn => {
            btn.style.margin = '2px';
        btn.style.padding = '5px 8px';
        btn.style.border = '1px solid #999';
        btn.style.backgroundColor = 'white';
        btn.style.cursor = 'pointer';
        btn.style.borderRadius = '3px';
        });

        element.parentNode.insertBefore(toolbar, element);

        return {
            getContent: function() {
                return element.innerHTML;
            },
        setContent: function(content) {
            element.innerHTML = content;
            }
        };
    }
        return null;
}
    </script>