(function ($) {
    "use strict";
    
    // loader
    var loader = function () {
        setTimeout(function () {
            if ($('#loader').length > 0) {
                $('#loader').removeClass('show');
            }
        }, 1);
    };
    loader();
    
    // Back to top button
    $(window).scroll(function () {
        if ($(this).scrollTop() > 200) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });
    $('.back-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
        return false;
    });
    
    
    // Sticky Navbar
    $(window).scroll(function () {
        if ($(this).scrollTop() > 90) {
            $('.nav-bar').addClass('nav-sticky');
            $('.carousel, .page-header').css("margin-top", "73px");
        } else {
            $('.nav-bar').removeClass('nav-sticky');
            $('.carousel, .page-header').css("margin-top", "0");
        }
    });
    
    
    // Dropdown on mouse hover
    $(document).ready(function () {
        function toggleNavbarMethod() {
            if ($(window).width() > 992) {
                $('.navbar .dropdown').on('mouseover', function () {
                    $('.dropdown-toggle', this).trigger('click');
                }).on('mouseout', function () {
                    $('.dropdown-toggle', this).trigger('click').blur();
                });
            } else {
                $('.navbar .dropdown').off('mouseover').off('mouseout');
            }
        }
        toggleNavbarMethod();
        $(window).resize(toggleNavbarMethod);
    });

    
    // Main carousel
    $(".carousel .owl-carousel").owlCarousel({
        autoplay: true,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        items: 1,
        smartSpeed: 300,
        dots: false,
        loop: true,
        nav : true,
        navText : [
            '<i class="fa fa-angle-left" aria-hidden="true"></i>',
            '<i class="fa fa-angle-right" aria-hidden="true"></i>'
        ]
    });

    
    // Facts counter
    $('[data-toggle="counter-up"]').counterUp({
        delay: 10,
        time: 2000
    });


    // Testimonials carousel
    $(".testimonials-carousel").owlCarousel({
        center: true,
        autoplay: true,
        smartSpeed: 2000,
        dots: true,
        loop: true,
        responsive: {
            0:{
                items:1
            },
            576:{
                items:1
            },
            768:{
                items:2
            },
            992:{
                items:3
            }
        }
    });
    
    
    // Related post carousel
    $(".related-slider").owlCarousel({
        autoplay: true,
        dots: false,
        loop: true,
        nav : true,
        navText : [
            '<i class="fa fa-angle-left" aria-hidden="true"></i>',
            '<i class="fa fa-angle-right" aria-hidden="true"></i>'
        ],
        responsive: {
            0:{
                items:1
            },
            576:{
                items:1
            },
            768:{
                items:2
            }
        }
    });
    
})(jQuery);
 // Data untuk carousel
 const slides = [
    { year: "2017", description: "Deskripsi untuk tahun 2017", image: "img/baru/" },
    { year: "2018", description: "Deskripsi untuk tahun 2018", image: "https://via.placeholder.com/150" },
    { year: "2019", description: "Deskripsi untuk tahun 2019", image: "https://via.placeholder.com/150" },
    { year: "2020", description: "Penandatangan addendum II Kontrak Manajemen, PT JTT fokus terhadap proses spin-off ruas-ruas Transjawa", image: "https://via.placeholder.com/150" },
    { year: "2021", description: "Deskripsi untuk tahun 2021", image: "https://via.placeholder.com/150" },
    { year: "2022", description: "Deskripsi untuk tahun 2022", image: "https://via.placeholder.com/150" },
];

let currentIndex = 3; // Mulai dari tahun 2020

// Fungsi untuk menampilkan slide berdasarkan index
function showSlide(index) {
    document.getElementById("carousel-year").innerText = slides[index].year;
    document.getElementById("carousel-description").innerText = slides[index].description;
    document.getElementById("carousel-image").src = slides[index].image;

    // Update timeline aktif
    const timeline = document.getElementById("timeline").children;
    for (let i = 0; i < timeline.length; i++) {
        timeline[i].classList.remove("active");
    }
    timeline[index].classList.add("active");
}

// Fungsi tombol berikutnya
function nextSlide() {
    currentIndex = (currentIndex + 1) % slides.length;
    showSlide(currentIndex);
}

// Fungsi tombol sebelumnya
function prevSlide() {
    currentIndex = (currentIndex - 1 + slides.length) % slides.length;
    showSlide(currentIndex);
}

// Tampilkan slide awal
showSlide(currentIndex);
//  Mengatur interaksi untuk menampilkan dan menutup modal
function showModal(profile) {
    document.getElementById(`modal-${profile}`).style.display = 'flex';
}

function closeModal(profile) {
    document.getElementById(`modal-${profile}`).style.display = 'none';
}
