<?php
include(__DIR__ . '/includes/koneksi.php');







// Ambil data dari tabel logo untuk gambar dan link
$sql_logo = "SELECT gambar, link FROM logo LIMIT 1"; // Ambil data gambar dan link dari tabel logo
$result_logo = $conn->query($sql_logo);

// Default nilai untuk gambar dan link
$logo = "img/baru1/lg.png"; // Default gambar jika data kosong
$link = "index.php"; // Default link jika data kosong

if ($result_logo->num_rows > 0) {
    $row_logo = $result_logo->fetch_assoc();
    if (!empty($row_logo['gambar'])) {
        $logo = 'img/baru1/' . htmlspecialchars($row_logo['gambar']); // Path gambar dari database
    }
    if (!empty($row_logo['link'])) {
        $link = htmlspecialchars($row_logo['link']); // Link dari database
    }
}




// Ambil 3 data pertama dari tabel navbar
$sql_navbar = "SELECT ikon, judul_ikon, deskripsi_ikon FROM navbar LIMIT 3";
$result_navbar = $conn->query($sql_navbar);

$navbars = [];
if ($result_navbar->num_rows > 0) {
    while ($row = $result_navbar->fetch_assoc()) {
        $navbars[] = $row; // Simpan semua data navbar dalam array
    }
}

// Tentukan class untuk tiap kolom
$col_classes = ['col-4', 'col-3', 'col-5'];


// Ambil data dari tabel home
$sql_home = "SELECT * FROM home LIMIT 1"; // Ambil 1 baris data dari tabel home
$result_home = $conn->query($sql_home);

$home_data = [];
if ($result_home->num_rows > 0) {
    $home_data = $result_home->fetch_assoc(); // Ambil data baris pertama
}

// Pastikan path video menggunakan path relatif yang sesuai
$video_path = isset($home_data['video']) ? ltrim($home_data['video'], './') : 'default.mp4'; // Jika kosong, gunakan default

// Ambil data dari tabel bisnis
$sql_bisnis = "SELECT ikon_bisnis, judul_bisnis, deskripsi_bisnis FROM bisnis";
$result_bisnis = $conn->query($sql_bisnis);

$bisnis_data = [];
if ($result_bisnis->num_rows > 0) {
    while ($row = $result_bisnis->fetch_assoc()) {
        $bisnis_data[] = $row;
    }
}

// Ambil data dari tabel mitra
$sql_mitra = "SELECT gambar, link, judul FROM mitra";
$result_mitra = $conn->query($sql_mitra);

$mitra_data = [];
if ($result_mitra->num_rows > 0) {
    while ($row = $result_mitra->fetch_assoc()) {
        $mitra_data[] = $row;
    }
}

// Mengatur jumlah berita per halaman
$beritaPerHalaman = 3;
$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($currentPage - 1) * $beritaPerHalaman;

// Mengambil berita dari database dengan limit dan offset untuk pagination
function fetchBerita($conn, $offset, $limit)
{
    $sql = "SELECT id, judul, gambar, deskripsi, tanggal FROM berita ORDER BY created_at DESC LIMIT $offset, $limit";
    return $conn->query($sql);
}

$berita = fetchBerita($conn, $offset, $beritaPerHalaman);

// Menghitung jumlah total berita untuk pagination
function countBerita($conn)
{
    $sql = "SELECT COUNT(*) AS total FROM berita";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    return $row['total'];
}

$totalBerita = countBerita($conn);
$totalHalaman = ceil($totalBerita / $beritaPerHalaman);




// Ambil data footer
$sql_footer = "SELECT link_gambar, gambar, deskripsi_footer, keterangan_touch, copyright FROM footer LIMIT 1";
$result_footer = $conn->query($sql_footer);
$footer_data = $result_footer->fetch_assoc();

// Ambil semua data dari tabel ikon_footer
$sql_ikon_footer = "SELECT ikon, deskripsi_ikon FROM ikon_footer";
$result_ikon_footer = $conn->query($sql_ikon_footer);
$ikon_footer_data = [];
while ($row = $result_ikon_footer->fetch_assoc()) {
    $ikon_footer_data[] = $row;
}

// Ambil semua data dari tabel sosmed_footer
$sql_sosmed_footer = "SELECT link, ikon FROM sosmed_footer";
$result_sosmed_footer = $conn->query($sql_sosmed_footer);
$sosmed_footer_data = [];
while ($row = $result_sosmed_footer->fetch_assoc()) {
    $sosmed_footer_data[] = $row;
}





// Mulai sesi untuk melacak akun
session_start();

// Nama kunci sesi untuk pelacakan akun
$session_key_name = "account_visitor_tracking";

// Cek apakah halaman yang diakses adalah index.php
$current_page = basename($_SERVER['PHP_SELF']);
if ($current_page === "index.php") {
    // Periksa apakah akun baru sedang digunakan
    if (!isset($_SESSION[$session_key_name])) {
        // Ambil jumlah pengunjung saat ini dari database
        $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
        $result_counter = $conn->query($sql_counter);

        if ($result_counter->num_rows > 0) {
            $counter_data = $result_counter->fetch_assoc();
            $visitor_count = $counter_data['visit_count'];

            // Perbarui jumlah pengunjung di database
            $sql_update_counter = "UPDATE counter SET visit_count = visit_count + 1 WHERE id = 1";
            if ($conn->query($sql_update_counter) === TRUE) {
                $visitor_count += 1;

                // Tandai sesi untuk akun yang sedang digunakan
                $_SESSION[$session_key_name] = true;
            } else {
                echo "Error updating visitor count: " . $conn->error;
            }
        } else {
            // Jika tabel counter kosong, inisialisasi dengan 1
            $sql_init_counter = "INSERT INTO counter (visit_count) VALUES (1)";
            if ($conn->query($sql_init_counter) === TRUE) {
                $visitor_count = 1;

                // Tandai sesi untuk akun yang sedang digunakan
                $_SESSION[$session_key_name] = true;
            } else {
                echo "Error initializing visitor counter: " . $conn->error;
            }
        }
    } else {
        // Jika akun sudah ditandai dalam sesi, ambil jumlah pengunjung tanpa menambah
        $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
        $result_counter = $conn->query($sql_counter);
        if ($result_counter->num_rows > 0) {
            $counter_data = $result_counter->fetch_assoc();
            $visitor_count = $counter_data['visit_count'];
        } else {
            $visitor_count = 0;
        }
    }
} else {
    // Jika bukan index.php, ambil jumlah pengunjung tanpa menambah
    $sql_counter = "SELECT visit_count FROM counter WHERE id = 1";
    $result_counter = $conn->query($sql_counter);
    if ($result_counter->num_rows > 0) {
        $counter_data = $result_counter->fetch_assoc();
        $visitor_count = $counter_data['visit_count'];
    } else {
        $visitor_count = 0;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>PT Jasamarga Pandaan Tol</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free Website Template" name="keywords">
    <meta content="Free Website Template" name="description">

    <!-- Favicon -->
    <link href="img/baru/logojp.png" rel="icon">

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- CSS Libraries -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/flaticon/font/flaticon.css" rel="stylesheet">
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <!-- Template Stylesheet -->

    <link href="css/style1.css" rel="stylesheet">
    <style>
        .chatbot-button {
            position: fixed;
            bottom: 15px;
            right: 75px;
            background: linear-gradient(45deg, #0d47a1, #1976d2);
            color: white;
            padding: 12px 25px;
            border-radius: 30px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            display: flex;
            align-items: center;
            font-size: 16px;
            z-index: 9999;
            transition: all 0.3s ease-in-out;
        }

        .chatbot-button:hover {
            background: linear-gradient(45deg, #1565c0, #2196f3);
            transform: scale(1.1);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.4);
        }

        .chat-icon {
            font-size: 20px;
            /* Ganti ukuran sesuai kebutuhan */
            margin-right: 10px;
            /* Atur jarak antara ikon dan teks */
        }


        /* Modal Chatbot */
        #chatbot-modal {
            position: fixed;
            bottom: 0;
            right: 20px;
            width: 400px;
            height: 600px;
            background: #ffffff;
            border: 1px solid #ddd;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
            border-radius: 10px 10px 0 0;
            display: none;
            z-index: 9999;
            flex-direction: column;
            overflow: hidden;
            animation: slideUp 0.4s ease;
        }

        .chatbot-header {
            background: #0078d7;
            color: white;
            padding: 15px;
            font-size: 18px;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-radius: 10px 10px 0 0;
        }

        .close-btn {
            background: none;
            border: none;
            color: white;
            font-size: 22px;
            cursor: pointer;
            transition: color 0.3s ease;
        }

        .close-btn:hover {
            color: #000000;
        }

        /* Animasi */
        @keyframes slideUp {
            from {
                transform: translateY(100%);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* Konten Modal */
        .chatbot-content {
            flex: 1;
            padding: 15px;
            overflow-y: auto;
            background-color: #f9f9f9;
        }

        .chatbot-footer {
            padding: 10px;
            border-top: 1px solid #ddd;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #f1f1f1;
        }

        .chatbot-footer input {
            flex: 1;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            margin-right: 10px;
        }

        .chatbot-footer button {
            background: linear-gradient(45deg, #0d47a1, #1976d2);
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .chatbot-footer button:hover {
            background: linear-gradient(45deg, #1565c0, #2196f3);
            transform: scale(1.05);
        }



        #visitor-counter p {
            margin: 0;
            font-size: 1.2em;
            /* Sesuaikan ukuran teks */
            font-weight: bold;
            /* Membuat teks tebal */
        }

        #visitor-counter strong {
            display: inline-block;
            background-color: rgb(255, 245, 245);
            /* Warna background angka */
            padding: 5px;
            font-size: 1.5em;
            /* Sesuaikan ukuran angka */
            border-radius: 3px;
            letter-spacing: 2px;
            /* Spasi antar huruf */
        }

        .scroll-wrapper {
            position: relative;
            overflow: hidden;
            width: 100%;
            max-width: 100%;
        }

        .scroll-inner {
            position: relative;
            width: 100%;
            overflow: hidden;
            /* ubah dari auto ke hidden */
        }

        .scroll-images {
            display: flex;
            scroll-behavior: smooth;
            gap: 10px;
            width: 100%;
            box-sizing: border-box;
            padding-bottom: 5px;
            overflow-x: hidden;
            /* Nonaktifkan scroll manual horizontal */
        }

        .scroll-img {
            flex: 0 0 100%;
            width: 100%;
            height: auto;
            aspect-ratio: 4/3;
            /* atau 16/9 jika ingin rasio video */
            object-fit: cover;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
            transition: transform 0.3s ease;
        }

        .scroll-img:hover {
            transform: scale(1.02);
        }

        .scroll-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: #001eff;
            /* Biru utama */
            color: #ffc107;
            /* Kuning ikon panah */
            border: none;
            padding: 8px 10px;
            cursor: pointer;
            font-size: 14px;
            z-index: 10;
            border-radius: 20%;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .scroll-btn:hover {
            background-color: #0029ff;
            /* Biru sedikit lebih terang saat hover */
            transform: translateY(-50%) scale(1.1);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.3);
        }

        .scroll-btn.left {
            left: 10px;
        }

        .scroll-btn.right {
            right: 10px;
        }

        body {
            overflow-x: hidden;
        }
    </style>
</head>

<body>

    <!-- Top Bar Start -->
    <div class="top-bar">
        <div class="container">
            <div class="row align-items-center">
                <!-- Bagian Logo -->
                <div class="col-lg-4 col-md-12">
                    <div class="logo">
                        <a href="<?= $link; ?>">
                            <img src="<?= $logo; ?>" alt="Logo" style="width: 200px;">
                        </a>
                    </div>
                </div>

                <!-- Tombol untuk membuka chatbot -->
                <div class="chatbot-button" onclick="toggleChatbot()">
                    <span class="chat-icon"><i class="fas fa-comment-dots"></i></span>
                    <span class="chat-text">Butuh Bantuan?</span>
                </div>

                <!-- Modal untuk chatbot -->
                <div id="chatbot-modal" style="display: none;">
                    <div class="chatbot-header">
                        PT Jasamarga Pandaan Tol
                        <button class="close-btn" onclick="toggleChatbot()">&times;</button>
                    </div>
                    <iframe id="chatbot-frame" src="" frameborder="0" style="width: 100%; height: 100%;"></iframe>
                </div>

                <!-- Bagian Navbar -->
                <div class="col-lg-8 col-md-7 d-none d-lg-block">
                    <div class="row">
                        <?php if (!empty($navbars)): ?>
                            <?php foreach ($navbars as $index => $navbar): ?>
                                <div class="<?= $col_classes[$index]; ?>">
                                    <div class="top-bar-item">
                                        <!-- Ikon langsung ditampilkan dari kolom `ikon` -->
                                        <div class="top-bar-icon">
                                            <?= $navbar['ikon']; ?> <!-- Menggunakan data HTML langsung -->
                                        </div>
                                        <!-- Judul dan Deskripsi -->
                                        <div class="top-bar-text">
                                            <h3><?= htmlspecialchars($navbar['judul_ikon']); ?></h3>
                                            <p><?= htmlspecialchars($navbar['deskripsi_ikon']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <p>Data tidak tersedia</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Top Bar End -->
    <!-- Nav Bar Start -->
    <div class="nav-bar">
        <div class="container">
            <nav class="navbar navbar-expand-lg bg-dark navbar-dark">
                <a href="#" class="navbar-brand">MENU</a>
                <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                    <div class="navbar-nav mr-auto">
                        <?php
                        // Query untuk mengambil data header
                        $headers_query = "SELECT * FROM header ORDER BY created_at ASC";
                        $headers_result = $conn->query($headers_query);

                        if ($headers_result->num_rows > 0) {
                            while ($header = $headers_result->fetch_assoc()) {
                                $header_id = $header['id'];
                                $header_name = htmlspecialchars($header['nama_header']);
                                $header_link = htmlspecialchars($header['link'] ?? '#'); // Kolom link pada tabel header

                                // Query untuk mengambil data subheader terkait header ini
                                $subheaders_query = "SELECT * FROM subheader WHERE id_header = $header_id ORDER BY created_at ASC";
                                $subheaders_result = $conn->query($subheaders_query);

                                if ($subheaders_result->num_rows > 0) {
                                    // Jika ada subheader, tampilkan sebagai dropdown
                                    echo '<div class="nav-item dropdown">';
                                    echo '<a href="' . $header_link . '" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">' . $header_name . '</a>';
                                    echo '<div class="dropdown-menu">';
                                    while ($subheader = $subheaders_result->fetch_assoc()) {
                                        $subheader_name = htmlspecialchars($subheader['nama_subheader']);
                                        $subheader_link = htmlspecialchars($subheader['link'] ?? '#'); // Asumsikan ada kolom `link` pada tabel subheader
                                        echo '<a href="' . $subheader_link . '" class="dropdown-item">' . $subheader_name . '</a>';
                                    }
                                    echo '</div>';
                                    echo '</div>';
                                } else {
                                    // Jika tidak ada subheader, tampilkan sebagai link biasa
                                    echo '<a href="' . $header_link . '" class="nav-item nav-link">' . $header_name . '</a>';
                                }
                            }
                        } else {
                            echo '<a href="#" class="nav-item nav-link">Tidak ada data header</a>';
                        }
                        ?>
                    </div>

                    <!-- 🔍 Tombol / Input Search Algolia -->
                    <div class="col">
                        <div class="top-bar-item text-right">
                            <button id="search-icon" class="btn btn-outline-light" title="Cari">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Container untuk search box -->
                    <div id="search-container" style="display:none; position: absolute; top: 60px; right: 20px; width: 300px; background: white; z-index: 1050; padding: 10px; border-radius: 5px; box-shadow: 0 2px 8px rgba(0,0,0,0.2);">
                        <input type="text" id="search-input" class="form-control" placeholder="Cari sesuatu...">
                    </div>
                </div>
            </nav>
        </div>
    </div>
    <!-- Nav Bar End -->

    <section class="hero">
        <video class="hero-video" autoplay muted loop>
            <source src="<?= htmlspecialchars($video_path); ?>" type="video/mp4">
            <!-- Fallback jika video tidak bisa diputar -->
            Browser Anda tidak mendukung video.
        </video>
        <div class="hero-content">
            <h1><?= htmlspecialchars($home_data['judul_video']); ?></h1>
            <a href="<?= htmlspecialchars($home_data['link_tentang']); ?>" class="btn"><?= htmlspecialchars($home_data['judul_tentang']); ?></a>
        </div>
    </section>

    <!-- Hero Section Start -->
    <div class="hero-section">
        <div class="hero-left">
            <h1><?= htmlspecialchars($home_data['tentang']); ?></h1>
        </div>
        <div class="hero-right">
            <p><?= htmlspecialchars($home_data['deskripsi_tentang']); ?></p>
        </div>
    </div>
    <!-- Hero Section End -->
    <!-- ======= Featured Services Section ======= -->
    <section id="featured-services" class="featured-services">
        <div class="container">
            <div class="section-header text-center">
                <h2><?= htmlspecialchars($home_data['bisnis']); ?></h2>
            </div>
            <!-- Bagian Bisnis -->
            <div class="row gy-4">
                <?php foreach ($bisnis_data as $bisnis): ?>
                    <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up">
                        <div class="icon flex-shrink-0">
                            <!-- Langsung tampilkan HTML dari database -->
                            <?= $bisnis['ikon_bisnis']; ?>
                        </div>
                        <div>
                            <h4 class="title"><?= htmlspecialchars($bisnis['judul_bisnis']); ?></h4>
                            <p class="description"><?= htmlspecialchars($bisnis['deskripsi_bisnis']); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
    </section><!-- End Featured Services Section -->

    <!-- Blog Start -->
    <div class="blog">
        <div class="container">
            <div class="section-header text-center">
                <h2><?= htmlspecialchars($home_data['berita_terbaru']); ?></h2>
            </div>
            <div class="row" id="blog-container">
                <?php while ($row = $berita->fetch_assoc()) { ?>
                    <div class="col-lg-4">
                        <div class="blog-item">
                            <div class="blog-img scroll-wrapper" style="width: 100%;">
                                <div class="scroll-inner" style="width: 100%;">
                                    <div class="scroll-images" id="scroll-<?php echo $row['id']; ?>">
                                        <?php
                                        $gambarList = explode(",", $row['gambar']);
                                        foreach ($gambarList as $gambar) {
                                            echo '<img src="img/baru1/' . trim($gambar) . '" class="scroll-img" alt="Image">';
                                        }
                                        ?>
                                    </div>
                                    <?php if (count($gambarList) > 1): ?>
                                        <button class="scroll-btn left" id="left-btn-<?php echo $row['id']; ?>" onclick="scrollImages('scroll-<?php echo $row['id']; ?>', -1)">&#10094;</button>
                                        <button class="scroll-btn right" id="right-btn-<?php echo $row['id']; ?>" onclick="scrollImages('scroll-<?php echo $row['id']; ?>', 1)">&#10095;</button>
                                    <?php endif; ?>

                                </div>
                                <div class="meta-date">
                                    <?php
                                    $tanggal = strtotime($row['tanggal']);
                                    echo "<span>" . date('d', $tanggal) . "</span>";
                                    echo "<strong>" . date('M', $tanggal) . "</strong>";
                                    echo "<span>" . date('Y', $tanggal) . "</span>";
                                    ?>
                                </div>
                            </div>


                            <div class="blog-text">
                                <h3>
                                    <a href="beritalain.php?id=<?php echo $row['id']; ?>">
                                        <?php echo $row['judul']; ?>
                                    </a>
                                </h3>
                                <p>
                                    <?php
                                    // Membatasi deskripsi hingga 200 karakter
                                    $deskripsi = $row['deskripsi'];
                                    if (strlen($deskripsi) > 200) {
                                        $deskripsi = substr($deskripsi, 0, 200) . '...';
                                    }
                                    echo $deskripsi;
                                    ?>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <div class="d-flex justify-content-center">
                <a href="blog.php" class="btn-lihat-selengkapnya">Lihat Selengkapnya</a>
            </div>
        </div>
    </div>
    <!-- Blog End -->
    <!-- Testimonial Start -->
    <div class="testimonial">
        <div class="container">
            <div class="section-header text-center">
                <h2><?= htmlspecialchars($home_data['judul_mitra']); ?></h2>
            </div>
            <!-- Bagian Mitra -->
            <div class="owl-carousel testimonials-carousel">
                <?php foreach ($mitra_data as $mitra): ?>
                    <div class="testimonial-item">
                        <img src="img/baru1/<?= htmlspecialchars($mitra['gambar']); ?>" alt="Image">
                        <div class="testimonial-text">
                            <?php if (!empty($mitra['link'])): ?>
                                <h3>
                                    <a href="<?= htmlspecialchars($mitra['link']); ?>" class="stretched-link"><?= htmlspecialchars($mitra['judul']); ?></a>
                                </h3>
                            <?php else: ?>
                                <h3><?= htmlspecialchars($mitra['judul']); ?></h3>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- Testimonial End -->

    <!-- Footer Start -->
    <div class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="footer-info">
                        <a href="<?= htmlspecialchars($footer_data['link_gambar']); ?>" class="logo d-flex align-items-center">
                            <span><img src="img/baru1/<?= htmlspecialchars($footer_data['gambar']); ?>" alt="logo"></span>
                        </a>
                        <p><?= htmlspecialchars($footer_data['deskripsi_footer']); ?></p>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6">
                    <div class="footer-contact">
                        <h2><?= htmlspecialchars($footer_data['keterangan_touch']); ?></h2>
                        <?php foreach ($ikon_footer_data as $ikon): ?>
                            <p><?= $ikon['ikon']; ?> <?= htmlspecialchars($ikon['deskripsi_ikon']); ?></p>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="footer-social">
                        <?php foreach ($sosmed_footer_data as $sosmed): ?>
                            <a class="btn" href="<?= htmlspecialchars($sosmed['link']); ?>">
                                <?= $sosmed['ikon']; ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="container copyright">
            <p> <a href="https://mifta.vercel.app">&copy; 2024 - <span id="currentYear"></span> <?= htmlspecialchars($footer_data['copyright']); ?></a></p>

            <div id="visitor-counter">
                <small>
                    <p>Jumlah Pengunjung: <?php echo $visitor_count; ?></p>
                </small>
            </div>
        </div>


    </div>
    <!-- Footer End -->

    <!-- Back to top button -->
    <a href="#" class="back-to-top"><i class="fa fa-chevron-up"></i></a>

    <!-- Pre Loader -->
    <div id="loader" class="show">
        <div class="loader"></div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/counterup/counterup.min.js"></script>

    <!-- Contact Javascript File -->
    <script src="mail/jqBootstrapValidation.min.js"></script>
    <script src="mail/contact.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
    <script>
        // Set tahun berdasarkan zona waktu Indonesia Barat (WIB)
        const options = {
            timeZone: 'Asia/Jakarta',
            year: 'numeric'
        };
        const currentYear = new Intl.DateTimeFormat('id-ID', options).format(new Date());
        document.getElementById("currentYear").textContent = currentYear;
    </script>
    <script>
        // Toggle show/hide search box
        document.getElementById('search-icon').addEventListener('click', () => {
            const container = document.getElementById('search-container');
            if (container.style.display === 'none' || container.style.display === '') {
                container.style.display = 'block';
                document.getElementById('search-input').focus();
            } else {
                container.style.display = 'none';
            }
        });

        // Enter => Redirect ke cari.php
        document.getElementById('search-input').addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                const query = this.value.trim();
                if (query !== '') {
                    window.location.href = 'cari.php?query=' + encodeURIComponent(query);
                }
            }
        });
    </script>
    <script>
        function scrollImages(id, direction) {
            const container = document.getElementById(id);
            const images = container.querySelectorAll('.scroll-img');
            const containerWidth = container.offsetWidth;

            let currentIndex = Math.round(container.scrollLeft / containerWidth);
            currentIndex += direction;

            if (currentIndex < 0) currentIndex = 0;
            if (currentIndex >= images.length) currentIndex = images.length - 1;

            container.scrollTo({
                left: containerWidth * currentIndex,
                behavior: 'smooth'
            });

            setTimeout(() => updateButtons(id, images.length), 300); // Delay to wait until scroll completes
        }

        function updateButtons(id, totalImages) {
            const container = document.getElementById(id);
            const scrollLeft = container.scrollLeft;
            const containerWidth = container.offsetWidth;
            const currentIndex = Math.round(scrollLeft / containerWidth);

            const leftBtn = document.getElementById(`left-btn-${id.split('-')[1]}`);
            const rightBtn = document.getElementById(`right-btn-${id.split('-')[1]}`);

            if (leftBtn && rightBtn) {
                leftBtn.style.display = currentIndex === 0 ? 'none' : 'block';
                rightBtn.style.display = currentIndex === totalImages - 1 ? 'none' : 'block';
            }
        }

        // Inisialisasi setelah halaman dimuat
        window.addEventListener('DOMContentLoaded', () => {
            const scrollGroups = document.querySelectorAll('.scroll-images');
            scrollGroups.forEach(group => {
                const id = group.id;
                const totalImages = group.querySelectorAll('.scroll-img').length;

                updateButtons(id, totalImages);

                // Jika user scroll manual (jaga-jaga walau kita hidden scroll)
                group.addEventListener('scroll', () => {
                    updateButtons(id, totalImages);
                });
            });
        });
    </script>


    <script>
        // Fungsi untuk toggle modal chatbot
        function toggleChatbot() {
            const modal = document.getElementById('chatbot-modal');
            const iframe = document.getElementById('chatbot-frame');

            if (modal.style.display === 'none' || modal.style.display === '') {
                modal.style.display = 'flex'; // Tampilkan modal
                iframe.src = 'chatbot0.php'; // Muat file chatbot. ke dalam iframe
            } else {
                modal.style.display = 'none'; // Sembunyikan modal
                iframe.src = ''; // Hapus sumber iframe untuk menghemat memori
            }
        }
    </script>


</body>

</html>