<?php
// Sidebar include for user pages. Expects variables: $access_modul, $name, $user_id, $jumlahAgendaAktif
// Will compute $isApprover and $isSupervisor if not already set.
if (!isset($access_modul)) $access_modul = [];
if (!isset($user_id) && isset($user['id'])) $user_id = $user['id'];
if (!isset($jumlahAgendaAktif)) $jumlahAgendaAktif = 0;
if (!isset($jumlahApproveTodo)) $jumlahApproveTodo = 0;
include_once __DIR__ . '/functions.php';
if (!isset($isSupervisor) || !isset($isApprover)) {
    $subordinateIds = getSubordinatesForUser($conn, $user_id);
    $isSupervisor = !empty($subordinateIds);
    $isApprover = isApprover($conn, $user_id);
}
?>
<div class="sidebar">
    <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
    <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>

    <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
        <i class="fas fa-envelope-open-text"></i> Surat
        <i class="fas fa-caret-down arrow-icon ml-1" id="letterArrow"></i>
    </a>
    <div id="letterSubmenu" class="collapse submenu">
        <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
        <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
    </div>

    <?php if (!empty($access_modul['agenda']) && $access_modul['agenda'] === 'on'): ?>
        <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
            <i class="fas fa-calendar-check"></i> Agenda Kerja
            <?php if ($jumlahAgendaAktif > 0): ?><span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span><?php endif; ?>
            <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
        </a>
        <div id="agendaSubmenu" class="collapse submenu">
            <a href="list-agenda.php">
                <i class="fas fa-clock"></i> List
                <?php if ($jumlahAgendaAktif > 0): ?><span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span><?php endif; ?>
            </a>
            <a href="record-agenda.php"><i class="fas fa-clipboard-list"></i> Record</a>
        </div>
    <?php endif; ?>

    <?php if (!empty($access_modul['berita']) && $access_modul['berita'] === 'on'): ?>
        <a href="berita.php"><i class="fas fa-newspaper"></i> Berita</a>
    <?php endif; ?>

    <?php if (!empty($access_modul['gerbang']) && $access_modul['gerbang'] === 'on'): ?>
        <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang</a>
    <?php endif; ?>

    <?php if (!empty($access_modul['sosial']) && $access_modul['sosial'] === 'on'): ?>
        <a href="sosial.php"><i class="fas fa-file"></i> Tanggung Jawab</a>
    <?php endif; ?>

    <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
</div>