<?php
// Alternative TinyMCE initialization function for create-letter.php
// Use this if the jsDelivr CDN version doesn't work
?>

<script>
    // Alternative to TinyMCE - Simple HTML Editor
    function initSimpleEditor() {
        return new Promise((resolve) => {
            const editorContainer = document.getElementById('editorNaskah');

            if (!editorContainer) {
                console.error('Editor container not found');
                resolve();
                return;
            }

            // Make it contentEditable
            editorContainer.contentEditable = true;
            editorContainer.style.border = '1px solid #ccc';
            editorContainer.style.minHeight = '780px';
            editorContainer.style.padding = '15px';
            editorContainer.style.fontSize = '14px';
            editorContainer.style.fontFamily = 'Arial, sans-serif';
            editorContainer.style.lineHeight = '1.6';
            editorContainer.style.backgroundColor = 'white';

            // Add toolbar
            const toolbar = document.createElement('div');
            toolbar.style.marginBottom = '10px';
            toolbar.style.padding = '10px';
            toolbar.style.border = '1px solid #ccc';
            toolbar.style.backgroundColor = '#f8f9fa';
            toolbar.style.borderRadius = '5px';

            toolbar.innerHTML = `
            <div class="btn-group" role="group" style="display: inline-block;">
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('bold')" title="Bold">
                    <strong>B</strong>
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('italic')" title="Italic">
                    <em>I</em>
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('underline')" title="Underline">
                    <u>U</u>
                </button>
            </div>
            
            <div class="btn-group" role="group" style="display: inline-block; margin-left: 10px;">
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('justifyLeft')" title="Align Left">
                    ⬅
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('justifyCenter')" title="Center">
                    ⬛
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('justifyRight')" title="Align Right">
                    ➡
                </button>
            </div>
            
            <div class="btn-group" role="group" style="display: inline-block; margin-left: 10px;">
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('insertUnorderedList')" title="Bullet List">
                    • List
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.execCommand('insertOrderedList')" title="Number List">
                    1. List
                </button>
            </div>
        `;

            editorContainer.parentNode.insertBefore(toolbar, editorContainer);

            // Create a global editor object that mimics TinyMCE API
            window.simpleEditor = {
                getContent: function() {
                    return editorContainer.innerHTML;
                },
                setContent: function(content) {
                    editorContainer.innerHTML = content;
                },
                insertContent: function(content) {
                    editorContainer.innerHTML += content;
                }
            };

            // Mark as ready
            editorReady = true;
            resolve();
        });
    }

    // Alternative functions that work with simple editor
    function getEditorContent() {
        if (window.simpleEditor) {
            return window.simpleEditor.getContent();
        }
        // Fallback to TinyMCE if available
        if (window.tinymce && tinymce.get('editorNaskah')) {
            return tinymce.get('editorNaskah').getContent();
        }
        return document.getElementById('editorNaskah').innerHTML || '';
    }

    function setEditorContent(content) {
        if (window.simpleEditor) {
            window.simpleEditor.setContent(content);
            return;
        }
        // Fallback to TinyMCE if available
        if (window.tinymce && tinymce.get('editorNaskah')) {
            tinymce.get('editorNaskah').setContent(content);
            return;
        }
        document.getElementById('editorNaskah').innerHTML = content;
    }

    // Update the original functions to use the alternative editor
    function initTinyMCE() {
        if (editorReady && (window.simpleEditor || (window.tinymce && tinymce.get('editorNaskah')))) {
            return Promise.resolve();
        }

        // Try TinyMCE first, fallback to simple editor
        if (window.tinymce) {
            return new Promise((resolve) => {
                tinymce.init({
                    selector: '#editorNaskah',
                    height: 780,
                    menubar: true,
                    plugins: [
                        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
                        'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
                        'insertdatetime', 'media', 'table', 'help', 'wordcount'
                    ],
                    toolbar: 'undo redo | blocks | bold italic backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',
                    images_upload_url: '/jasa_marga/api/upload/image.php',
                    automatic_uploads: true,
                    images_upload_handler: function(blobInfo, success, failure) {
                        const formData = new FormData();
                        formData.append('file', blobInfo.blob(), blobInfo.filename());

                        fetch('/jasa_marga/api/upload/image.php', {
                                method: 'POST',
                                body: formData
                            })
                            .then(response => response.json())
                            .then(result => {
                                if (result.location) {
                                    success(result.location);
                                } else {
                                    failure('Upload failed: ' + (result.error || 'Unknown error'));
                                }
                            })
                            .catch(error => {
                                failure('Upload failed: ' + error.message);
                            });
                    },
                    setup: function(editor) {
                        editor.on('init', function() {
                            editorReady = true;
                            resolve();
                        });
                    }
                });
            });
        } else {
            // Fallback to simple editor
            console.warn('TinyMCE not available, using simple editor');
            return initSimpleEditor();
        }
    }
</script>