<?php
session_start();
include('../koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$id = intval($_GET['id']);
$sql = "SELECT * FROM gratifikasi WHERE id = $id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    echo "Data tidak ditemukan.";
    exit();
}

$data = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $judul_satu = $_POST['judul_satu'];
    $sub_judul_satu = $_POST['sub_judul_satu'];
    $konsultasi = $_POST['konsultasi'];
    $isi_konsultasi_satu = $_POST['isi_konsultasi_satu'];
    $email = $_POST['email'];
    $isi_konsultasi_dua = $_POST['isi_konsultasi_dua'];
    $judul_dua = $_POST['judul_dua'];
    $sub_judul_dua = $_POST['sub_judul_dua'];
    $deskripsi = $_POST['deskripsi'];
    $pelaporan = $_POST['pelaporan'];
    $dokumen = $_POST['dokumen'];
    $deskripsi_dokumen = $_POST['deskripsi_dokumen'];

    // Gambar lama tetap jika tidak diupload ulang
    $gambar = $data['gambar'];
    if (!empty($_FILES['gambar']['name'])) {
        $gambar = $_FILES['gambar']['name'];
        $target = "../img/baru1/" . basename($gambar);
        if (!move_uploaded_file($_FILES['gambar']['tmp_name'], $target)) {
            echo "Gagal mengupload gambar.";
            exit();
        }
    }

    $sql = "UPDATE gratifikasi SET 
                judul_satu = '$judul_satu',
                sub_judul_satu = '$sub_judul_satu',
                konsultasi = '$konsultasi',
                isi_konsultasi_satu = '$isi_konsultasi_satu',
                email = '$email',
                isi_konsultasi_dua = '$isi_konsultasi_dua',
                gambar = '$gambar',
                judul_dua = '$judul_dua',
                sub_judul_dua = '$sub_judul_dua',
                deskripsi = '$deskripsi',
                pelaporan = '$pelaporan',
                dokumen = '$dokumen',
                deskripsi_dokumen = '$deskripsi_dokumen',
                created_at = NOW()
            WHERE id = $id";

    if ($conn->query($sql)) {
        header('Location: ../gratifi.php');
        exit();
    } else {
        echo "Error: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Gratifikasi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Favicon -->
    <link href="../img/baru/logojp.png" rel="icon">

</head>

<body class="bg-light">
    <div class="container mt-5">
        <div class="card">
            <div class="card-header bg-warning text-dark">Edit Data Gratifikasi</div>
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">

                    <div class="mb-3">
                        <label class="form-label">Judul Satu:</label>
                        <input class="form-control" type="text" name="judul_satu" value="<?= htmlspecialchars($data['judul_satu']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Sub Judul Satu:</label>
                        <input class="form-control" type="text" name="sub_judul_satu" value="<?= htmlspecialchars($data['sub_judul_satu']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Konsultasi:</label>
                        <input class="form-control" type="text" name="konsultasi" value="<?= htmlspecialchars($data['konsultasi']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Isi Konsultasi Satu:</label>
                        <textarea class="form-control" name="isi_konsultasi_satu" required><?= htmlspecialchars($data['isi_konsultasi_satu']); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email:</label>
                        <input class="form-control" type="email" name="email" value="<?= htmlspecialchars($data['email']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Isi Konsultasi Dua:</label>
                        <textarea class="form-control" name="isi_konsultasi_dua" required><?= htmlspecialchars($data['isi_konsultasi_dua']); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Gambar:</label>
                        <input class="form-control" type="file" name="gambar">
                        <small>Gambar saat ini: <?= htmlspecialchars($data['gambar']); ?></small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Judul Dua:</label>
                        <input class="form-control" type="text" name="judul_dua" value="<?= htmlspecialchars($data['judul_dua']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Sub Judul Dua:</label>
                        <input class="form-control" type="text" name="sub_judul_dua" value="<?= htmlspecialchars($data['sub_judul_dua']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Deskripsi:</label>
                        <textarea class="form-control" name="deskripsi" required><?= htmlspecialchars($data['deskripsi']); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Pelaporan:</label>
                        <textarea class="form-control" name="pelaporan" required><?= htmlspecialchars($data['pelaporan']); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Dokumen:</label>
                        <textarea class="form-control" name="dokumen" required><?= htmlspecialchars($data['dokumen']); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Deskripsi Dokumen:</label>
                        <textarea class="form-control" name="deskripsi_dokumen" required><?= htmlspecialchars($data['deskripsi_dokumen']); ?></textarea>
                    </div>

                    <a href="../gratifi.php" class="btn btn-secondary">Kembali</a>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </form>
            </div>
        </div>
    </div>
</body>

</html>