# Implementasi Dual Letter Numbering System - Setup Guide

## 🎯 Overview
Sistem ini mengimplementasikan klasifikasi surat bertingkat (Klasifikasi → Jenis → Subjenis) dengan 3 tipe surat berbeda, sambil mempertahankan kompatibilitas dengan sistem lama.
## 📋 Prerequisites
- PHP 8.0+
- MariaDB/MySQL 5.7+
- Apache dengan mod_rewrite
- Extension PHP: mysqli, json, mbstring

## 🗂️ Files Created/Modified

### New Files:
1. `database_migration_dual_system.sql` - Database schema changes
2. `import_classification_data.php` - Master data parser dan inserter
3. `api_classification.php` - API endpoints untuk dropdown dinamis

### Modified Files:
1. `create-letter.php` - Form dinamis dengan conditional fields
2. `edit-letter.php` (akan diupdate next)
3. `record-letter.php` (akan diupdate next)

## 🚀 Installation Steps

### Step 1: Database Migration
```bash
# 1. Backup database terlebih dahulu
mysqldump -u [username] -p jasa_marga > backup_before_migration.sql

# 2. Run migration script
mysql -u [username] -p jasa_marga < database_migration_dual_system.sql
```

### Step 2: Import Master Data
```bash
# Run dari terminal (atau akses via browser)
cd c:\xampp\htdocs\jasa_marga
php import_classification_data.php
```

### Step 3: Verify Installation
Buka browser dan test:
- `http://localhost:81/jasa_marga/api_classification.php?action=get_tipe_surat`
- `http://localhost:81/jasa_marga/api_classification.php?action=get_klasifikasi`
- `http://localhost:81/jasa_marga/create-letter.php`

## 🔧 Configuration Options

### Database Tables Structure

#### New Tables:
- `tipe_surat` - 3 tipe surat (SK, KPTS, SE)
- `subjenis_surat` - Hierarchical subjenis dengan relasi
- `letter_sequences` - Auto-created untuk sequence numbering

#### Modified Tables:
- `office` - Added dual system columns
- `klasifikasi_arsip` - Added kode & deskripsi
- `jenis_surat` - Added kode, deskripsi, id_klasifikasi

### Form Behavior

#### Surat Keluar (SK):
- **Visible**: Tipe Surat + Klasifikasi + Jenis + Subjenis
- **Hidden**: Legacy fields
- **Numbering**: `[Jabatan]-[Klasifikasi]-[Klasifikasi][Jenis][Subjenis][Sequence]`
- **Example**: `DIR-HM-HM040023`

#### Surat Keputusan Direksi (KPTS):
- **Visible**: Tipe Surat only
- **Hidden**: All classification fields
- **Numbering**: `[Sequence]/KPTS-JPT/[Year]`
- **Example**: `134/KPTS-JPT/2025`

#### Surat Edaran Direksi (SE):
- **Visible**: Tipe Surat only  
- **Hidden**: All classification fields
- **Numbering**: `[Sequence]/SE-DIR/[Year]`
- **Example**: `010/SE-DIR/2025`

## 📊 Data Statistics

Berdasarkan file klasifikasi:
- **20 Klasifikasi** (PR, IN, PP, PG, OM, KU, PN, TI, CD, HC, HK, KR, KA, PL, OT, DL, HM, MR, MM, PW)
- **100+ Jenis Surat** (varies per klasifikasi)
- **200+ Subjenis Surat** (varies per jenis)

## 🔍 Testing Checklist

### Functionality Tests:
- [ ] Tipe Surat dropdown loads correctly
- [ ] Klasifikasi dropdown shows for Surat Keluar only
- [ ] Jenis dropdown cascades from Klasifikasi
- [ ] Subjenis dropdown cascades from Jenis
- [ ] Nomor surat generates correctly for each tipe
- [ ] Form validation works for required fields
- [ ] Legacy system still accessible (jika diperlukan)

### Data Integrity Tests:
- [ ] All klasifikasi imported with correct kode
- [ ] Jenis surat linked to correct klasifikasi
- [ ] Subjenis surat linked to correct jenis & klasifikasi
- [ ] Foreign keys working properly
- [ ] Sequences increment correctly

## 🐛 Troubleshooting

### Common Issues:

#### 1. "Tipe surat dropdown kosong"
```sql
-- Check if data imported
SELECT COUNT(*) FROM tipe_surat;
SELECT * FROM tipe_surat;
```

#### 2. "Classification API error"
- Check `api_classification.php` accessible via browser
- Verify database connection in `koneksi.php`
- Check PHP error logs

#### 3. "Nomor surat tidak generate"
```sql
-- Check letter_sequences table
SELECT * FROM letter_sequences;
-- Manual insert if needed
INSERT INTO letter_sequences (letter_type, year, last_sequence) VALUES ('surat_keluar', 2025, 0);
```

#### 4. "Foreign key errors"
```sql
-- Disable foreign key checks temporarily
SET FOREIGN_KEY_CHECKS=0;
-- Re-enable after fixing
SET FOREIGN_KEY_CHECKS=1;
```

## 🔐 Security Notes

### Input Validation:
- All dropdown values validated against database
- SQL injection prevention via prepared statements
- XSS protection via htmlspecialchars
- CSRF protection recommended (future enhancement)

### Database Security:
- Use least-privilege database user
- Regular backup schedule
- Monitor for unauthorized schema changes

## 📈 Performance Optimization

### Indexing:
- All foreign key columns indexed
- Code-based lookups optimized
- Composite indexes for frequent queries

### Caching (Optional):
- Consider Redis for classification data
- Browser caching for static dropdowns
- Database query optimization

## 🔄 Migration Strategy

### Phase 1: Dual System (Current)
- New system runs parallel to old
- Users can choose which to use
- Data integrity maintained

### Phase 2: Gradual Migration (Future)
- Migrate existing letters one by one
- Use `is_migrated_to_new_system` flag
- Provide migration tools for users

### Phase 3: Full Migration (Future)
- Deprecate old system
- Remove legacy columns
- Clean up unused tables

## 📞 Support & Maintenance

### Regular Tasks:
- Monitor sequence numbers
- Backup classification data
- Update master data as needed
- Performance monitoring

### Rollback Plan:
Use provided rollback script in `database_migration_dual_system.sql` if needed.

## 📚 API Documentation

### Endpoints:
- `GET api_classification.php?action=get_tipe_surat`
- `GET api_classification.php?action=get_klasifikasi`  
- `GET api_classification.php?action=get_jenis_by_klasifikasi&klasifikasi_id=1`
- `GET api_classification.php?action=get_subjenis_by_jenis&jenis_id=1`
- `GET api_classification.php?action=generate_nomor_surat&tipe_surat_id=1&...`

### Response Format:
```json
{
  "success": true,
  "data": [...],
  "message": "Success message"
}
```

## ✅ Next Steps

1. Test the current implementation
2. Run database migration
3. Import classification data
4. Update `edit-letter.php` dengan logic serupa
5. Update `record-letter.php` untuk dual display
6. Add user training documentation
7. Plan gradual data migration

---

**Created by**: Development Team  
**Date**: November 2025  
**Version**: 1.0