Letter Order Feature - Setup and Seed

This README covers creating the new `letter_order` table and seeding it with the pre-configured list.

1. Create the table
- Run the SQL migration:

```sql
-- In MySQL CLI or phpMyAdmin
SOURCE add_letter_order_table.sql;
```

2. Seed rows (SQL)
- Basic seed uses exact name matches for `users.nama`:

```sql
SOURCE seed_letter_order.sql;
```

The SQL seed will only insert when `users.nama` is an exact match to the supplied names. If some names don't match, no row will be inserted for the user.

3. Seed rows (robust PHP fallback)
- If `seed_letter_order.sql` doesn't find all names, use the PHP helper to try LIKE matches and fuzzier matching.
- Usage:

```bash
php seed_letter_order.php
```

This script will attempt exact matches first, then try a `LIKE` fallback. It logs any missing names that weren't found.

4. Notes on exact name matching
- If `users.nama` in the database has a slightly different format (middle initials, difference in spacing, typos), the SQL will not insert. The PHP helper is provided to help match those.

5. Next steps
- After seeding, implement admin UI pages to manage the `letter_order` rows: `letter-order.php`, `add-letter-order.php`, `edit-letter-order.php`, `delete-letter-order.php`.
- Deletion should perform a hard delete of the `letter_order` row and also delete `office` rows (letters) created by the `user_id`, including removing files from disk.

9. New Admin UI pages
- `letter-order.php`: List and preview chain (read-only initially).
- `add-letter-order.php`: Add a mapping for pre-configured users. Only pre-configured users are shown for 'Nama User'.
- `edit-letter-order.php`: Edit `Nama Atasan` (supervisor) for a `user_id`.
- `delete-letter-order.php`: Deletes the `letter_order` row and cascades to delete `office` rows and associated files for the `user_id`.

6. Security and validation
- Only admin users are allowed to use these pages. Use existing patterns for permission checks (query session username -> check `users.tipe == 'admin'`).
- Add cycle detection to avoid creating approval loops.

9. Report exact matches of the 16 configured names
- To ensure all 16 names exist exactly in `users.nama`, run:

```
php report_letter_order_mismatches.php
```

The script will list each target name, show whether an exact match exists, list any `letter_order` mapping for the user, and provide LIKE/levenshtein suggestions if no exact match is found.

This helpful diagnostic ensures seed results will be correct before building the UI.

7. Computing `urutan` (chain)
- `urutan` is computed server-side by following `supervisor_id` chain until `supervisor_id` is NULL or a maximum depth (recommended 10) or a cycle is detected.

8. Support
- If you want me to implement the UI and delete/cascade logic next, confirm and I will proceed to code the pages and helper functions.
