# Steps to Complete Letter Number Editing Feature

## Step 1: Run SQL Migration

Execute the SQL commands in `add_sequence_number_migration.sql` to add the sequence_number column to your database:

```bash
# Connect to your MySQL database
mysql -u your_username -p your_database_name < add_sequence_number_migration.sql
```

Or run the SQL commands manually in your MySQL client:

```sql
-- Add sequence_number column
ALTER TABLE office ADD COLUMN sequence_number INT NULL AFTER nomor_surat;

-- Update existing records to set sequence_number = id (for backward compatibility)
UPDATE office SET sequence_number = id WHERE sequence_number IS NULL;

-- Add index for performance
ALTER TABLE office ADD INDEX idx_sequence_number (sequence_number);
```

## Step 2: Test the Feature

1. **Edit an existing letter** - Go to edit-letter.php for any existing letter
2. **Change the sequence number** - Look for the "Letter ID (Sequence Number)" field
3. **Click "Regenerate"** - This will update the nomor_surat with the new sequence number
4. **Save the letter** - The letter will be saved with the new number

## How It Works

### For Different Letter Types:

- **Surat Keluar (SK)**: `DKU.JPT.PG.04.03.90` → You can change `90`
- **Surat Keputusan (KPTS)**: `092/KPTS-JPT/2025` → You can change `92` 
- **Surat Edaran (SE)**: `091/SE-DIR/2025` → You can change `91`

### Features Added:

1. **New Database Column**: `sequence_number` to store the editable ID separate from database auto-increment
2. **API Enhancement**: Modified `generateNomorSurat()` to use sequence numbers instead of database IDs
3. **UI Enhancement**: Added sequence number field with regenerate button in edit form
4. **Helper Functions**: Added `extractSequenceFromNomorSurat()` to parse existing letter numbers
5. **Real-time Regeneration**: JavaScript to regenerate letter numbers when sequence changes

## Benefits:

- ✅ **Flexible Numbering**: Letter numbers no longer tied to database IDs
- ✅ **Easy Editing**: Simple interface to change letter sequence numbers
- ✅ **Backward Compatible**: Existing letters work without changes
- ✅ **Consistent Format**: Maintains proper letter number formats for all types
- ✅ **Real-time Updates**: Immediate regeneration when sequence changes

## Usage Instructions:

1. Edit any existing letter
2. Find the "Letter ID (Sequence Number)" field
3. Enter the desired sequence number (e.g., 150 for SK becomes `DKU.JPT.PG.04.03.150`)
4. Click "Regenerate" to see the new letter number
5. Save the form to apply changes

The system will automatically handle the different formats for SK, KPTS, and SE letter types!