# Jenis dan Subjenis Surat - Reference Documentation

## Overview
This document provides a comprehensive reference for all letter types (`jenis_surat`) and letter subtypes (`subjenis_surat`) used in the Jasa Marga document management system.

---

## Table of Contents
1. [Klasifikasi Arsip (Archive Classification)](#klasifikasi-arsip)
2. [Jenis Surat (Letter Types)](#jenis-surat)
3. [Subjenis Surat (Letter Subtypes)](#subjenis-surat)

---

## Klasifikasi Arsip

### Definition
`klasifikasi_arsip` represents the archive classification system used to categorize and organize all documents within the organization. This is the top-level classification that contains the letter types (jenis_surat) and letter subtypes (subjenis_surat).

**Table Structure:**
- `id`: Unique identifier (bigint)
- `kode`: Code/Reference (varchar)
- `nama`: Name/Description
- `deskripsi`: Detailed description
- `is_active`: Active status (1 = active, 0 = inactive)
- `created_at`: Creation timestamp
- `updated_at`: Last update timestamp

### All Klasifikasi Arsip Records

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 1 | PR | PERANCANGAN | Klasifikasi PERANCANGAN |
| 2 | IN | INVESTASI | Klasifikasi INVESTASI |
| 3 | PP | PEMBANGUNAN DAN PENGEMBANGAN | Klasifikasi PEMBANGUNAN DAN PENGEMBANGAN |
| 4 | PG | PENGADAAN | Klasifikasi PENGADAAN |
| 5 | OM | OPERASIONAL DAN PEMELIHARAAN | Klasifikasi OPERASIONAL DAN PEMELIHARAAN |
| 6 | KU | KEUANGAN | Klasifikasi KEUANGAN |
| 7 | PN | PERENCANAAN | Klasifikasi PERENCANAAN |
| 8 | TI | TEKNOLOGI INFORMASI | Klasifikasi TEKNOLOGI INFORMASI |
| 9 | CD | COMMUNITY DEVELOPMENT (BINA LINGKUNGAN) | Klasifikasi COMMUNITY DEVELOPMENT (BINA LINGKUNGAN) |
| 10 | HC | HUMAN CAPITAL (MODAL INSANI) | Klasifikasi HUMAN CAPITAL (MODAL INSANI) |
| 11 | HK | HUKUM | Klasifikasi HUKUM |
| 12 | KR | ADMINISTRASI PERKANTORAN | Klasifikasi ADMINISTRASI PERKANTORAN |
| 13 | KA | KEARSIPAN | Klasifikasi KEARSIPAN |
| 14 | PL | PERLENGKAPAN | Klasifikasi PERLENGKAPAN |
| 15 | OT | ORGANISASI DAN TRANSFORMASI | Klasifikasi ORGANISASI DAN TRANSFORMASI |
| 16 | DL | PEMBELAJARAN DAN PENGEMBANGAN | Klasifikasi PEMBELAJARAN DAN PENGEMBANGAN |
| 17 | HM | HUBUNGAN MASYARAKAT | Klasifikasi HUBUNGAN MASYARAKAT |
| 18 | MR | MANAJEMEN RESIKO | Klasifikasi MANAJEMEN RESIKO |
| 19 | MM | MANAJEMEN MUTU | Klasifikasi MANAJEMEN MUTU |
| 20 | PW | PENGAWASAN | Klasifikasi PENGAWASAN |

---

## Jenis Surat

### Definition
`jenis_surat` represents the primary classification category for letters/documents in the system.

**Table Structure:**
- `id`: Unique identifier (bigint)
- `kode`: Code/Reference (varchar)
- `nama`: Name/Description
- `deskripsi`: Detailed description
- `is_active`: Active status (1 = active, 0 = inactive)
- `created_at`: Creation timestamp
- `updated_at`: Last update timestamp
- `id_klasifikasi`: Classification ID reference

---

### Jenis Surat by Classification

#### Classification 1: Studi dan Survey
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 1 | 01 | Studi dan Survey | Jenis Surat: Studi dan Survey |
| 2 | 02 | Rencana Teknik | Jenis Surat: Rencana Teknik |

#### Classification 2: Portfolio Management & Offerings
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 3 | 01 | Manajemen Portfolio | Jenis Surat: Manajemen Portfolio |
| 4 | 02 | Penawaran Melalui Tender | Jenis Surat: Penawaran Melalui Tender |
| 5 | 03 | Penawaran Non Tender | Jenis Surat: Penawaran Non Tender |
| 6 | 04 | Tender yang Ditolak | Jenis Surat: Tender yang Ditolak |
| 7 | 05 | Pembentukan Organisasi Pelaksana (PT Baru) | Jenis Surat: Pembentukan Organisasi Pelaksana (PT Baru) |
| 8 | 06 | Penanaman Modal Jalan Tol/Usaha Lain | Jenis Surat: Penanaman Modal Jalan Tol/Usaha Lain |
| 9 | 07 | Investasi Perusahaan | Jenis Surat: Investasi Perusahaan |
| 10 | 08 | Penyertaan Modal Pemerintah | Jenis Surat: Penyertaan Modal Pemerintah |

#### Classification 3: Legal & Concessions
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 11 | 01 | Konsesi | Jenis Surat: Konsesi |
| 12 | 02 | Lainnya | Jenis Surat: Lainnya |
| 13 | 03 | Manajemen Proyek | Jenis Surat: Manajemen Proyek |

#### Classification 4: Procurement
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 14 | 01 | Kajian dan Perencanaan | Jenis Surat: Kajian dan Perencanaan |
| 15 | 02 | Daftar Rekanan Jasa Marga | Jenis Surat: Daftar Rekanan Jasa Marga |
| 16 | 03 | Pemilihan Penyedia Barang dan Jasa | Jenis Surat: Pemilihan Penyedia Barang dan Jasa |
| 17 | 04 | Pelaksanaan Pengadaan Barang dan Jasa | Jenis Surat: Pelaksanaan Pengadaan Barang dan Jasa |

#### Classification 5: Operations
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 18 | 01 | Pelayanan Transaksi | Jenis Surat: Pelayanan Transaksi |
| 19 | 02 | Pelayanan Lalu Lintas | Jenis Surat: Pelayanan Lalu Lintas |
| 20 | 03 | Pemeliharaan | Jenis Surat: Pemeliharaan |
| 21 | 04 | Operation Technology System | Jenis Surat: Operation Technology System |

#### Classification 6: Finance & Budgeting
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 22 | 01 | Penyusunan Anggaran | Jenis Surat: Penyusunan Anggaran |
| 23 | 02 | Penetapan Anggaran | Jenis Surat: Penetapan Anggaran |
| 24 | 03 | Revisi Anggaran | Jenis Surat: Revisi Anggaran |
| 25 | 04 | Pengendalian Anggaran | Jenis Surat: Pengendalian Anggaran |
| 26 | 05 | Evaluasi/Pengawasan Anggaran | Jenis Surat: Evaluasi/Pengawasan Anggaran |
| 27 | 06 | Pembiayaan/Pembayaran | Jenis Surat: Pembiayaan/Pembayaran |
| 28 | 07 | Asuransi | Jenis Surat: Asuransi |
| 29 | 08 | Tuntutan Ganti Rugi | Jenis Surat: Tuntutan Ganti Rugi |
| 30 | 09 | Surat-Surat Berharga | Jenis Surat: Surat-Surat Berharga |
| 31 | 10 | Penggalian Dana dan Kewajiban | Jenis Surat: Penggalian Dana dan Kewajiban |
| 32 | 11 | Transaksi Bank | Jenis Surat: Transaksi Bank |
| 33 | 12 | Pendapatan | Jenis Surat: Pendapatan |
| 34 | 13 | Distribusi Data | Jenis Surat: Distribusi Data |
| 35 | 14 | Akuntansi | Jenis Surat: Akuntansi |

#### Classification 7: Planning & Performance
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 36 | 01 | Perencanaan Perusahaan | Jenis Surat: Perencanaan Perusahaan |
| 37 | 02 | Rencana Kerja Tahunan | Jenis Surat: Rencana Kerja Tahunan |
| 38 | 03 | Penyusunan Key Performance Indicator (KPI) | Jenis Surat: Penyusunan Key Performance Indicator (KPI) |
| 39 | 04 | Penilaian Kinerja Perusahaan (Key Performance Indicator) | Jenis Surat: Penilaian Kinerja Perusahaan (Key Performance Indicator) |
| 40 | 05 | Evaluasi Program | Jenis Surat: Evaluasi Program |
| 41 | 06 | Laporan | Jenis Surat: Laporan |

#### Classification 8: Information Technology
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 42 | 01 | Laporan Teknologi Informasi | Jenis Surat: Laporan Teknologi Informasi |
| 43 | 02 | Master Plan Teknologi Informasi | Jenis Surat: Master Plan Teknologi Informasi |
| 44 | 03 | Sistem Informasi dan Aplikasi | Jenis Surat: Sistem Informasi dan Aplikasi |
| 45 | 04 | Infrastruktur Teknologi Informasi | Jenis Surat: Infrastruktur Teknologi Informasi |
| 46 | 05 | Perekaman dan Pemutakhiran Data | Jenis Surat: Perekaman dan Pemutakhiran Data |
| 47 | 06 | Dokumen Hosting | Jenis Surat: Dokumen Hosting |
| 48 | 07 | Back Up Data Digital | Jenis Surat: Back Up Data Digital |

#### Classification 9: Partnership & Community
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 49 | 01 | Permohonan dan Pemberian Pindahan Mitra Binaan | Jenis Surat: Permohonan dan Pemberian Pindahan Mitra Binaan |
| 50 | 02 | Pembinaan Kemitraan | Jenis Surat: Pembinaan Kemitraan |
| 51 | 03 | Program Bina Lingkungan | Jenis Surat: Program Bina Lingkungan |

#### Classification 10: Human Resources
| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 52 | 01 | Employee Capacity Planning (Perencanaan Karyawan) | Jenis Surat: Employee Capacity Planning (Perencanaan Karyawan) |
| 53 | 02 | Talent Classification | Jenis Surat: Talent Classification |
| 54 | 03 | Talent Acquisition (Proses Rekruitmen dan Seleksi Karyawan Baru) | Jenis Surat: Talent Acquisition (Proses Rekruitmen dan Seleksi Karyawan Baru) |
| 55 | 04 | Talent Mobility (Mobilitas Karyawan) | Jenis Surat: Talent Mobility (Mobilitas Karyawan) |
| 56 | 05 | Pendelegasian Wewenang | Jenis Surat: Pendelegasian Wewenang |
| 57 | 06 | Penugasan Karyawan | Jenis Surat: Penugasan Karyawan |
| 58 | 07 | Data Karyawan | Jenis Surat: Data Karyawan |
| 59 | 08 | Berkas Perseorangan (Personal file) | Jenis Surat: Berkas Perseorangan (Personal file) |
| 60 | 09 | Berkas Perorangan (Personal file) Direksi, Dewan Pengawas, Dewan Komisaris | Jenis Surat: Berkas Perorangan (Personal file) Direksi, Dewan Pengawas, Dewan Komisaris |
| 61 | 10 | Pembinaan Karyawan | Jenis Surat: Pembinaan Karyawan |
| 62 | 11 | Reward and Recognition (Kesejahteraan dan Penghargaan Karyawan) | Jenis Surat: Reward and Recognition (Kesejahteraan dan Penghargaan Karyawan) |
| 63 | 12 | Pemberhentian/Pemutusan Hubungan Kerja | Jenis Surat: Pemberhentian/Pemutusan Hubungan Kerja |

---

## Subjenis Surat

### Definition
`subjenis_surat` represents the secondary classification or subcategory for letters/documents. Each subjenis belongs to a specific jenis (parent category).

**Table Structure:**
- `id`: Unique identifier (int)
- `kode`: Code/Reference (varchar)
- `nama`: Name/Description
- `deskripsi`: Detailed description
- `id_jenis`: Parent jenis_surat ID (foreign key)
- `id_klasifikasi`: Classification ID reference
- `created_at`: Creation timestamp

---

### Subjenis Surat by Jenis Category

#### Subjenis for Jenis ID 1: Studi dan Survey

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 1 | 01 | Pra Studi Kelayakan Jalan Tol | Subjenis Surat: Pra Studi Kelayakan Jalan Tol |
| 2 | 02 | Pra Studi Non Jalan Tol | Subjenis Surat: Pra Studi Non Jalan Tol |
| 3 | 03 | Studi Kelayakan (Feasibility Study) | Subjenis Surat: Studi Kelayakan (Feasibility Study) |
| 4 | 04 | Studi Analisa dan Dampak Lingkungan (AMDAL) | Subjenis Surat: Studi Analisa dan Dampak Lingkungan (AMDAL) |
| 5 | 05 | Studi Evaluasi Lingkungan (SEL) | Subjenis Surat: Studi Evaluasi Lingkungan (SEL) |
| 6 | 06 | Studi Pengembangan Jalan Tol | Subjenis Surat: Studi Pengembangan Jalan Tol |
| 7 | 07 | Studi Non Jalan Tol | Subjenis Surat: Studi Non Jalan Tol |
| 8 | 08 | Survel Jalan Tol | Subjenis Surat: Survel Jalan Tol |
| 9 | 09 | Survel Non Jalan Tol | Subjenis Surat: Survel Non Jalan Tol |
| 10 | 10 | Laporan | Subjenis Surat: Laporan |

#### Subjenis for Jenis ID 2: Rencana Teknik

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 11 | 01 | Administrasi Perencanaan Teknik | Subjenis Surat: Administrasi Perencanaan Teknik |
| 12 | 02 | Laporan Rencana Teknik | Subjenis Surat: Laporan Rencana Teknik |
| 13 | 03 | Gambar Rencana Teknik | Subjenis Surat: Gambar Rencana Teknik |
| 14 | 04 | Hasil Akhir Rencana Teknik | Subjenis Surat: Hasil Akhir Rencana Teknik |

#### Subjenis for Jenis ID 12: Lainnya

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 15 | 01 | Pembebasan Tanah | Subjenis Surat: Pembebasan Tanah |
| 16 | 02 | Pembayaran Ganti Rugi Tanah | Subjenis Surat: Pembayaran Ganti Rugi Tanah |
| 17 | 03 | Pengalihan Hak Atas Tanah | Subjenis Surat: Pengalihan Hak Atas Tanah |
| 18 | 04 | Sengketa Tanah | Subjenis Surat: Sengketa Tanah |

#### Subjenis for Jenis ID 13: Manajemen Proyek

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 19 | 01 | Persiapan Pembangunan | Subjenis Surat: Persiapan Pembangunan |
| 20 | 02 | Pembangunan Jalan/Jembatan | Subjenis Surat: Pembangunan Jalan/Jembatan |
| 21 | 03 | Pengedalian Pelaksanaan | Subjenis Surat: Pengedalian Pelaksanaan |
| 22 | 04 | Serah Terima Pembangunan | Subjenis Surat: Serah Terima Pembangunan |

#### Subjenis for Jenis ID 14: Kajian dan Perencanaan

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 23 | 01 | Kajian Pengadaan Barang/Jasa | Subjenis Surat: Kajian Pengadaan Barang/Jasa |
| 24 | 02 | Perencanaan Pengadaan Barang dan Jasa | Subjenis Surat: Perencanaan Pengadaan Barang dan Jasa |

#### Subjenis for Jenis ID 16: Pemilihan Penyedia Barang dan Jasa

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 25 | 01 | Penyedia Barang | Subjenis Surat: Penyedia Barang |
| 26 | 02 | Penyedia Pekerjaan Konstruksi | Subjenis Surat: Penyedia Pekerjaan Konstruksi |
| 27 | 03 | Penyedia Jasa Konsultansi | Subjenis Surat: Penyedia Jasa Konsultansi |
| 28 | 04 | Penyedia Jasa Lain | Subjenis Surat: Penyedia Jasa Lain |

#### Subjenis for Jenis ID 17: Pelaksanaan Pengadaan Barang dan Jasa

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 29 | 01 | Pengadaan Barang | Subjenis Surat: Pengadaan Barang |
| 30 | 02 | Pengadaan Pekerjaan Konstruksi | Subjenis Surat: Pengadaan Pekerjaan Konstruksi |
| 31 | 03 | Pengadaan Jasa Konsultansi | Subjenis Surat: Pengadaan Jasa Konsultansi |
| 32 | 04 | Pengadaan Jasa Lain | Subjenis Surat: Pengadaan Jasa Lain |

#### Subjenis for Jenis ID 18: Pelayanan Transaksi

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 33 | 01 | Perencanaan Layanan Transakal | Subjenis Surat: Perencanaan Layanan Transakal |
| 34 | 02 | Kartu Tol | Subjenis Surat: Kartu Tol |
| 35 | 03 | Bukti Pendapatan Tol | Subjenis Surat: Bukti Pendapatan Tol |
| 36 | 04 | Laporan Volume Lalu Lintas dan Pendapatan Tol | Subjenis Surat: Laporan Volume Lalu Lintas dan Pendapatan Tol |

#### Subjenis for Jenis ID 19: Pelayanan Lalu Lintas

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 37 | 01 | Perencanaan Layanan Lalu Lintas | Subjenis Surat: Perencanaan Layanan Lalu Lintas |
| 38 | 02 | Pelayanan Lalu Lintas | Subjenis Surat: Pelayanan Lalu Lintas |
| 39 | 03 | Sarana Pengaturan Lalu Lintas | Subjenis Surat: Sarana Pengaturan Lalu Lintas |
| 40 | 04 | Kecelakaan Lalu Lintas | Subjenis Surat: Kecelakaan Lalu Lintas |
| 41 | 05 | Keamanan Lalu Lintas | Subjenis Surat: Keamanan Lalu Lintas |
| 42 | 06 | Pelanggaran Lalu Lintas | Subjenis Surat: Pelanggaran Lalu Lintas |

#### Subjenis for Jenis ID 20: Pemeliharaan

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 43 | 01 | Jalan dan Jembatan | Subjenis Surat: Jalan dan Jembatan |
| 44 | 02 | Bangunan dan Fasilitas tol | Subjenis Surat: Bangunan dan Fasilitas tol |
| 45 | 03 | Lingkungan | Subjenis Surat: Lingkungan |
| 46 | 04 | Peralatan | Subjenis Surat: Peralatan |
| 47 | 05 | Penerangan Jalan Umum | Subjenis Surat: Penerangan Jalan Umum |
| 48 | 06 | Lalu Lintas | Subjenis Surat: Lalu Lintas |
| 49 | 07 | Sarana Elektronik | Subjenis Surat: Sarana Elektronik |

#### Subjenis for Jenis ID 21: Operation Technology System

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 50 | 01 | Pengadaan Teknologi Pendukung Peralatan Tol | Subjenis Surat: Pengadaan Teknologi Pendukung Peralatan Tol |
| 51 | 02 | Pemeliharaan Peralatan Terpasang | Subjenis Surat: Pemeliharaan Peralatan Terpasang |

#### Subjenis for Jenis ID 22: Penyusunan Anggaran

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 52 | 01 | Rencana Kerja dan Anggaran Unit Kerja (RKAP) | Subjenis Surat: Rencana Kerja dan Anggaran Unit Kerja (RKAP) |
| 53 | 02 | Usulan anggaran dari unit kerja dan regional | Subjenis Surat: Usulan anggaran dari unit kerja dan regional |

#### Subjenis for Jenis ID 23: Penetapan Anggaran

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 54 | 01 | Rencana Kerja dan Anggaran Unit Kerja (RKAP) | Subjenis Surat: Rencana Kerja dan Anggaran Unit Kerja (RKAP) |
| 55 | 02 | Mutasi anggaran | Subjenis Surat: Mutasi anggaran |

#### Subjenis for Jenis ID 25: Pengendalian Anggaran

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 56 | 01 | Mutasi anggaran | Subjenis Surat: Mutasi anggaran |
| 57 | 02 | Administrasi Pengendalian Anggaran | Subjenis Surat: Administrasi Pengendalian Anggaran |

#### Subjenis for Jenis ID 27: Asuransi

| ID | Kode | Nama | Deskripsi |
|---|---|---|---|
| 58 | 01 | Tagihan | Subjenis Surat: Tagihan |

---

## Usage Notes

### Important Relationships
- Each `subjenis_surat` record has a parent `jenis_surat` via `id_jenis` field
- Both tables reference `id_klasifikasi` for archive classification purposes
- The hierarchical structure allows for better document organization and retrieval

### Active Records
All records in both tables have `is_active = 1`, indicating they are currently active in the system.

### Code Format
- Both tables use sequential numeric codes with zero-padding (01, 02, 03, etc.)
- Codes are not globally unique but are unique within their classification category

### Database Constraints
- Foreign key relationships exist between `subjenis_surat.id_jenis` and `jenis_surat.id`
- Both tables maintain timestamp audit trails via `created_at` and `updated_at` fields

---

## Related Files
- Database Schema: [migrations/jasa_marga.sql](../migrations/jasa_marga.sql)
- Letter Management: [user/edit-letter.php](../user/edit-letter.php)
- API Endpoints: [api/](../api/)

