<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['check_username'])) {
        // Proses validasi username
        $username = $_POST['username'];
        $sql = "SELECT * FROM users WHERE username = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $_SESSION['reset_username'] = $username; // Simpan username untuk langkah berikutnya
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Username tidak ditemukan!']);
        }
        exit();
    } elseif (isset($_POST['reset_password'])) {
        // Proses reset password
        $username = $_SESSION['reset_username'] ?? null;
        $new_password = password_hash($_POST['new_password'], PASSWORD_DEFAULT);

        if ($username) {
            $sql = "UPDATE users SET password = ? WHERE username = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $new_password, $username);
            if ($stmt->execute()) {
                unset($_SESSION['reset_username']); // Hapus sesi reset username
                echo json_encode(['status' => 'success', 'message' => 'Password berhasil diperbarui!']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Terjadi kesalahan saat memperbarui password!']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Sesi reset tidak valid!']);
        }
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Registrasi</title>
    <link rel="icon" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-32x32.png" type="image/x-icon">
    <meta name="msapplication-TileImage" content="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-144x144.png">
    <link rel="apple-touch-icon-precomposed" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-152x152.png">
    <link rel="logo" sizes="180x180" href="public/assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="32x32" href="public/assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="public/assets/images/logo.png">

    <link rel="stylesheet" href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css'>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="css/stylelogin2.css">
    <style>
        .alert {
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }

        .alert.show {
            opacity: 1;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <span class="rotate-bg"></span>
        <span class="rotate-bg2"></span>
        <div class="form-box reset">
            <h2 class="title animation mt-4" style="--i:0; --j:21">Lupa Password</h2>
            <!-- Form cek username -->
            <form id="usernameForm" method="POST">
                <div class="input-box animation" style="--i:1; --j:22">
                    <input type="text" name="username" id="usernameInput" required>
                    <label for="">Username</label>
                    <i class='bx bxs-user'></i>
                </div>
                <button type="button" id="checkUsernameButton" class="btn animation" style="--i:3; --j:24; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Cek Username</button>
            </form>

            <!-- Form reset password -->
            <form id="passwordForm" method="POST" style="display: none;">
                <div class="input-box animation" style="--i:1; --j:22">
                    <input type="password" name="new_password" id="newPasswordInput" required>
                    <label for="">Password Baru</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <div class="input-box animation" style="--i:2; --j:23">
                    <input type="password" name="confirm_password" id="confirmPasswordInput" required>
                    <label for="">Konfirmasi Password</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <button type="button" id="resetPasswordButton" class="btn animation" style="--i:3; --j:24; background-color: rgba(0, 255, 0); color: white; border-radius: 100px;">Reset Password</button>
            </form>

            <div id="messageBox" style="margin-top: 10px;"></div>
        </div>

        <div class="info-text login">
            <p class="animation" style="--i:1; --j:21">Atur ulang password Anda dengan memasukkan username terdaftar, password baru, dan konfirmasi password. Pastikan password baru Anda aman dan mudah diingat.</p>
        </div>

        <div class="form-box register">
            <h2 class="title animation mt-4" style="--i:17; --j:0">Daftar</h2>
            <form action="#" method="POST"> <!-- Menambahkan method POST -->
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="name" required>
                    <label for="">Nama</label>
                    <i class='bx bxs-user-plus'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="username" required>
                    <label for="">Username</label>
                    <i class='bx bxs-user'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <div class="input-box animation" style="--i:19; --j:2">
                    <input type="email" name="email" required>
                    <label for="">Email</label>
                    <i class='bx bxs-envelope'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="phone" required>
                    <label for="">Telepon</label>
                    <i class='bx bxs-phone'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <select name="gender" required>
                        <option value="male">Gender: Laki-laki</option>
                        <option value="female">Gender: Perempuan</option>
                    </select>
                    <i class='bx bx-male-female'></i>
                </div>
                <button type="submit" class="btn animation" style="--i:21;--j:4; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Daftar</button>
                <div class="linkTxt animation" style="--i:22; --j:5">
                    <p>Sudah punya akun? <a href="#" class="login-link mb-4" style="color: orange;"><strong>Login</strong></a></p>
                </div>
            </form>
        </div>

        <div class="info-text register">
            <h2 class="animation" style="--i:17; --j:0;">Buat Akun Baru</h2>
            <p class="animation" style="--i:18; --j:1;">Daftarkan diri Anda untuk mulai mengakses dan mengelola arsip dokumen PT Jasamarga Pandaan Tol secara mudah dan cepat.</p>
        </div>
    </div>
    <script>
        // Menghilangkan pesan error setelah beberapa detik dengan transisi
        setTimeout(function() {
            const alert = document.querySelector('.alert');
            if (alert) {
                alert.classList.remove('show');
            }
        }, 5000); // Menghilang setelah 3 detik
        document.getElementById('checkUsernameButton').addEventListener('click', function() {
            const username = document.getElementById('usernameInput').value;

            fetch('', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: new URLSearchParams({
                        username,
                        check_username: true
                    })
                })
                .then(response => response.json())
                .then(data => {
                    const messageBox = document.getElementById('messageBox');
                    if (data.status === 'success') {
                        messageBox.innerHTML = '<div class="alert alert-success">Username valid, silakan reset password.</div>';
                        document.getElementById('usernameForm').style.display = 'none';
                        document.getElementById('passwordForm').style.display = 'block';
                    } else {
                        messageBox.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
                    }
                });
        });

        document.getElementById('resetPasswordButton').addEventListener('click', function() {
            const newPassword = document.getElementById('newPasswordInput').value;
            const confirmPassword = document.getElementById('confirmPasswordInput').value;

            if (newPassword !== confirmPassword) {
                alert('Password tidak cocok!');
                return;
            }

            fetch('', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: new URLSearchParams({
                        new_password: newPassword,
                        reset_password: true
                    })
                })
                .then(response => response.json())
                .then(data => {
                    const messageBox = document.getElementById('messageBox');
                    if (data.status === 'success') {
                        messageBox.innerHTML = '<div class="alert alert-success">Password berhasil diperbarui! Mengarahkan ke halaman login...</div>';
                        document.getElementById('passwordForm').reset();
                        setTimeout(() => {
                            window.location.href = 'login.php';
                        }, 2000); // Redirect setelah 2 detik
                    } else {
                        messageBox.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
                    }
                });
        });
    </script>
    <script src="js/script.js"></script>
</body>

</html>