<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

$error_message = '';
$otp_sent = false;
$show_otp_form = false;

// Fungsi generate OTP 6 digit
function generateOTP()
{
    return rand(100000, 999999);
}

// Handle OTP Verification
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['otp'])) {
    if ($_POST['otp'] == $_SESSION['otp_code']) {
        $user = $_SESSION['pending_user'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['tipe'] = $user['tipe'];

        unset($_SESSION['otp_code'], $_SESSION['pending_user'], $_SESSION['otp_email_to'], $_SESSION['otp_email_from']);

        // Redirect sesuai tipe
        if ($user['tipe'] === 'admin') {
            header('Location: ../admin/dashboard.php');
        } elseif ($user['tipe'] === 'user') {
            header('Location: ../user/dashboard.php');
        } elseif ($user['tipe'] === 'editor') {
            header('Location: ../user/dashboard.php');
        }
        exit();
    } else {
        $error_message = "Kode OTP salah.";
        $show_otp_form = true;
    }
}

// Handle login + OTP generate
elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username'], $_POST['password'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            // Simpan sementara user login
            $_SESSION['pending_user'] = $user;

            // Ambil email admin (id 1)
            $admin_query = $conn->query("SELECT email FROM users WHERE id = 1");
            $admin = $admin_query->fetch_assoc();

            // Generate OTP dan simpan ke session
            $otp = generateOTP();
            $_SESSION['otp_code'] = $otp;
            $_SESSION['otp_email_to'] = $user['email'];
            $_SESSION['otp_email_from'] = $admin['email'];

            $otp_sent = true;
            $show_otp_form = true;
        } else {
            $error_message = "Password salah. <br><a href='password.php'>Ganti Password</a>";
        }
    } else {
        $error_message = "Username tidak ditemukan!";
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Registrasi</title>
    <link rel="icon" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-32x32.png" type="image/x-icon">
    <meta name="msapplication-TileImage" content="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-144x144.png">
    <link rel="apple-touch-icon-precomposed" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-152x152.png">
    <link rel="logo" sizes="180x180" href="/jasa_marga/img/baru/logojp.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/jasa_marga/img/baru/logojp.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/jasa_marga/img/baru/logojp.png">

    <link rel="stylesheet" href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css'>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="/jasa_marga/css/stylelogin2.css">
    <style>
        .alert {
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }

        .alert.show {
            opacity: 1;
        }
    </style>

</head>

<body>
    <div class="wrapper">
        <span class="rotate-bg"></span>
        <span class="rotate-bg2"></span>
        <div class="form-box login">
            <h2 class="title animation mt-4" style="--i:0; --j:21">Login</h2>

            <?php if ($show_otp_form): ?>
                <!-- OTP Form -->
                <form method="POST" action="">
                    <div class="input-box animation" style="--i:1; --j:22">
                        <input type="text" name="otp" required>
                        <label for="">Kode OTP</label>
                        <i class='bx bx-key'></i>
                    </div>
                    <button type="submit" class="btn animation" style="--i:3; --j:24; background-color: green; color: white; border-radius: 100px;">Verifikasi OTP</button>
                </form>
            <?php else: ?>
                <!-- Login Form -->
                <form action="" method="POST">
                    <div class="input-box animation" style="--i:1; --j:22">
                        <input type="text" name="username" required>
                        <label for="">Username</label>
                        <i class='bx bxs-user'></i>
                    </div>
                    <div class="input-box animation" style="--i:2; --j:23">
                        <input type="password" name="password" required>
                        <label for="">Password</label>
                        <i class='bx bxs-lock-alt'></i>
                    </div>
                    <button type="submit" class="btn animation" style="--i:3; --j:24; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Masuk</button>
                </form>
            <?php endif; ?>

            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger show"><?php echo $error_message; ?></div>
            <?php endif; ?>
        </div>

        <div class="info-text login">
            <p class="animation" style="--i:1; --j:21">
                Akses sistem pengelolaan dan administrasi backend aplikasi. Masukkan akun Anda untuk mengelola data dan fitur website dengan mudah dan aman.
            </p>
        </div>

        <div class="form-box register">
            <h2 class="title animation mt-4" style="--i:17; --j:0">Daftar</h2>
            <form action="#" method="POST"> <!-- Menambahkan method POST -->
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="name" required>
                    <label for="">Nama</label>
                    <i class='bx bxs-user-plus'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="username" required>
                    <label for="">Username</label>
                    <i class='bx bxs-user'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <div class="input-box animation" style="--i:19; --j:2">
                    <input type="email" name="email" required>
                    <label for="">Email</label>
                    <i class='bx bxs-envelope'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="phone" required>
                    <label for="">Telepon</label>
                    <i class='bx bxs-phone'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <select name="gender" required>
                        <option value="male">Gender: Laki-laki</option>
                        <option value="female">Gender: Perempuan</option>
                    </select>
                    <i class='bx bx-male-female'></i>
                </div>
                <button type="submit" class="btn animation" style="--i:21;--j:4; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Daftar</button>
                <div class="linkTxt animation" style="--i:22; --j:5">
                    <p>Sudah punya akun? <a href="#" class="login-link mb-4" style="color: orange;"><strong>Login</strong></a></p>
                </div>
            </form>
        </div>

        <div class="info-text register">
            <h2 class="animation" style="--i:17; --j:0;">Buat Akun Baru</h2>
            <p class="animation" style="--i:18; --j:1;">Daftarkan diri Anda untuk mulai mengakses dan mengelola arsip dokumen PT Jasamarga Pandaan Tol secara mudah dan cepat.</p>
        </div>
    </div>
    <!-- Simulasi kirim OTP via alert -->
    <?php if ($otp_sent): ?>
        <script>
            alert("Kode OTP telah dikirim ke email: <?php echo $_SESSION['otp_email_to']; ?>\nDikirim dari: <?php echo $_SESSION['otp_email_from']; ?>\nKode OTP: <?php echo $_SESSION['otp_code']; ?>");
        </script>
    <?php endif; ?>

    <script>
        // Menghilangkan pesan error setelah beberapa detik dengan transisi
        setTimeout(function() {
            const alert = document.querySelector('.alert');
            if (alert) {
                alert.classList.remove('show');
            }
        }, 5000); // Menghilang setelah 3 detik
    </script>
    <script src="/jasa_marga/js/script.js"></script>
</body>

</html>