<?php
session_start();
require_once 'config/database.php';
require_once 'models/User.php';

// Membuat koneksi database
$database = new Database();
$db = $database->getConnection();

// Membuat objek user dengan koneksi database
$user = new User($db);

$error_message = "";
$success_message = "";

// Proses login
if ($_SERVER["REQUEST_METHOD"] == "POST" && !isset($_POST['name'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Panggil method login
    if ($user->login($username, $password)) {
        // Jika login berhasil
        $success_message = "Login berhasil! Mengarahkan ke dashboard... <i class='fas fa-check-circle'></i>";
        echo "<meta http-equiv='refresh' content='2;url=views/" . $_SESSION['type'] . "/dashboard.php'>";
    } else {
        // Jika login gagal
        $error_message = "<i class='fas fa-exclamation-circle'></i> Username atau password salah! <br><a href='mailto:jasamarga.pandaantol@gmail.com' style='color: #721c24; text-decoration: underline;'>Lupa password?</a>";
    }
}

// Proses sign-up
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['name'])) {
    $data = [
        'name' => $_POST['name'],
        'username' => $_POST['username'],
        'password' => $_POST['password'],
        'email' => $_POST['email'],
        'phone' => $_POST['phone'],
        'gender' => $_POST['gender'],
        'type' => 'user'
    ];

    try {
        // Panggil method createUser
        if ($user->createUser($data)) {
            // Jika akun berhasil dibuat
            $success_message = "<i class='fas fa-check-circle'></i> Akun berhasil dibuat! <br>Siap digunakan";
        } else {
            $error_message = "<i class='fas fa-exclamation-circle'></i> Gagal membuat akun!";
        }
    } catch (PDOException $e) {
        // Tangkap error jika terjadi duplikasi
        if ($e->getCode() == 23000) {
            // Cek pesan error untuk menentukan kolom mana yang duplikat
            $error_message = "<i class='fas fa-exclamation-circle'></i> Gagal membuat akun!";

            if (strpos($e->getMessage(), 'username') !== false) {
                $error_message = "<i class='fas fa-exclamation-circle'></i> Gagal: username sudah terdaftar";
            } elseif (strpos($e->getMessage(), 'uc_email') !== false || strpos($e->getMessage(), 'email') !== false) {
                $error_message = "<i class='fas fa-exclamation-circle'></i> Gagal: email sudah terdaftar";
            } elseif (strpos($e->getMessage(), 'uc_phone') !== false || strpos($e->getMessage(), 'phone') !== false) {
                $error_message = "<i class='fas fa-exclamation-circle'></i> Gagal: nomor telepon sudah terdaftar";
            }
        } else {
            throw $e; // Lempar exception untuk error selain duplikasi
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Registrasi</title>
    <link rel="icon" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-32x32.png" type="image/x-icon">
    <meta name="msapplication-TileImage" content="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-144x144.png">
    <link rel="apple-touch-icon-precomposed" href="https://ptjpt.co.id/wp-content/uploads/2020/01/logo-jpt3-152x152.png">
    <link rel="logo" sizes="180x180" href="public/assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="32x32" href="public/assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="public/assets/images/logo.png">

    <link rel="stylesheet" href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css'>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="public/assets/stylelogin2.css">
    <style>
        .alert {
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }

        .alert.show {
            opacity: 1;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <span class="rotate-bg"></span>
        <span class="rotate-bg2"></span>
        <div class="form-box login">
            <h2 class="title animation mt-4" style="--i:0; --j:21">Login</h2>
            <!-- form login -->
            <form action="" method="POST">
                <div class="input-box animation" style="--i:1; --j:22">
                    <input type="text" name="username" required>
                    <label for="">Username</label>
                    <i class='bx bxs-user'></i>
                </div>
                <div class="input-box animation" style="--i:2; --j:23">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <button type="submit" class="btn animation" style="--i:3; --j:24; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Masuk</button>
                <div class="linkTxt animation" style="--i:5; --j:25">
                    <p>Belum punya akun? <a href="#" class="register-link" style="color: orange;"><strong>Daftar</strong></a></p>
                </div>
            </form>
            <!-- Alert pesan error jika login gagal -->
            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger show">
                    <?php echo $error_message; ?>
                </div>
            <?php endif; ?>

            <!-- Menampilkan pesan sukses -->
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success show">
                    <?php echo $success_message; ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="info-text login">
            <h2 class="animation" style="--i:0; --j:20">Aplikasi Arsip</h2>
            <p class="animation" style="--i:1; --j:21">Akses sistem arsip dokumen PT Jasamarga Pandaan Tol dengan mudah dan cepat. Masukkan akun Anda untuk melanjutkan.</p>
        </div>

        <div class="form-box register">
            <h2 class="title animation mt-4" style="--i:17; --j:0">Daftar</h2>
            <form action="#" method="POST"> <!-- Menambahkan method POST -->
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="name" required>
                    <label for="">Nama</label>
                    <i class='bx bxs-user-plus'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="username" required>
                    <label for="">Username</label>
                    <i class='bx bxs-user'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <i class='bx bxs-lock-alt'></i>
                </div>
                <div class="input-box animation" style="--i:19; --j:2">
                    <input type="email" name="email" required>
                    <label for="">Email</label>
                    <i class='bx bxs-envelope'></i>
                </div>
                <div class="input-box animation" style="--i:18; --j:1">
                    <input type="text" name="phone" required>
                    <label for="">Telepon</label>
                    <i class='bx bxs-phone'></i>
                </div>
                <div class="input-box animation" style="--i:20; --j:3">
                    <select name="gender" required>
                        <option value="male">Gender: Laki-laki</option>
                        <option value="female">Gender: Perempuan</option>
                    </select>
                    <i class='bx bx-male-female'></i>
                </div>
                <button type="submit" class="btn animation" style="--i:21;--j:4; background-color: rgba(0, 0, 255); color: white; border-radius: 100px;">Daftar</button>
                <div class="linkTxt animation" style="--i:22; --j:5">
                    <p>Sudah punya akun? <a href="#" class="login-link mb-4" style="color: orange;"><strong>Login</strong></a></p>
                </div>
            </form>
        </div>

        <div class="info-text register">
            <h2 class="animation" style="--i:17; --j:0;">Buat Akun Baru</h2>
            <p class="animation" style="--i:18; --j:1;">Daftarkan diri Anda untuk mulai mengakses dan mengelola arsip dokumen PT Jasamarga Pandaan Tol secara mudah dan cepat.</p>
        </div>
    </div>
    <script>
        // Menghilangkan pesan error setelah beberapa detik dengan transisi
        setTimeout(function() {
            const alert = document.querySelector('.alert');
            if (alert) {
                alert.classList.remove('show');
            }
        }, 5000); // Menghilang setelah 3 detik
    </script>
    <script src="public/assets/script.js"></script>
</body>

</html>