<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['ok' => false, 'error' => 'Invalid request method']);
    exit;
}

// Check for either pdf_file or signature_file
$file = null;
$uploadType = '';

if (!empty($_FILES['pdf_file'])) {
    $file = $_FILES['pdf_file'];
    $uploadType = 'pdf';
} elseif (!empty($_FILES['signature_file'])) {
    $file = $_FILES['signature_file'];
    $uploadType = 'signature';
} else {
    echo json_encode(['ok' => false, 'error' => 'No file uploaded']);
    exit;
}

if ($file['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['ok' => false, 'error' => 'Upload error']);
    exit;
}

// Determine target directory based on upload type
if ($uploadType === 'signature') {
    $targetBase = __DIR__ . '/../../surat/letter/signatures';
    if (!is_dir($targetBase)) mkdir($targetBase, 0775, true);

    $timestamp = time();
    $safeName  = 'sig_' . $timestamp . '.png';
    $targetAbs = $targetBase . '/' . $safeName;
    $targetRel = 'surat/letter/signatures/' . $safeName;
} else {
    // Default to PDF path
    $targetBase = __DIR__ . '/../../letter/print';
    if (!is_dir($targetBase)) mkdir($targetBase, 0775, true);

    $timestamp = time();
    $safeName  = 'surat_' . $timestamp . '.pdf';
    $targetAbs = $targetBase . '/' . $safeName;
    $targetRel = 'letter/print/' . $safeName;
}

// Simpan file PDF
if (!move_uploaded_file($file['tmp_name'], $targetAbs)) {
    echo json_encode(['ok' => false, 'error' => 'Failed to save file']);
    exit;
}

echo json_encode(['ok' => true, 'path' => $targetRel]);
