<?php
header('Content-Type: application/json; charset=utf-8');

if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    echo json_encode(['error' => 'No file or upload error']);
    exit;
}

$orig = $_FILES['image']['name'];
$ext  = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
$allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

if (!in_array($ext, $allowed, true)) {
    http_response_code(415);
    echo json_encode(['error' => 'Unsupported file type']);
    exit;
}

$dir = __DIR__ . '/../../letter/uploads/lampiran/' . date('Ymd');
if (!is_dir($dir)) mkdir($dir, 0775, true);

$base = preg_replace('/[^a-zA-Z0-9._-]/', '_', pathinfo($orig, PATHINFO_FILENAME));
$fname = $base . '_' . time() . '.' . $ext;
$dest  = $dir . '/' . $fname;

if (!move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to move uploaded file']);
    exit;
}

$publicUrl = '/letter/uploads/lampiran/' . date('Ymd') . '/' . $fname;

echo json_encode(['location' => $publicUrl], JSON_UNESCAPED_SLASHES);
