<?php

declare(strict_types=1);
session_start();
require __DIR__ . '/../includes/koneksi.php';
header('Content-Type: application/json; charset=utf-8');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
$conn->set_charset('utf8mb4');

$jenis_id = isset($_GET['jenis_id']) ? (int)$_GET['jenis_id'] : 0;
$klas_id  = isset($_GET['klas_id'])  ? (int)$_GET['klas_id']  : 0;
if ($jenis_id <= 0 || $klas_id <= 0) {
  echo json_encode(['ok' => false, 'error' => 'bad_params']);
  exit;
}

function get_next_office_id(mysqli $conn): int
{
  $next = 0;
  $sqlAI = "SELECT AUTO_INCREMENT AS ai
            FROM information_schema.TABLES
            WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'office' LIMIT 1";
  if ($res = $conn->query($sqlAI)) {
    if ($row = $res->fetch_assoc()) $next = (int)$row['ai'];
    $res->free();
  }
  if ($next <= 0) {
    $res2 = $conn->query("SELECT IFNULL(MAX(id),0)+1 AS next_id FROM office");
    $row2 = $res2->fetch_assoc();
    $next = (int)($row2['next_id'] ?? 1);
    $res2->free();
  }
  return max(1, $next);
}

function format_nomor_surat(int $jenisId, int $klasId, int $officeNextId): string
{
  return sprintf('%d.%d.%04d', $jenisId, $klasId, $officeNextId);
}

$nextId = get_next_office_id($conn);
$nomor  = format_nomor_surat($jenis_id, $klas_id, $nextId);
echo json_encode(['ok' => true, 'nomor' => $nomor]);
